/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.security.GeoServerSecurityFilterChainProxy;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerSecurityProvider;
import org.geoserver.security.config.SecurityFilterConfig;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerAuthenticationFilter;
import org.geoserver.security.filter.GeoServerSecurityFilter;
import org.geoserver.security.validation.SecurityConfigException;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.SystemTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Category(value={SystemTest.class})
public class GeoServerCustomFilterTest
extends GeoServerSystemTestSupport {
    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add(((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName() + "-context.xml").toString());
    }

    @After
    public void removeCustomFilterConfig() throws Exception {
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        if (secMgr.listFilters().contains("custom")) {
            secMgr.removeFilter((SecurityNamedServiceConfig)secMgr.loadFilterConfig("custom", true));
        }
        secMgr.getSecurityConfig().getFilterChain().remove("custom");
        SecurityManagerConfig mgrConfig = secMgr.getSecurityConfig();
        secMgr.saveSecurityConfig(mgrConfig);
    }

    @Test
    public void testInactive() throws Exception {
        MockHttpServletRequest request = this.createRequest("/foo");
        request.setMethod("GET");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertNull((Object)response.getHeader("foo"));
    }

    void setupFilterEntry(Pos pos, String relativeTo, boolean assertSecurityContext) throws Exception {
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        FilterConfig config = new FilterConfig();
        config.setName("custom");
        config.setClassName(Filter.class.getName());
        config.setAssertAuth(assertSecurityContext);
        secMgr.saveFilter((SecurityNamedServiceConfig)config);
        SecurityManagerConfig mgrConfig = secMgr.getSecurityConfig();
        mgrConfig.setConfigPasswordEncrypterName(this.getPlainTextPasswordEncoder().getName());
        mgrConfig.getFilterChain().remove("custom");
        if (pos == Pos.FIRST) {
            mgrConfig.getFilterChain().insertFirst("/**", "custom");
        }
        if (pos == Pos.LAST) {
            mgrConfig.getFilterChain().insertLast("/**", "custom");
        }
        if (pos == Pos.BEFORE) {
            mgrConfig.getFilterChain().insertBefore("/**", "custom", relativeTo);
        }
        if (pos == Pos.AFTER) {
            mgrConfig.getFilterChain().insertAfter("/**", "custom", relativeTo);
        }
        secMgr.saveSecurityConfig(mgrConfig);
    }

    @Test
    public void testFirst() throws Exception {
        this.setupFilterEntry(Pos.FIRST, null, false);
        MockHttpServletRequest request = this.createRequest("/foo");
        request.setMethod("GET");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((Object)"bar", (Object)response.getHeader("foo"));
    }

    @Test
    public void testLast() throws Exception {
        try {
            this.setupFilterEntry(Pos.LAST, null, true);
            Assert.fail((String)"SecurityConfigException missing, anonymous filter must be the last one");
        }
        catch (SecurityConfigException securityConfigException) {
            // empty catch block
        }
    }

    @Test
    public void testBefore() throws Exception {
        this.setupFilterEntry(Pos.BEFORE, "anonymous", false);
        MockHttpServletRequest request = this.createRequest("/foo");
        request.setMethod("GET");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((Object)"bar", (Object)response.getHeader("foo"));
    }

    @Test
    public void testAfter() throws Exception {
        this.setupFilterEntry(Pos.AFTER, "basic", true);
        MockHttpServletRequest request = this.createRequest("/foo");
        request.setMethod("GET");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((Object)"bar", (Object)response.getHeader("foo"));
    }

    protected List<javax.servlet.Filter> getFilters() {
        return Arrays.asList((javax.servlet.Filter)applicationContext.getBean(GeoServerSecurityFilterChainProxy.class));
    }

    static class Filter
    extends GeoServerSecurityFilter
    implements GeoServerAuthenticationFilter {
        boolean assertAuth = true;

        public void setAssertAuth(boolean assertAuth) {
            this.assertAuth = assertAuth;
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            ((HttpServletResponse)response).setHeader("foo", "bar");
            chain.doFilter(request, response);
        }

        public boolean applicableForHtml() {
            return true;
        }

        public boolean applicableForServices() {
            return true;
        }
    }

    static class FilterConfig
    extends SecurityFilterConfig {
        boolean assertAuth = true;

        FilterConfig() {
        }

        public void setAssertAuth(boolean assertAuth) {
            this.assertAuth = assertAuth;
        }

        public boolean isAssertSecurityContext() {
            return this.assertAuth;
        }
    }

    static class SecurityProvider
    extends GeoServerSecurityProvider {
        SecurityProvider() {
        }

        public Class<? extends GeoServerSecurityFilter> getFilterClass() {
            return Filter.class;
        }

        public GeoServerSecurityFilter createFilter(SecurityNamedServiceConfig config) {
            Filter f = new Filter();
            f.setAssertAuth(((FilterConfig)config).isAssertSecurityContext());
            return f;
        }
    }

    static enum Pos {
        FIRST,
        LAST,
        BEFORE,
        AFTER;

    }
}

