/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.xml;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.easymock.EasyMock;
import org.geoserver.platform.resource.Files;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.auth.UsernamePasswordAuthenticationProvider;
import org.geoserver.security.config.SecurityAuthProviderConfig;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.validation.SecurityConfigException;
import org.geoserver.security.validation.SecurityConfigValidatorTest;
import org.geoserver.security.xml.XMLRoleService;
import org.geoserver.security.xml.XMLRoleServiceConfig;
import org.geoserver.security.xml.XMLSecurityConfigValidator;
import org.geoserver.security.xml.XMLUserGroupService;
import org.geoserver.security.xml.XMLUserGroupServiceConfig;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class XMLSecurityConfigValidatorTest
extends SecurityConfigValidatorTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");

    protected SecurityUserGroupServiceConfig createUGConfig(String name, Class<?> aClass, String encoder, String policyName, String fileName) {
        XMLUserGroupServiceConfig config = new XMLUserGroupServiceConfig();
        config.setName(name);
        config.setClassName(aClass.getName());
        config.setPasswordEncoderName(encoder);
        config.setPasswordPolicyName(policyName);
        config.setCheckInterval(0L);
        config.setFileName(fileName);
        return config;
    }

    protected SecurityRoleServiceConfig createRoleConfig(String name, Class<?> aClass, String adminRole, String fileName) {
        XMLRoleServiceConfig config = new XMLRoleServiceConfig();
        config.setName(name);
        config.setClassName(aClass.getName());
        config.setAdminRoleName(adminRole);
        config.setCheckInterval(0L);
        config.setFileName(fileName);
        return config;
    }

    @Override
    @Test
    public void testRoleConfig() throws IOException {
        super.testRoleConfig();
        XMLRoleServiceConfig config = (XMLRoleServiceConfig)this.createRoleConfig(XMLRoleService.DEFAULT_NAME, XMLRoleService.class, XMLRoleService.DEFAULT_LOCAL_ADMIN_ROLE, "roles.xml");
        XMLSecurityConfigValidator validator = new XMLSecurityConfigValidator(this.getSecurityManager());
        try {
            config.setName("default2");
            config.setCheckInterval(-1L);
            validator.validateAddRoleService((SecurityRoleServiceConfig)config);
            Assert.fail((String)"invalid interval should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"CHECK_INTERVAL_INVALID", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        try {
            config.setCheckInterval(999L);
            validator.validateAddRoleService((SecurityRoleServiceConfig)config);
            Assert.fail((String)"invalid interval should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"CHECK_INTERVAL_INVALID", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setCheckInterval(0L);
        XMLRoleServiceConfig xmlConfig = (XMLRoleServiceConfig)this.createRoleConfig("test1", XMLRoleService.class, XMLRoleService.DEFAULT_LOCAL_ADMIN_ROLE, "test1.xml");
        try {
            validator.validateAddRoleService((SecurityRoleServiceConfig)xmlConfig);
        }
        catch (SecurityConfigException ex) {
            Assert.fail((String)("Should work but got: " + ex.getMessage()));
        }
        if (new XMLSecurityConfigValidator(this.getSecurityManager()).getTempDir() != null) {
            String invalidPath = "abc" + File.separator + "def.xml";
            XMLRoleServiceConfig xmlConfig4 = (XMLRoleServiceConfig)this.createRoleConfig("test4", XMLRoleService.class, XMLRoleService.DEFAULT_LOCAL_ADMIN_ROLE, invalidPath);
            try {
                validator.validateAddRoleService((SecurityRoleServiceConfig)xmlConfig4);
                Assert.fail((String)"file creation failure should occur");
            }
            catch (SecurityConfigException ex) {
                Assert.assertEquals((Object)"FILE_CREATE_FAILED", (Object)ex.getId());
                Assert.assertEquals((Object)invalidPath, (Object)ex.getArgs()[0]);
            }
        }
        GeoServerSecurityManager secMgr = (GeoServerSecurityManager)EasyMock.createNiceMock(GeoServerSecurityManager.class);
        GeoServerRoleService roleService1 = (GeoServerRoleService)EasyMock.createNiceMock(GeoServerRoleService.class);
        EasyMock.expect((Object)roleService1.getRoleCount()).andReturn((Object)0).anyTimes();
        EasyMock.expect((Object)secMgr.loadRoleService("test1")).andReturn((Object)roleService1).anyTimes();
        GeoServerRoleService roleService2 = (GeoServerRoleService)EasyMock.createNiceMock(GeoServerRoleService.class);
        EasyMock.expect((Object)roleService2.getRoleCount()).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)secMgr.loadRoleService("test2")).andReturn((Object)roleService2).anyTimes();
        GeoServerRoleService roleService3 = (GeoServerRoleService)EasyMock.createNiceMock(GeoServerRoleService.class);
        EasyMock.expect((Object)roleService3.getRoleCount()).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)secMgr.loadRoleService("test3")).andReturn((Object)roleService3).anyTimes();
        GeoServerRoleService roleService4 = (GeoServerRoleService)EasyMock.createNiceMock(GeoServerRoleService.class);
        EasyMock.expect((Object)roleService4.getRoleCount()).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)secMgr.loadRoleService("test4")).andReturn((Object)roleService4).anyTimes();
        GeoServerRoleService activeRoleService = (GeoServerRoleService)EasyMock.createNiceMock(GeoServerRoleService.class);
        EasyMock.expect((Object)activeRoleService.getName()).andReturn((Object)"foo").anyTimes();
        EasyMock.expect((Object)secMgr.getActiveRoleService()).andReturn((Object)activeRoleService).anyTimes();
        EasyMock.expect((Object)secMgr.role()).andReturn((Object)Files.asResource((File)this.tempFolder.getRoot())).anyTimes();
        EasyMock.expect((Object)secMgr.listRoleServices()).andReturn(new TreeSet<String>(Arrays.asList("test1", "test2", "test3", "test4"))).anyTimes();
        EasyMock.replay((Object[])new Object[]{roleService1, roleService2, roleService3, roleService4, activeRoleService, secMgr});
        validator = new XMLSecurityConfigValidator(secMgr);
        try {
            validator.validateRemoveRoleService((SecurityRoleServiceConfig)xmlConfig);
        }
        catch (SecurityConfigException ex) {
            Assert.fail((String)("Should work but got: " + ex.getMessage()));
        }
        xmlConfig = (XMLRoleServiceConfig)this.createRoleConfig("test2", XMLRoleService.class, XMLRoleService.DEFAULT_LOCAL_ADMIN_ROLE, "test2.xml");
        try {
            validator.validateRemoveRoleService((SecurityRoleServiceConfig)xmlConfig);
            Assert.fail((String)"non empty role service should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"ROLE_SERVICE_NOT_EMPTY", (Object)ex.getId());
            Assert.assertEquals((Object)"test2", (Object)ex.getArgs()[0]);
        }
        xmlConfig = (XMLRoleServiceConfig)this.createRoleConfig("test3", XMLRoleService.class, XMLRoleService.DEFAULT_LOCAL_ADMIN_ROLE, new File(this.getSecurityManager().role().dir(), "test3.xml").getAbsolutePath());
        try {
            validator.validateRemoveRoleService((SecurityRoleServiceConfig)xmlConfig);
        }
        catch (SecurityConfigException ex) {
            Assert.fail((String)"Should work");
        }
        xmlConfig = (XMLRoleServiceConfig)this.createRoleConfig("test4", XMLRoleService.class, XMLRoleService.DEFAULT_LOCAL_ADMIN_ROLE, "testModify.xml");
        XMLRoleServiceConfig oldXmlConfig = new XMLRoleServiceConfig(xmlConfig);
        try {
            xmlConfig.setValidating(true);
            validator.validateModifiedRoleService((SecurityRoleServiceConfig)xmlConfig, (SecurityRoleServiceConfig)xmlConfig);
        }
        catch (SecurityConfigException ex) {
            Assert.fail((String)"Should work");
        }
        try {
            xmlConfig.setFileName("xyz.xml");
            validator.validateModifiedRoleService((SecurityRoleServiceConfig)xmlConfig, (SecurityRoleServiceConfig)oldXmlConfig);
            Assert.fail((String)"invalid filename change should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"FILENAME_CHANGE_INVALID", (Object)ex.getId());
            Assert.assertEquals((Object)"testModify.xml", (Object)ex.getArgs()[0]);
            Assert.assertEquals((Object)"xyz.xml", (Object)ex.getArgs()[1]);
        }
    }

    @Override
    @Test
    public void testUserGroupConfig() throws IOException {
        super.testUserGroupConfig();
        XMLUserGroupServiceConfig config = (XMLUserGroupServiceConfig)this.createUGConfig(XMLUserGroupService.DEFAULT_NAME, XMLUserGroupService.class, this.getPlainTextPasswordEncoder().getName(), "default", "users.xml");
        XMLSecurityConfigValidator validator = new XMLSecurityConfigValidator(this.getSecurityManager());
        try {
            config.setName("default2");
            config.setCheckInterval(-1L);
            validator.validateAddUserGroupService((SecurityUserGroupServiceConfig)config);
            Assert.fail((String)"invalid check interval should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"CHECK_INTERVAL_INVALID", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        try {
            config.setCheckInterval(999L);
            validator.validateAddUserGroupService((SecurityUserGroupServiceConfig)config);
            Assert.fail((String)"invalid check interval should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"CHECK_INTERVAL_INVALID", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setCheckInterval(0L);
        XMLUserGroupServiceConfig xmlConfig = (XMLUserGroupServiceConfig)this.createUGConfig("test1", XMLUserGroupService.class, this.getPlainTextPasswordEncoder().getName(), "default", "test1.xml");
        try {
            validator.validateAddUserGroupService((SecurityUserGroupServiceConfig)xmlConfig);
        }
        catch (SecurityConfigException ex) {
            Assert.fail((String)("Should work but got: " + ex.getMessage()));
        }
        XMLUserGroupServiceConfig xmlConfig5 = (XMLUserGroupServiceConfig)this.createUGConfig("test5", XMLUserGroupService.class, this.getPlainTextPasswordEncoder().getName(), "default", "abc.xml");
        try {
            validator.validateAddUserGroupService((SecurityUserGroupServiceConfig)xmlConfig5);
        }
        catch (SecurityConfigException ex) {
            Assert.fail((String)("Should work but got: " + ex.getMessage()));
        }
        try {
            xmlConfig5.setFileName("");
            validator.validateAddUserGroupService((SecurityUserGroupServiceConfig)xmlConfig5);
            Assert.fail((String)"empty file name should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"FILENAME_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        if (new XMLSecurityConfigValidator(this.getSecurityManager()).getTempDir() != null) {
            String invalidPath = "abc" + File.separator + "def.xml";
            XMLUserGroupServiceConfig xmlConfig4 = (XMLUserGroupServiceConfig)this.createUGConfig("test4", XMLUserGroupService.class, this.getPlainTextPasswordEncoder().getName(), "default", invalidPath);
            try {
                validator.validateAddUserGroupService((SecurityUserGroupServiceConfig)xmlConfig4);
                Assert.fail((String)"file creation should fail");
            }
            catch (SecurityConfigException ex) {
                Assert.assertEquals((Object)"FILE_CREATE_FAILED", (Object)ex.getId());
                Assert.assertEquals((Object)invalidPath, (Object)ex.getArgs()[0]);
            }
        }
        GeoServerSecurityManager secMgr = (GeoServerSecurityManager)EasyMock.createNiceMock(GeoServerSecurityManager.class);
        EasyMock.expect((Object)secMgr.listAuthenticationProviders()).andReturn(new TreeSet()).anyTimes();
        GeoServerUserGroupService ugService1 = (GeoServerUserGroupService)EasyMock.createNiceMock(GeoServerUserGroupService.class);
        EasyMock.expect((Object)ugService1.getName()).andReturn((Object)"test1").anyTimes();
        EasyMock.expect((Object)secMgr.loadUserGroupService("test1")).andReturn((Object)ugService1).anyTimes();
        GeoServerUserGroupService ugService2 = (GeoServerUserGroupService)EasyMock.createNiceMock(GeoServerUserGroupService.class);
        EasyMock.expect((Object)ugService2.getName()).andReturn((Object)"test2").anyTimes();
        EasyMock.expect((Object)ugService2.getGroupCount()).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)secMgr.loadUserGroupService("test2")).andReturn((Object)ugService2).anyTimes();
        GeoServerUserGroupService ugServiceModify = (GeoServerUserGroupService)EasyMock.createNiceMock(GeoServerUserGroupService.class);
        EasyMock.expect((Object)ugServiceModify.getName()).andReturn((Object)"testModify").anyTimes();
        EasyMock.expect((Object)secMgr.loadUserGroupService("testModify")).andReturn((Object)ugService2).anyTimes();
        EasyMock.expect((Object)secMgr.listUserGroupServices()).andReturn(new TreeSet<String>(Arrays.asList("test1", "test2", "testModify"))).anyTimes();
        EasyMock.expect((Object)secMgr.userGroup()).andReturn((Object)Files.asResource((File)this.tempFolder.getRoot())).anyTimes();
        EasyMock.expect((Object)secMgr.loadPasswordEncoder(this.getPlainTextPasswordEncoder().getName())).andReturn((Object)this.getPlainTextPasswordEncoder()).anyTimes();
        EasyMock.expect((Object)secMgr.listPasswordValidators()).andReturn(new TreeSet<String>(Arrays.asList("default"))).anyTimes();
        EasyMock.replay((Object[])new Object[]{ugService1, ugService2, ugServiceModify, secMgr});
        validator = new XMLSecurityConfigValidator(secMgr);
        try {
            validator.validateRemoveUserGroupService((SecurityUserGroupServiceConfig)xmlConfig);
        }
        catch (SecurityConfigException ex) {
            Assert.fail((String)("Should work but got: " + ex.getMessage()));
        }
        xmlConfig = (XMLUserGroupServiceConfig)this.createUGConfig("test2", XMLUserGroupService.class, this.getPlainTextPasswordEncoder().getName(), "default", "test2.xml");
        try {
            validator.validateRemoveUserGroupService((SecurityUserGroupServiceConfig)xmlConfig);
            Assert.fail((String)"non empty ug service should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"USERGROUP_SERVICE_NOT_EMPTY", (Object)ex.getId());
            Assert.assertEquals((Object)"test2", (Object)ex.getArgs()[0]);
        }
        xmlConfig = (XMLUserGroupServiceConfig)this.createUGConfig("test3", XMLUserGroupService.class, this.getPlainTextPasswordEncoder().getName(), "default", new File(this.getSecurityManager().userGroup().dir(), "test3.xml").getAbsolutePath());
        try {
            validator.validateRemoveUserGroupService((SecurityUserGroupServiceConfig)xmlConfig);
        }
        catch (SecurityConfigException ex) {
            Assert.fail((String)("Should work but got: " + ex.getMessage()));
        }
        xmlConfig = (XMLUserGroupServiceConfig)this.createUGConfig("testModify", XMLUserGroupService.class, this.getPlainTextPasswordEncoder().getName(), "default", "testModify.xml");
        XMLUserGroupServiceConfig oldXmlConfig = new XMLUserGroupServiceConfig(xmlConfig);
        try {
            xmlConfig.setValidating(true);
            validator.validateModifiedUserGroupService((SecurityUserGroupServiceConfig)xmlConfig, (SecurityUserGroupServiceConfig)oldXmlConfig);
        }
        catch (SecurityConfigException ex) {
            Assert.fail((String)("Should work but got: " + ex.getMessage()));
        }
        try {
            xmlConfig.setFileName("xyz.xml");
            validator.validateModifiedUserGroupService((SecurityUserGroupServiceConfig)xmlConfig, (SecurityUserGroupServiceConfig)oldXmlConfig);
            Assert.fail((String)"invalid file name change should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"FILENAME_CHANGE_INVALID", (Object)ex.getId());
            Assert.assertEquals((Object)"testModify.xml", (Object)ex.getArgs()[0]);
            Assert.assertEquals((Object)"xyz.xml", (Object)ex.getArgs()[1]);
        }
    }

    @Override
    @Test
    public void testAuthenticationProvider() throws IOException {
        super.testAuthenticationProvider();
        SecurityAuthProviderConfig config = this.createAuthConfig("default2", UsernamePasswordAuthenticationProvider.class, null);
        XMLSecurityConfigValidator validator = new XMLSecurityConfigValidator(this.getSecurityManager());
        try {
            validator.validateAddAuthProvider(config);
            Assert.fail((String)"no user group service should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"USERGROUP_SERVICE_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
    }
}

