/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.xml;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.geoserver.platform.resource.Files;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.event.RoleLoadedEvent;
import org.geoserver.security.event.RoleLoadedListener;
import org.geoserver.security.impl.AbstractRoleServiceTest;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.Util;
import org.geoserver.security.xml.XMLRoleService;
import org.geoserver.security.xml.XMLRoleServiceConfig;
import org.geoserver.test.SystemTest;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SystemTest.class})
public class XMLRoleServiceTest
extends AbstractRoleServiceTest {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.xml");

    public GeoServerRoleService createRoleService(String serviceName) throws Exception {
        return this.createRoleService(serviceName, "roles.xml");
    }

    @Before
    public void cleraRoleService() throws Exception {
        this.store.clear();
        this.store.store();
    }

    protected GeoServerRoleService createRoleService(String serviceName, String xmlFileName) throws Exception {
        XMLRoleServiceConfig gaConfig = (XMLRoleServiceConfig)this.getSecurityManager().loadRoleServiceConfig(serviceName);
        if (gaConfig == null) {
            gaConfig = new XMLRoleServiceConfig();
            gaConfig.setName(serviceName);
        }
        gaConfig.setClassName(XMLRoleService.class.getName());
        gaConfig.setCheckInterval(1000L);
        gaConfig.setFileName(xmlFileName);
        gaConfig.setValidating(true);
        this.getSecurityManager().saveRoleService((SecurityRoleServiceConfig)gaConfig);
        return this.getSecurityManager().loadRoleService(serviceName);
    }

    @Test
    public void testCopyFrom() throws Exception {
        GeoServerRoleService service1 = this.createRoleService("copyFrom");
        GeoServerRoleService service2 = this.createRoleService("copyTo");
        GeoServerRoleStore store1 = this.createStore(service1);
        GeoServerRoleStore store2 = this.createStore(service2);
        store1.clear();
        this.checkEmpty((GeoServerRoleService)store1);
        this.insertValues(store1);
        Util.copyFrom((GeoServerRoleService)store1, (GeoServerRoleStore)store2);
        store1.clear();
        this.checkEmpty((GeoServerRoleService)store1);
        this.checkValuesInserted((GeoServerRoleService)store2);
    }

    @Test
    public void testDefault() throws Exception {
        GeoServerRoleService service = this.getSecurityManager().loadRoleService(XMLRoleService.DEFAULT_NAME);
        Assert.assertEquals((long)2L, (long)service.getRoles().size());
        GeoServerRole adminRole = service.getRoleByName(XMLRoleService.DEFAULT_LOCAL_ADMIN_ROLE);
        GeoServerRole groupAdminRole = service.getRoleByName(XMLRoleService.DEFAULT_LOCAL_GROUP_ADMIN_ROLE);
        Assert.assertEquals((long)0L, (long)service.getGroupNamesForRole(adminRole).size());
        Assert.assertEquals((long)0L, (long)service.getGroupNamesForRole(groupAdminRole).size());
        Assert.assertEquals((long)1L, (long)service.getUserNamesForRole(adminRole).size());
        Assert.assertEquals((long)0L, (long)service.getUserNamesForRole(groupAdminRole).size());
        Assert.assertEquals((long)1L, (long)service.getRolesForUser("admin").size());
        Assert.assertTrue((boolean)service.getRolesForUser("admin").contains(adminRole));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocking() throws Exception {
        File xmlFile = File.createTempFile("roles", ".xml");
        try {
            FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource("rolesTemplate.xml"), (File)xmlFile);
            GeoServerRoleService service1 = this.createRoleService("locking1", xmlFile.getCanonicalPath());
            GeoServerRoleService service2 = this.createRoleService("locking2", xmlFile.getCanonicalPath());
            GeoServerRoleStore store1 = this.createStore(service1);
            GeoServerRoleStore store2 = this.createStore(service2);
            GeoServerRole role_test1 = store1.createRoleObject("ROLE_TEST");
            GeoServerRole role_test2 = store2.createRoleObject("ROLE_TEST");
            store1.addRole(role_test1);
            String failMessage = "Concurrent lock not allowed";
            boolean fail = true;
            try {
                store2.clear();
            }
            catch (IOException ex) {
                fail = false;
            }
            if (fail) {
                Assert.fail((String)failMessage);
            }
            store1.load();
            store2.addRole(role_test1);
            fail = true;
            try {
                store1.clear();
            }
            catch (IOException ex) {
                fail = false;
            }
            if (fail) {
                Assert.fail((String)failMessage);
            }
            store2.store();
            store1.clear();
            store1.store();
            store1.addRole(role_test1);
            fail = true;
            try {
                store2.associateRoleToGroup(role_test2, "agroup");
            }
            catch (IOException ex) {
                try {
                    store2.disAssociateRoleFromGroup(role_test2, "agroup");
                }
                catch (IOException e) {
                    fail = false;
                }
            }
            if (fail) {
                Assert.fail((String)failMessage);
            }
            fail = true;
            try {
                store2.associateRoleToUser(role_test2, "auser");
            }
            catch (IOException ex) {
                try {
                    store2.disAssociateRoleFromUser(role_test2, "auser");
                }
                catch (IOException e) {
                    fail = false;
                }
            }
            if (fail) {
                Assert.fail((String)failMessage);
            }
            fail = true;
            try {
                store2.updateRole(role_test2);
            }
            catch (IOException ex) {
                try {
                    store2.removeRole(role_test2);
                }
                catch (IOException ex1) {
                    try {
                        store2.addRole(role_test2);
                    }
                    catch (IOException ex2) {
                        fail = false;
                    }
                }
            }
            if (fail) {
                Assert.fail((String)failMessage);
            }
            fail = true;
            try {
                store2.clear();
            }
            catch (IOException ex) {
                try {
                    store2.store();
                }
                catch (IOException e) {
                    fail = false;
                }
            }
            if (fail) {
                Assert.fail((String)failMessage);
            }
            fail = true;
            try {
                store2.setParentRole(role_test1, null);
            }
            catch (IOException ex) {
                fail = false;
            }
            if (fail) {
                Assert.fail((String)failMessage);
            }
        }
        finally {
            xmlFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDynamicReload() throws Exception {
        Files.schedule((long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
        File xmlFile = File.createTempFile("roles", ".xml");
        try {
            FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource("rolesTemplate.xml"), (File)xmlFile);
            GeoServerRoleService service1 = this.createRoleService("reload1", xmlFile.getCanonicalPath());
            GeoServerRoleService service2 = this.createRoleService("reload2", xmlFile.getCanonicalPath());
            GeoServerRoleStore store1 = this.createStore(service1);
            GeoServerRole role_test1 = store1.createRoleObject("ROLE_TEST1");
            this.checkEmpty(service1);
            this.checkEmpty(service2);
            class CheckRoleLoaded
            implements RoleLoadedListener {
                public int notified = 0;

                CheckRoleLoaded() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void rolesChanged(RoleLoadedEvent event) {
                    CheckRoleLoaded checkRoleLoaded = this;
                    synchronized (checkRoleLoaded) {
                        this.notifyAll();
                        ++this.notified;
                    }
                }
            }
            CheckRoleLoaded listener = new CheckRoleLoaded();
            service2.registerRoleLoadedListener((RoleLoadedListener)listener);
            store1.addRole(role_test1);
            store1.store();
            Assert.assertEquals((long)1L, (long)service1.getRoles().size());
            xmlFile.setLastModified(xmlFile.lastModified() + 1000L);
            CheckRoleLoaded checkRoleLoaded = listener;
            synchronized (checkRoleLoaded) {
                if (listener.notified == 0) {
                    listener.wait();
                }
            }
            Assert.assertTrue((String)"notification expected", (listener.notified > 0 ? 1 : 0) != 0);
            Assert.assertEquals((long)1L, (long)service2.getRoles().size());
        }
        finally {
            Files.schedule((long)10L, (TimeUnit)TimeUnit.SECONDS);
            xmlFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisAssociateRoleFromUser() throws Exception {
        Files.schedule((long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
        File xmlFile = File.createTempFile("roles", ".xml");
        try {
            FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource("rolesTemplate.xml"), (File)xmlFile);
            GeoServerRoleService service1 = this.createRoleService("disassociateRole", xmlFile.getCanonicalPath());
            GeoServerRoleStore store1 = this.createStore(service1);
            GeoServerRole role_test1 = store1.createRoleObject("ROLE_TEST1");
            GeoServerRole role_test2 = store1.createRoleObject("ROLE_TEST2");
            this.checkEmpty(service1);
            store1.addRole(role_test1);
            store1.addRole(role_test2);
            store1.store();
            Assert.assertEquals((long)2L, (long)service1.getRoles().size());
            String user = "user1";
            store1.associateRoleToUser(role_test1, user);
            store1.associateRoleToUser(role_test2, user);
            store1.store();
            store1.disAssociateRoleFromUser(role_test1, user);
            store1.disAssociateRoleFromUser(role_test2, user);
            store1.store();
            String xmlContent = new String(java.nio.file.Files.readAllBytes(xmlFile.toPath()));
            Assert.assertTrue((boolean)xmlContent.contains("<userList/>"));
        }
        finally {
            Files.schedule((long)10L, (TimeUnit)TimeUnit.SECONDS);
            xmlFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisAssociateRoleFromGroup() throws Exception {
        Files.schedule((long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
        File xmlFile = File.createTempFile("roles2", ".xml");
        try {
            FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource("rolesTemplate.xml"), (File)xmlFile);
            GeoServerRoleService service1 = this.createRoleService("disassociateRoleFromGroup", xmlFile.getCanonicalPath());
            GeoServerRoleStore store1 = this.createStore(service1);
            GeoServerRole role_test1 = store1.createRoleObject("ROLE_TEST1");
            GeoServerRole role_test2 = store1.createRoleObject("ROLE_TEST2");
            this.checkEmpty(service1);
            store1.addRole(role_test1);
            store1.addRole(role_test2);
            store1.store();
            Assert.assertEquals((long)2L, (long)service1.getRoles().size());
            String group = "group1";
            store1.associateRoleToGroup(role_test1, group);
            store1.associateRoleToGroup(role_test2, group);
            store1.store();
            store1.disAssociateRoleFromGroup(role_test1, group);
            store1.disAssociateRoleFromGroup(role_test2, group);
            store1.store();
            String xmlContent = new String(java.nio.file.Files.readAllBytes(xmlFile.toPath()));
            Assert.assertTrue((boolean)xmlContent.contains("<groupList/>"));
        }
        finally {
            Files.schedule((long)10L, (TimeUnit)TimeUnit.SECONDS);
            xmlFile.delete();
        }
    }
}

