/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.AccessMode;
import org.geoserver.security.SecuredResourceNameChangeListener;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class RuleSyncedNameChangeConcurrencyTest
extends GeoServerSystemTestSupport {
    protected SecuredResourceNameChangeListener securedResourceNameChangeListener;
    static DataAccessRuleDAO dao;
    static Catalog catalog;

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        catalog = this.getCatalog();
        this.setRules();
        dao = DataAccessRuleDAO.get();
        this.securedResourceNameChangeListener = new SecuredResourceNameChangeListener(catalog, dao);
    }

    @Test
    public void testConcurrentChanges() throws Exception {
        String oldLayerName1 = "Lines";
        String newLayerName1 = "Lines_123";
        String oldLayerName2 = "MLines";
        String newLayerName2 = "MLines_123";
        final ResourceInfo resourceInfo1 = catalog.getLayerByName(oldLayerName1).getResource();
        final ResourceInfo resourceInfo2 = catalog.getLayerByName(oldLayerName2).getResource();
        resourceInfo1.setName(newLayerName1);
        resourceInfo2.setName(newLayerName2);
        ExecutorService es = Executors.newCachedThreadPool();
        es.execute(new Runnable(){

            @Override
            public void run() {
                catalog.save(resourceInfo1);
            }
        });
        es.execute(new Runnable(){

            @Override
            public void run() {
                catalog.save(resourceInfo2);
            }
        });
        es.shutdown();
        Assert.assertTrue((boolean)es.awaitTermination(1L, TimeUnit.MINUTES));
        int countOfRulesUpdated = 0;
        for (DataAccessRule rule : dao.getRules()) {
            if (!rule.getLayer().equalsIgnoreCase(newLayerName1) && !rule.getLayer().equalsIgnoreCase(newLayerName2)) continue;
            ++countOfRulesUpdated;
        }
        Assert.assertEquals((long)2L, (long)countOfRulesUpdated);
    }

    private void setRules() throws Exception {
        this.addLayerAccessRule("cgf", "*", AccessMode.WRITE, new String[]{"*"});
        this.addLayerAccessRule("cgf", "Lines", AccessMode.WRITE, new String[]{"*"});
        this.addLayerAccessRule("cgf", "MLines", AccessMode.WRITE, new String[]{"*"});
    }
}

