/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.config.GeoServerConfigPersister;
import org.geoserver.config.GeoServerResourcePersister;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.config.impl.MemoryRoleServiceConfigImpl;
import org.geoserver.security.config.impl.MemoryUserGroupServiceConfigImpl;
import org.geoserver.security.impl.AbstractUserDetailsServiceTest;
import org.geoserver.security.impl.MemoryRoleService;
import org.geoserver.security.impl.MemoryUserGroupService;
import org.geoserver.security.impl.Util;
import org.geoserver.security.password.DecodingUserDetailsService;
import org.geoserver.security.password.GeoServerPlainTextPasswordEncoder;
import org.geoserver.test.SystemTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.security.core.userdetails.UserDetails;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Category(value={SystemTest.class})
public class MemoryUserDetailsServiceTest
extends AbstractUserDetailsServiceTest {
    static final String plainTextRole = "plainrole";
    static final String plainTextUserGroup = "plainuserGroup";

    public GeoServerRoleService createRoleService(String name) throws Exception {
        MemoryRoleServiceConfigImpl config = this.getRoleConfig(name);
        MemoryRoleService service = new MemoryRoleService();
        service.setSecurityManager((GeoServerSecurityManager)GeoServerExtensions.bean(GeoServerSecurityManager.class));
        service.initializeFromConfig((SecurityNamedServiceConfig)config);
        this.getSecurityManager().saveRoleService((SecurityRoleServiceConfig)config);
        return service;
    }

    public MemoryRoleServiceConfigImpl getRoleConfig(String name) {
        MemoryRoleServiceConfigImpl config = new MemoryRoleServiceConfigImpl();
        config.setName(name);
        config.setClassName(MemoryRoleService.class.getName());
        config.setToBeEncrypted(plainTextRole);
        return config;
    }

    public GeoServerUserGroupService createUserGroupService(String name) throws Exception {
        return this.createUserGroupService(name, this.getPBEPasswordEncoder().getName());
    }

    public GeoServerUserGroupService createUserGroupService(String name, String passwordEncoderName) throws Exception {
        MemoryUserGroupServiceConfigImpl config = this.getUserGroupConfg(name, passwordEncoderName);
        MemoryUserGroupService service = new MemoryUserGroupService();
        service.setSecurityManager((GeoServerSecurityManager)GeoServerExtensions.bean(GeoServerSecurityManager.class));
        service.initializeFromConfig((SecurityNamedServiceConfig)config);
        this.getSecurityManager().saveUserGroupService((SecurityUserGroupServiceConfig)config);
        return service;
    }

    public MemoryUserGroupServiceConfigImpl getUserGroupConfg(String name, String passwordEncoderName) {
        MemoryUserGroupServiceConfigImpl config = new MemoryUserGroupServiceConfigImpl();
        config.setName(name);
        config.setClassName(MemoryUserGroupService.class.getName());
        config.setPasswordEncoderName(passwordEncoderName);
        config.setPasswordPolicyName("default");
        config.setToBeEncrypted(plainTextUserGroup);
        return config;
    }

    @Test
    public void testDecodingUserDetailsService() throws Exception {
        GeoServerUserGroupService service = this.createUserGroupService("test");
        DecodingUserDetailsService decService = DecodingUserDetailsService.newInstance((GeoServerUserGroupService)service);
        GeoServerUserGroupStore store = this.createStore(service);
        this.insertValues(store);
        store.store();
        String plainpassword = "geoserver";
        UserDetails admin = service.loadUserByUsername("admin");
        Assert.assertNotEquals((Object)plainpassword, (Object)admin.getPassword());
        UserDetails admin2 = decService.loadUserByUsername("admin");
        Assert.assertEquals((Object)plainpassword, (Object)admin2.getPassword());
    }

    @Test
    public void testCopyFrom() throws Exception {
        GeoServerUserGroupService service1 = this.createUserGroupService("copyFrom");
        GeoServerUserGroupService service2 = this.createUserGroupService("copyTo");
        this.copyFrom(service1, service2);
        service1 = this.createUserGroupService("copyFrom1", this.getPlainTextPasswordEncoder().getName());
        service2 = this.createUserGroupService("copyTo1", this.getPlainTextPasswordEncoder().getName());
        this.copyFrom(service1, service2);
        service1 = this.createUserGroupService("copyFrom2");
        service2 = this.createUserGroupService("copyTo2", this.getDigestPasswordEncoder().getName());
        this.copyFrom(service1, service2);
        service1 = this.createUserGroupService("copyFrom3", this.getDigestPasswordEncoder().getName());
        service2 = this.createUserGroupService("copyTo3", this.getDigestPasswordEncoder().getName());
        this.copyFrom(service1, service2);
        service1 = this.createUserGroupService("copyFrom4", this.getDigestPasswordEncoder().getName());
        service2 = this.createUserGroupService("copyTo4");
        this.copyFrom(service1, service2);
    }

    protected void copyFrom(GeoServerUserGroupService service1, GeoServerUserGroupService service2) throws Exception {
        GeoServerUserGroupStore store1 = this.createStore(service1);
        GeoServerUserGroupStore store2 = this.createStore(service2);
        store1.clear();
        this.checkEmpty((GeoServerUserGroupService)store1);
        this.insertValues(store1);
        Util.copyFrom((GeoServerUserGroupService)store1, (GeoServerUserGroupStore)store2);
        store1.clear();
        this.checkEmpty((GeoServerUserGroupService)store1);
        this.checkValuesInserted((GeoServerUserGroupService)store2);
        store2.clear();
        this.checkEmpty((GeoServerUserGroupService)store2);
    }

    @Test
    public void testEncryption() throws Exception {
        SecurityManagerConfig config = this.getSecurityManager().getSecurityConfig();
        GeoServerPlainTextPasswordEncoder encoder = this.getPlainTextPasswordEncoder();
        String plainprefix = encoder.getPrefix() + ":";
        config.setConfigPasswordEncrypterName(encoder.getName());
        this.getSecurityManager().saveSecurityConfig(config);
        String serviceName = "testEncrypt";
        String cryptprefix = this.getPBEPasswordEncoder().getPrefix() + ":";
        MemoryRoleServiceConfigImpl roleConfig = this.getRoleConfig(serviceName);
        MemoryUserGroupServiceConfigImpl ugConfig = this.getUserGroupConfg(serviceName, this.getPlainTextPasswordEncoder().getName());
        this.getSecurityManager().saveRoleService((SecurityRoleServiceConfig)roleConfig);
        this.getSecurityManager().saveUserGroupService((SecurityUserGroupServiceConfig)ugConfig);
        File roleDir = new File(this.getSecurityManager().get("security/role").dir(), serviceName);
        File ugDir = new File(this.getSecurityManager().get("security/usergroup").dir(), serviceName);
        File roleFile = new File(roleDir, "config.xml");
        File ugFile = new File(ugDir, "config.xml");
        Assert.assertTrue((boolean)roleFile.exists());
        Assert.assertTrue((boolean)ugFile.exists());
        Document ugDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(ugFile);
        Document roleDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(roleFile);
        Element roleElem = (Element)roleDoc.getDocumentElement().getElementsByTagName("toBeEncrypted").item(0);
        Element ugElem = (Element)ugDoc.getDocumentElement().getElementsByTagName("toBeEncrypted").item(0);
        Assert.assertEquals((Object)(plainprefix + plainTextRole), (Object)roleElem.getTextContent());
        Assert.assertEquals((Object)(plainprefix + plainTextUserGroup), (Object)ugElem.getTextContent());
        MemoryRoleService roleService = (MemoryRoleService)this.getSecurityManager().loadRoleService(serviceName);
        Assert.assertEquals((Object)plainTextRole, (Object)roleService.getToBeEncrypted());
        MemoryUserGroupService ugService = (MemoryUserGroupService)this.getSecurityManager().loadUserGroupService(serviceName);
        Assert.assertEquals((Object)plainTextUserGroup, (Object)ugService.getToBeEncrypted());
        config = this.getSecurityManager().getSecurityConfig();
        config.setConfigPasswordEncrypterName(this.getPBEPasswordEncoder().getName());
        this.getSecurityManager().saveSecurityConfig(config);
        this.getSecurityManager().updateConfigurationFilesWithEncryptedFields();
        ugDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(ugFile);
        roleDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(roleFile);
        roleElem = (Element)roleDoc.getDocumentElement().getElementsByTagName("toBeEncrypted").item(0);
        ugElem = (Element)ugDoc.getDocumentElement().getElementsByTagName("toBeEncrypted").item(0);
        Assert.assertTrue((boolean)roleElem.getTextContent().startsWith(cryptprefix));
        Assert.assertTrue((boolean)ugElem.getTextContent().startsWith(cryptprefix));
        roleService = (MemoryRoleService)this.getSecurityManager().loadRoleService(serviceName);
        Assert.assertEquals((Object)plainTextRole, (Object)roleService.getToBeEncrypted());
        ugService = (MemoryUserGroupService)this.getSecurityManager().loadUserGroupService(serviceName);
        Assert.assertEquals((Object)plainTextUserGroup, (Object)ugService.getToBeEncrypted());
    }

    @Test
    public void testEncryption2() throws Exception {
        SecurityManagerConfig config = this.getSecurityManager().getSecurityConfig();
        config.setConfigPasswordEncrypterName(this.getPBEPasswordEncoder().getName());
        this.getSecurityManager().saveSecurityConfig(config);
        String serviceName = "testEncrypt2";
        String prefix = this.getPBEPasswordEncoder().getPrefix() + ":";
        MemoryRoleServiceConfigImpl roleConfig = this.getRoleConfig(serviceName);
        MemoryUserGroupServiceConfigImpl ugConfig = this.getUserGroupConfg(serviceName, this.getPlainTextPasswordEncoder().getName());
        this.getSecurityManager().saveRoleService((SecurityRoleServiceConfig)roleConfig);
        this.getSecurityManager().saveUserGroupService((SecurityUserGroupServiceConfig)ugConfig);
        File roleDir = new File(this.getSecurityManager().get("security/role").dir(), serviceName);
        File ugDir = new File(this.getSecurityManager().get("security/usergroup").dir(), serviceName);
        File roleFile = new File(roleDir, "config.xml");
        File ugFile = new File(ugDir, "config.xml");
        Assert.assertTrue((boolean)roleFile.exists());
        Assert.assertTrue((boolean)ugFile.exists());
        Document ugDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(ugFile);
        Document roleDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(roleFile);
        Element roleElem = (Element)roleDoc.getDocumentElement().getElementsByTagName("toBeEncrypted").item(0);
        Element ugElem = (Element)ugDoc.getDocumentElement().getElementsByTagName("toBeEncrypted").item(0);
        Assert.assertTrue((boolean)roleElem.getTextContent().startsWith(prefix));
        Assert.assertTrue((boolean)ugElem.getTextContent().startsWith(prefix));
        MemoryRoleService roleService = (MemoryRoleService)this.getSecurityManager().loadRoleService(serviceName);
        Assert.assertEquals((Object)plainTextRole, (Object)roleService.getToBeEncrypted());
        MemoryUserGroupService ugService = (MemoryUserGroupService)this.getSecurityManager().loadUserGroupService(serviceName);
        Assert.assertEquals((Object)plainTextUserGroup, (Object)ugService.getToBeEncrypted());
        config.setConfigPasswordEncrypterName(this.getPlainTextPasswordEncoder().getName());
        String plainprefix = this.getPlainTextPasswordEncoder().getPrefix() + ":";
        this.getSecurityManager().saveSecurityConfig(config);
        this.getSecurityManager().updateConfigurationFilesWithEncryptedFields();
        ugDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(ugFile);
        roleDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(roleFile);
        roleElem = (Element)roleDoc.getDocumentElement().getElementsByTagName("toBeEncrypted").item(0);
        ugElem = (Element)ugDoc.getDocumentElement().getElementsByTagName("toBeEncrypted").item(0);
        Assert.assertEquals((Object)(plainprefix + plainTextRole), (Object)roleElem.getTextContent());
        Assert.assertEquals((Object)(plainprefix + plainTextUserGroup), (Object)ugElem.getTextContent());
        roleService = (MemoryRoleService)this.getSecurityManager().loadRoleService(serviceName);
        Assert.assertEquals((Object)plainTextRole, (Object)roleService.getToBeEncrypted());
        ugService = (MemoryUserGroupService)this.getSecurityManager().loadUserGroupService(serviceName);
        Assert.assertEquals((Object)plainTextUserGroup, (Object)ugService.getToBeEncrypted());
    }

    @Test
    public void testPasswordPersistence() throws Exception {
        DataStoreInfo load;
        Catalog cat = this.getCatalog();
        SecurityManagerConfig config = this.getSecurityManager().getSecurityConfig();
        GeoServerPlainTextPasswordEncoder encoder = this.getPlainTextPasswordEncoder();
        String prefix = encoder.getPrefix() + ":";
        config.setConfigPasswordEncrypterName(encoder.getName());
        this.getSecurityManager().saveSecurityConfig(config);
        GeoServerConfigPersister cp = new GeoServerConfigPersister(this.getResourceLoader(), new XStreamPersisterFactory().createXMLPersister());
        GeoServerResourcePersister rp = new GeoServerResourcePersister(cat);
        cat.addListener((CatalogListener)cp);
        cat.addListener((CatalogListener)rp);
        WorkspaceInfo ws = cat.getFactory().createWorkspace();
        ws.setName("password");
        cat.add(ws);
        DataStoreInfo ds = cat.getFactory().createDataStore();
        ds.setName("password");
        ds.getConnectionParameters().put("user", "testuser");
        ds.getConnectionParameters().put("passwd", "secret");
        ds.getConnectionParameters().put("host", "localhost");
        ds.getConnectionParameters().put("port", "5432");
        ds.getConnectionParameters().put("database", "testdb");
        ds.getConnectionParameters().put("dbtype", "postgisng");
        ds.setWorkspace(ws);
        cat.add((StoreInfo)ds);
        File store = new File(this.getDataDirectory().root(), "workspaces/password/password/datastore.xml");
        Document dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(store);
        XPath xpath = XPathFactory.newInstance().newXPath();
        String encrypted = xpath.evaluate("//entry[@key='passwd']", dom.getDocumentElement());
        MatcherAssert.assertThat((Object)encrypted, (Matcher)CoreMatchers.equalTo((Object)(prefix + "secret")));
        XStreamPersister xs = new XStreamPersisterFactory().createXMLPersister();
        try (FileInputStream fin = new FileInputStream(store);){
            load = (DataStoreInfo)xs.load((InputStream)fin, DataStoreInfo.class);
        }
        Assert.assertEquals((Object)"secret", load.getConnectionParameters().get("passwd"));
        config.setConfigPasswordEncrypterName(this.getPBEPasswordEncoder().getName());
        this.getSecurityManager().saveSecurityConfig(config);
        this.getSecurityManager().updateConfigurationFilesWithEncryptedFields();
        dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(store);
        xpath = XPathFactory.newInstance().newXPath();
        encrypted = xpath.evaluate("//entry[@key='passwd']", dom.getDocumentElement());
        xs = new XStreamPersisterFactory().createXMLPersister();
        fin = new FileInputStream(store);
        try {
            load = (DataStoreInfo)xs.load((InputStream)fin, DataStoreInfo.class);
            Assert.assertEquals((Object)"secret", load.getConnectionParameters().get("passwd"));
        }
        finally {
            fin.close();
        }
    }
}

