/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.media.jai.ImageLayout;
import org.easymock.EasyMock;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.CoverageViewReader;
import org.geoserver.catalog.Predicates;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.DefaultSecureDataFactory;
import org.geoserver.security.decorators.SecuredGridCoverage2DReader;
import org.geoserver.security.decorators.SecuredGridFormat;
import org.geoserver.security.decorators.SecuredStructuredGridCoverage2DReader;
import org.geoserver.security.impl.SecureObjectsTest;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.filter.Filter;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.geometry.GeneralBounds;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;

public class SecuredGridCoverage2DReaderTest
extends SecureObjectsTest {
    @Test
    public void testFilter() throws Exception {
        Filter securityFilter = ECQL.toFilter((String)"A > 10");
        Filter requestFilter = ECQL.toFilter((String)"B < 10");
        Format format = this.setupFormat();
        GridCoverage2DReader reader = (GridCoverage2DReader)EasyMock.createNiceMock(GridCoverage2DReader.class);
        EasyMock.expect((Object)reader.getFormat()).andReturn((Object)format).anyTimes();
        SecuredGridCoverage2DReaderTest.setupReadAssertion(reader, requestFilter, securityFilter);
        CoverageAccessLimits accessLimits = new CoverageAccessLimits(CatalogMode.HIDE, securityFilter, null, null);
        SecuredGridCoverage2DReader secured = new SecuredGridCoverage2DReader(reader, WrapperPolicy.readOnlyHide((AccessLimits)accessLimits));
        ParameterValue pv = ImageMosaicFormat.FILTER.createValue();
        pv.setValue((Object)requestFilter);
        secured.read(new GeneralParameterValue[]{pv});
    }

    @Test
    public void testFilterOnStructured() throws Exception {
        Filter securityFilter = ECQL.toFilter((String)"A > 10");
        Filter requestFilter = ECQL.toFilter((String)"B < 10");
        DefaultSecureDataFactory factory = new DefaultSecureDataFactory();
        Format format = this.setupFormat();
        StructuredGridCoverage2DReader reader = (StructuredGridCoverage2DReader)EasyMock.createNiceMock(StructuredGridCoverage2DReader.class);
        EasyMock.expect((Object)reader.getFormat()).andReturn((Object)format).anyTimes();
        SecuredGridCoverage2DReaderTest.setupReadAssertion((GridCoverage2DReader)reader, requestFilter, securityFilter);
        CoverageAccessLimits accessLimits = new CoverageAccessLimits(CatalogMode.HIDE, securityFilter, null, null);
        Object securedObject = factory.secure((Object)reader, WrapperPolicy.readOnlyHide((AccessLimits)accessLimits));
        Assert.assertTrue((boolean)(securedObject instanceof SecuredStructuredGridCoverage2DReader));
        SecuredStructuredGridCoverage2DReader secured = (SecuredStructuredGridCoverage2DReader)securedObject;
        ParameterValue pv = ImageMosaicFormat.FILTER.createValue();
        pv.setValue((Object)requestFilter);
        secured.read(new GeneralParameterValue[]{pv});
    }

    @Test
    public void testCoverageViewSecured() throws Exception {
        DefaultSecureDataFactory factory = new DefaultSecureDataFactory();
        GridCoverage2DReader reader = (GridCoverage2DReader)EasyMock.createNiceMock(GridCoverage2DReader.class);
        EasyMock.expect((Object)reader.getOriginalEnvelope()).andReturn((Object)new GeneralBounds(new double[]{-90.0, -90.0}, new double[]{90.0, 90.0})).anyTimes();
        EasyMock.expect((Object)reader.getOriginalGridRange()).andReturn((Object)new GeneralGridEnvelope(new Rectangle(0, 0, 100, 100))).anyTimes();
        EasyMock.expect((Object)reader.getCoordinateReferenceSystem()).andReturn((Object)DefaultGeographicCRS.WGS84).anyTimes();
        BufferedImage bi = new BufferedImage(100, 100, 10);
        EasyMock.expect((Object)reader.getImageLayout("coverageView")).andReturn((Object)new ImageLayout((RenderedImage)bi)).anyTimes();
        EasyMock.replay((Object[])new Object[]{reader});
        CoverageView coverageView = (CoverageView)EasyMock.createNiceMock(CoverageView.class);
        CoverageInfo coverageInfo = (CoverageInfo)EasyMock.createNiceMock(CoverageInfo.class);
        EasyMock.expect((Object)coverageView.getName()).andReturn((Object)"coverageView").anyTimes();
        CoverageView.CoverageBand coverageBand = new CoverageView.CoverageBand(Collections.singletonList(new CoverageView.InputCoverageBand("coverageView", "band1")), "band1", 0, CoverageView.CompositionType.BAND_SELECT);
        List<CoverageView.CoverageBand> bands = Collections.singletonList(coverageBand);
        EasyMock.expect((Object)coverageView.getCoverageBands()).andReturn(bands).anyTimes();
        EasyMock.expect((Object)coverageView.getBand(0)).andReturn((Object)coverageBand).anyTimes();
        EasyMock.expect((Object)coverageView.getSelectedResolution()).andReturn((Object)CoverageView.SelectedResolution.BEST).anyTimes();
        EasyMock.expect((Object)coverageView.getEnvelopeCompositionType()).andReturn((Object)CoverageView.EnvelopeCompositionType.UNION).anyTimes();
        EasyMock.replay((Object[])new Object[]{coverageView});
        CoverageViewReader viewReader = new CoverageViewReader(reader, coverageView, coverageInfo, null);
        CoverageAccessLimits accessLimits = new CoverageAccessLimits(CatalogMode.HIDE, null, null, null);
        Object securedObject = factory.secure((Object)viewReader, WrapperPolicy.readOnlyHide((AccessLimits)accessLimits));
        Assert.assertTrue((boolean)(securedObject instanceof SecuredGridCoverage2DReader));
        securedObject = factory.secure((Object)viewReader.getFormat(), WrapperPolicy.readOnlyHide((AccessLimits)accessLimits));
        Assert.assertTrue((boolean)(securedObject instanceof SecuredGridFormat));
    }

    private static void setupReadAssertion(GridCoverage2DReader reader, Filter requestFilter, Filter securityFilter) throws IOException {
        EasyMock.expect((Object)reader.read((GeneralParameterValue[])EasyMock.isA(GeneralParameterValue[].class))).andAnswer(() -> {
            GeneralParameterValue[] params = (GeneralParameterValue[])EasyMock.getCurrentArguments()[0];
            ParameterValue param = (ParameterValue)params[0];
            Filter filter = (Filter)param.getValue();
            Assert.assertEquals((Object)Predicates.and((Filter)requestFilter, (Filter)securityFilter), (Object)filter);
            return null;
        });
        EasyMock.replay((Object[])new Object[]{reader});
    }

    private Format setupFormat() {
        Format format = (Format)EasyMock.createNiceMock(Format.class);
        EasyMock.expect((Object)format.getReadParameters()).andReturn((Object)new ImageMosaicFormat().getReadParameters()).anyTimes();
        EasyMock.replay((Object[])new Object[]{format});
        return format;
    }
}

