/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.auth;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.security.auth.AuthenticationCache;
import org.geoserver.security.auth.AuthenticationCacheEntry;
import org.geoserver.security.auth.AuthenticationCacheKey;
import org.geoserver.security.auth.BaseAuthenticationCacheTest;
import org.geoserver.security.auth.LRUAuthenticationCacheImpl;
import org.geoserver.security.auth.LRUCache;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

public class LRUAuthenticationCacheTest
extends BaseAuthenticationCacheTest {
    static final Logger LOGGER = Logging.getLogger(LRUAuthenticationCacheTest.class);

    @Test
    public void testLRUCache() {
        LRUCache cache = new LRUCache(3);
        cache.put((Object)"key1", (Object)"value1");
        cache.put((Object)"key2", (Object)"value2");
        cache.put((Object)"key3", (Object)"value3");
        cache.put((Object)"key4", (Object)"value4");
        Assert.assertEquals((Object)"value2", (Object)cache.get((Object)"key2"));
        Assert.assertEquals((Object)"value3", (Object)cache.get((Object)"key3"));
        Assert.assertEquals((Object)"value4", (Object)cache.get((Object)"key4"));
        Assert.assertNull((Object)cache.get((Object)"key1"));
    }

    @Test
    public void testAuthenticationKey() {
        AuthenticationCacheKey key11 = new AuthenticationCacheKey("f1", "k1");
        Assert.assertEquals((Object)key11, (Object)key11);
        Assert.assertNotEquals((long)key11.hashCode(), (long)0L);
        AuthenticationCacheKey key12 = new AuthenticationCacheKey("f1", "k2");
        Assert.assertNotEquals((Object)key11, (Object)key12);
        Assert.assertNotEquals((long)key11.hashCode(), (long)key12.hashCode());
        AuthenticationCacheKey key21 = new AuthenticationCacheKey("f2", "k1");
        Assert.assertNotEquals((Object)key11, (Object)key21);
        Assert.assertNotEquals((long)key11.hashCode(), (long)key21.hashCode());
        AuthenticationCacheKey key22 = new AuthenticationCacheKey("f12", "k2");
        Assert.assertNotEquals((Object)key11, (Object)key22);
        Assert.assertNotEquals((long)key11.hashCode(), (long)key22.hashCode());
    }

    @Test
    public void testAuthenticationEntry() {
        UsernamePasswordAuthenticationToken t1 = new UsernamePasswordAuthenticationToken((Object)"user1", (Object)"password1");
        AuthenticationCacheEntry entry1 = new AuthenticationCacheEntry((Authentication)t1, 10, 10);
        Assert.assertNotEquals((long)entry1.hashCode(), (long)0L);
        Assert.assertEquals((long)t1.hashCode(), (long)entry1.hashCode());
        Assert.assertEquals((Object)entry1, (Object)entry1);
        AuthenticationCacheEntry entry1_1 = new AuthenticationCacheEntry((Authentication)t1, 20, 20);
        Assert.assertEquals((long)t1.hashCode(), (long)entry1_1.hashCode());
        Assert.assertEquals((Object)entry1, (Object)entry1_1);
        UsernamePasswordAuthenticationToken t2 = new UsernamePasswordAuthenticationToken((Object)"user2", (Object)"password2");
        AuthenticationCacheEntry entry2 = new AuthenticationCacheEntry((Authentication)t2, 5, 10);
        Assert.assertNotEquals((Object)entry2, (Object)entry1);
        long currentTime = entry2.getCreated();
        entry2.setLastAccessed(currentTime + 6000L);
        Assert.assertFalse((boolean)entry2.hasExpired(currentTime + 10000L));
        Assert.assertTrue((boolean)entry2.hasExpired(currentTime + 10000L + 1L));
        entry2.setLastAccessed(currentTime + 2000L);
        Assert.assertFalse((boolean)entry2.hasExpired(currentTime + 7000L));
        Assert.assertTrue((boolean)entry2.hasExpired(currentTime + 70001L));
    }

    protected void fillCache(AuthenticationCache cache) {
        UsernamePasswordAuthenticationToken t1 = new UsernamePasswordAuthenticationToken((Object)"user1", (Object)"password1");
        UsernamePasswordAuthenticationToken t2 = new UsernamePasswordAuthenticationToken((Object)"user2", (Object)"password2");
        UsernamePasswordAuthenticationToken t3 = new UsernamePasswordAuthenticationToken((Object)"user3", (Object)"password3");
        UsernamePasswordAuthenticationToken t4 = new UsernamePasswordAuthenticationToken((Object)"user4", (Object)"password4");
        cache.put("filtera", "key1", (Authentication)t1);
        cache.put("filtera", "key2", (Authentication)t2);
        cache.put("filterb", "key3", (Authentication)t3);
        cache.put("filterb", "key4", (Authentication)t4);
    }

    protected void waitForMilliSecs(long milliSecs) {
        try {
            Thread.sleep(milliSecs);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "", e);
        }
    }

    @Test
    public void testLRUAuthenticationCache() {
        LRUAuthenticationCacheImpl cache = new LRUAuthenticationCacheImpl(5, 10, 3);
        this.fillCache((AuthenticationCache)cache);
        Assert.assertNull((Object)cache.get("filtera", "key1"));
        UsernamePasswordAuthenticationToken token = (UsernamePasswordAuthenticationToken)cache.get("filtera", "key2");
        Assert.assertNotNull((Object)token);
        Assert.assertEquals((Object)"user2", (Object)token.getPrincipal());
        token = (UsernamePasswordAuthenticationToken)cache.get("filterb", "key3");
        Assert.assertNotNull((Object)token);
        Assert.assertEquals((Object)"user3", (Object)token.getPrincipal());
        token = (UsernamePasswordAuthenticationToken)cache.get("filterb", "key4");
        Assert.assertNotNull((Object)token);
        Assert.assertEquals((Object)"user4", (Object)token.getPrincipal());
        cache = new LRUAuthenticationCacheImpl(5, 10, 4);
        this.fillCache((AuthenticationCache)cache);
        cache.removeAll();
        Assert.assertNull((Object)cache.get("filtera", "key1"));
        Assert.assertNull((Object)cache.get("filtera", "key2"));
        Assert.assertNull((Object)cache.get("filterb", "key3"));
        Assert.assertNull((Object)cache.get("filterb", "key4"));
        cache = new LRUAuthenticationCacheImpl(5, 10, 4);
        this.fillCache((AuthenticationCache)cache);
        cache.removeAll("filtera");
        Assert.assertNull((Object)cache.get("filtera", "key1"));
        Assert.assertNull((Object)cache.get("filtera", "key2"));
        Assert.assertNotNull((Object)cache.get("filterb", "key3"));
        Assert.assertNotNull((Object)cache.get("filterb", "key4"));
        cache = new LRUAuthenticationCacheImpl(5, 10, 4);
        this.fillCache((AuthenticationCache)cache);
        cache.remove("filtera", "key1");
        Assert.assertNull((Object)cache.get("filtera", "key1"));
        Assert.assertNotNull((Object)cache.get("filtera", "key2"));
        Assert.assertNotNull((Object)cache.get("filterb", "key3"));
        Assert.assertNotNull((Object)cache.get("filterb", "key4"));
        cache = new LRUAuthenticationCacheImpl(5, 10, 4);
        this.fillCache((AuthenticationCache)cache);
        cache.removeAll("filterz");
        cache.remove("filterz", "key999");
        Assert.assertNotNull((Object)cache.get("filtera", "key1"));
        Assert.assertNotNull((Object)cache.get("filtera", "key2"));
        Assert.assertNotNull((Object)cache.get("filterb", "key3"));
        Assert.assertNotNull((Object)cache.get("filterb", "key4"));
        cache = new LRUAuthenticationCacheImpl(5, 0, 4);
        this.fillCache((AuthenticationCache)cache);
        this.waitForMilliSecs(10L);
        Assert.assertNull((Object)cache.get("filtera", "key1"));
        Assert.assertNull((Object)cache.get("filtera", "key2"));
        Assert.assertNull((Object)cache.get("filterb", "key3"));
        Assert.assertNull((Object)cache.get("filterb", "key4"));
        cache = new LRUAuthenticationCacheImpl(0, 10, 4);
        this.fillCache((AuthenticationCache)cache);
        this.waitForMilliSecs(10L);
        Assert.assertNull((Object)cache.get("filtera", "key1"));
        Assert.assertNull((Object)cache.get("filtera", "key2"));
        Assert.assertNull((Object)cache.get("filterb", "key3"));
        Assert.assertNull((Object)cache.get("filterb", "key4"));
        cache = new LRUAuthenticationCacheImpl(1, 10, 4);
        this.fillCache((AuthenticationCache)cache);
        this.waitForMilliSecs(1L);
        Assert.assertNotNull((Object)cache.get("filtera", "key1"));
        Assert.assertNotNull((Object)cache.get("filtera", "key2"));
        Assert.assertNotNull((Object)cache.get("filterb", "key3"));
        Assert.assertNotNull((Object)cache.get("filterb", "key4"));
        this.waitForMilliSecs(1500L);
        Assert.assertNull((Object)cache.get("filtera", "key1"));
        Assert.assertNull((Object)cache.get("filtera", "key2"));
        Assert.assertNull((Object)cache.get("filterb", "key3"));
        Assert.assertNull((Object)cache.get("filterb", "key4"));
    }

    @Override
    protected AuthenticationCache createAuthenticationCache() {
        return new LRUAuthenticationCacheImpl(1, 2, 1000);
    }
}

