/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.auth;

import org.geoserver.security.GeoServerSecurityTestSupport;
import org.geoserver.security.auth.GeoServerRootAuthenticationProvider;
import org.geoserver.security.password.MasterPasswordProviderConfig;
import org.geoserver.test.SystemTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.RememberMeAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

@Category(value={SystemTest.class})
public class GeoServerRootAuthenticationProviderTest
extends GeoServerSecurityTestSupport {
    @Test
    public void testRootProvider() throws Exception {
        AuthenticationProvider first = (AuthenticationProvider)this.getSecurityManager().getProviders().get(0);
        Assert.assertEquals(GeoServerRootAuthenticationProvider.class, first.getClass());
        GeoServerRootAuthenticationProvider provider = new GeoServerRootAuthenticationProvider();
        provider.setSecurityManager(this.getSecurityManager());
        provider.initializeFromConfig(null);
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"abc", null);
        Assert.assertTrue((boolean)provider.supports(token.getClass()));
        Assert.assertFalse((boolean)provider.supports(RememberMeAuthenticationToken.class));
        Assert.assertNull((Object)provider.authenticate((Authentication)token));
        token = new UsernamePasswordAuthenticationToken((Object)"root", null);
        Assert.assertNull((Object)provider.authenticate((Authentication)token));
        token = new UsernamePasswordAuthenticationToken((Object)"root", (Object)"abc");
        Assert.assertNull((Object)provider.authenticate((Authentication)token));
        String masterPassword = this.getMasterPassword();
        MasterPasswordProviderConfig masterPasswordConfig = this.getSecurityManager().loadMasterPassswordProviderConfig(this.getSecurityManager().getMasterPasswordConfig().getProviderName());
        masterPasswordConfig.setLoginEnabled(true);
        this.getSecurityManager().saveMasterPasswordProviderConfig(masterPasswordConfig);
        token = new UsernamePasswordAuthenticationToken((Object)"root", (Object)masterPassword);
        token.setDetails((Object)"hallo");
        UsernamePasswordAuthenticationToken result = (UsernamePasswordAuthenticationToken)provider.authenticate((Authentication)token);
        Assert.assertNotNull((Object)result);
        Assert.assertNull((Object)result.getCredentials());
        Assert.assertEquals((Object)"root", (Object)result.getPrincipal());
        Assert.assertEquals((Object)"hallo", (Object)result.getDetails());
    }
}

