/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.auth;

import org.geoserver.security.auth.AuthenticationCache;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

public abstract class BaseAuthenticationCacheTest {
    protected static final int TIME_LIVE = 2;
    protected static final int TIME_IDLE = 1;
    protected static final int MAX_ENTRIES = 1000;
    protected static final String SAMPLE_CACHE_KEY = "SAMPLE_CACHE_KEY";
    protected static final String SAMPLE_FILTER = "SAMPLE_FILTER";
    protected static final String OTHER_CACHE_KEY = "WRONG_CACHE_KEY";
    AuthenticationCache cache;

    @Before
    public void setUp() {
        this.cache = this.createAuthenticationCache();
    }

    protected abstract AuthenticationCache createAuthenticationCache();

    @Test
    public void testWriteAndRead() {
        Authentication auth = this.putAuthenticationInCache();
        Authentication authenticationFromCache = this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY);
        Assert.assertNotNull((Object)authenticationFromCache);
        Assert.assertEquals((Object)auth, (Object)authenticationFromCache);
    }

    @Test
    public void testExpireByAccess() throws InterruptedException {
        this.putAuthenticationInCache();
        Thread.sleep(500L);
        Assert.assertNotNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
        Thread.sleep(2000L);
        Assert.assertNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
    }

    @Test
    public void testExpireByCreation() throws InterruptedException {
        this.putAuthenticationInCache();
        Thread.sleep(500L);
        Assert.assertNotNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
        Thread.sleep(500L);
        Assert.assertNotNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
        Thread.sleep(500L);
        Assert.assertNotNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
        Thread.sleep(2000L);
        Assert.assertNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
    }

    @Test
    public void testRemoveAuthentication() {
        this.putAuthenticationInCache();
        this.cache.remove(SAMPLE_FILTER, SAMPLE_CACHE_KEY);
        Assert.assertNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
    }

    @Test
    public void testRemoveUnexistingAuthentication() {
        this.cache.remove(SAMPLE_FILTER, OTHER_CACHE_KEY);
        Assert.assertNull((Object)this.cache.get(SAMPLE_FILTER, OTHER_CACHE_KEY));
    }

    @Test
    public void testRemoveAll() {
        this.putAuthenticationInCache();
        this.putOtherAuthenticationInCache();
        Assert.assertNotNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
        Assert.assertNotNull((Object)this.cache.get(SAMPLE_FILTER, OTHER_CACHE_KEY));
        this.cache.removeAll();
        Assert.assertNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
        Assert.assertNull((Object)this.cache.get(SAMPLE_FILTER, OTHER_CACHE_KEY));
    }

    @Test
    public void testRemoveAllByFilter() {
        this.putAuthenticationInCache();
        this.putOtherAuthenticationInCache();
        Assert.assertNotNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
        Assert.assertNotNull((Object)this.cache.get(SAMPLE_FILTER, OTHER_CACHE_KEY));
        this.cache.removeAll(SAMPLE_FILTER);
        Assert.assertNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
        Assert.assertNull((Object)this.cache.get(SAMPLE_FILTER, OTHER_CACHE_KEY));
    }

    protected Authentication putAuthenticationInCache() {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"user", (Object)"password");
        this.cache.put(SAMPLE_FILTER, SAMPLE_CACHE_KEY, (Authentication)auth);
        return auth;
    }

    private Authentication putOtherAuthenticationInCache() {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"user", (Object)"password");
        this.cache.put(SAMPLE_FILTER, OTHER_CACHE_KEY, (Authentication)auth);
        return auth;
    }
}

