/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.GeoServerAuthenticationProvider;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerSecurityProvider;
import org.geoserver.security.config.SecurityAuthProviderConfig;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.UsernamePasswordAuthenticationProviderConfig;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.SystemTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.ProviderNotFoundException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

@Category(value={SystemTest.class})
public class GeoServerCustomAuthTest
extends GeoServerSystemTestSupport {
    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add(((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName() + "-context.xml").toString());
    }

    @Test
    public void testInactive() throws Exception {
        UsernamePasswordAuthenticationToken upAuth = new UsernamePasswordAuthenticationToken((Object)"foo", (Object)"bar");
        try {
            this.getSecurityManager().authenticationManager().authenticate((Authentication)upAuth);
        }
        catch (BadCredentialsException | ProviderNotFoundException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testActive() throws Exception {
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        UsernamePasswordAuthenticationProviderConfig config = new UsernamePasswordAuthenticationProviderConfig();
        config.setName("custom");
        config.setClassName(AuthProvider.class.getName());
        secMgr.saveAuthenticationProvider((SecurityAuthProviderConfig)config);
        SecurityManagerConfig mgrConfig = secMgr.getSecurityConfig();
        mgrConfig.getAuthProviderNames().add("custom");
        mgrConfig.setConfigPasswordEncrypterName(this.getPlainTextPasswordEncoder().getName());
        secMgr.saveSecurityConfig(mgrConfig);
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"foo", (Object)"bar");
        auth = this.getSecurityManager().authenticationManager().authenticate((Authentication)auth);
        Assert.assertTrue((boolean)auth.isAuthenticated());
    }

    static class AuthProvider
    extends GeoServerAuthenticationProvider {
        AuthProvider() {
        }

        public Authentication authenticate(Authentication authentication, HttpServletRequest request) throws AuthenticationException {
            UsernamePasswordAuthenticationToken up;
            if (authentication instanceof UsernamePasswordAuthenticationToken && "foo".equals((up = (UsernamePasswordAuthenticationToken)authentication).getPrincipal()) && "bar".equals(up.getCredentials())) {
                authentication = new UsernamePasswordAuthenticationToken((Object)"foo", (Object)"bar", Collections.emptyList());
            }
            return authentication;
        }

        public boolean supports(Class<? extends Object> authentication, HttpServletRequest request) {
            return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
        }
    }

    static class SecurityProvider
    extends GeoServerSecurityProvider {
        SecurityProvider() {
        }

        public Class<? extends GeoServerAuthenticationProvider> getAuthenticationProviderClass() {
            return AuthProvider.class;
        }

        public GeoServerAuthenticationProvider createAuthenticationProvider(SecurityNamedServiceConfig config) {
            return new AuthProvider();
        }
    }
}

