/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.GeoServerSecurityFilterChainProxy;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.BruteForcePreventionConfig;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.bind.annotation.RequestMethod;

public class BruteForceAttackTest
extends GeoServerSystemTestSupport {
    private static final String HELLO_GET_REQUEST = "ows?service=hello&request=hello&message=Hello_World";

    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("classpath*:/org/geoserver/ows/applicationContext.xml");
    }

    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpSecurity();
    }

    protected List<Filter> getFilters() {
        return Arrays.asList((Filter)applicationContext.getBean(GeoServerSecurityFilterChainProxy.class));
    }

    @Before
    public void resetAuthentication() {
        this.setRequestAuth(null, null);
    }

    @Before
    public void resetBruteForceAttackConfig() throws Exception {
        GeoServerSecurityManager manager = (GeoServerSecurityManager)applicationContext.getBean(GeoServerSecurityManager.class);
        SecurityManagerConfig securityConfig = manager.getSecurityConfig();
        BruteForcePreventionConfig bruteForceConfig = securityConfig.getBruteForcePrevention();
        bruteForceConfig.setEnabled(true);
        bruteForceConfig.setMinDelaySeconds(1);
        bruteForceConfig.setMaxDelaySeconds(1);
        bruteForceConfig.setMaxBlockedThreads(100);
        bruteForceConfig.setWhitelistedMasks(Collections.emptyList());
        manager.saveSecurityConfig(securityConfig);
    }

    @Test
    public void testLoginDelay() throws Exception {
        this.setRequestAuth("admin", "geoserver");
        Assert.assertEquals((long)200L, (long)this.getAsServletResponse(HELLO_GET_REQUEST).getStatus());
        this.setRequestAuth("admin", "foobar");
        long start = System.currentTimeMillis();
        Assert.assertEquals((long)401L, (long)this.getAsServletResponse(HELLO_GET_REQUEST).getStatus());
        long end = System.currentTimeMillis();
        MatcherAssert.assertThat((Object)(end - start), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(1000L)));
    }

    @Test
    public void testParallelLogin() throws Exception {
        this.testParallelLogin("Unauthorized", i -> "foo");
    }

    @Test
    public void testTooManyBlockedThreads() throws Exception {
        GeoServerSecurityManager manager = (GeoServerSecurityManager)applicationContext.getBean(GeoServerSecurityManager.class);
        SecurityManagerConfig securityConfig = manager.getSecurityConfig();
        BruteForcePreventionConfig bruteForceConfig = securityConfig.getBruteForcePrevention();
        bruteForceConfig.setMaxBlockedThreads(1);
        manager.saveSecurityConfig(securityConfig);
        this.testParallelLogin("Unauthorized", i -> "foo" + i);
    }

    private void testParallelLogin(String expectedMessage, Function<Integer, String> userNameGenerator) throws InterruptedException, ExecutionException {
        int NTHREADS = 32;
        ExecutorService service = Executors.newFixedThreadPool(32);
        CountDownLatch latch = new CountDownLatch(32);
        AtomicInteger concurrentLoginsPrevented = new AtomicInteger(0);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < 32) {
            int n = i++;
            Future<Object> future = service.submit(() -> {
                latch.countDown();
                latch.await();
                MockHttpServletRequest request = this.createRequest(HELLO_GET_REQUEST);
                request.setMethod(RequestMethod.GET.toString());
                request.setContent(new byte[0]);
                String userName = (String)userNameGenerator.apply(idx);
                String token = userName + ":foobar";
                request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBase64((byte[])token.getBytes()))));
                MockHttpServletResponse response = this.dispatch((HttpServletRequest)request, "UTF-8");
                Assert.assertEquals((long)401L, (long)response.getStatus());
                String message = response.getErrorMessage();
                if (message.contains(expectedMessage)) {
                    concurrentLoginsPrevented.incrementAndGet();
                }
                return null;
            });
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        long awaitTime = System.currentTimeMillis() - start;
        service.shutdown();
        Assert.assertTrue((awaitTime > 32000L || concurrentLoginsPrevented.get() > 0 ? 1 : 0) != 0);
    }
}

