/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.ldap;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Name;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.impl.AbstractGeoServerSecurityService;
import org.geoserver.security.ldap.BindingLdapTemplate;
import org.geoserver.security.ldap.LDAPBaseSecurityServiceConfig;
import org.geoserver.security.ldap.LDAPUtils;
import org.springframework.ldap.core.AuthenticatedLdapEntryContextCallback;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;

public abstract class LDAPBaseSecurityService
extends AbstractGeoServerSecurityService {
    protected static final Pattern lookForMembershipAttribute = Pattern.compile("^\\(*([a-z]+)=(.*?)\\{([01])\\}(.*?)\\)*$", 2);
    protected Pattern userNamePattern = Pattern.compile("^(.*)$");
    protected Pattern userMembershipPattern = Pattern.compile("^(.*)$");
    protected LdapContextSource ldapContext;
    protected SpringSecurityLdapTemplate template;
    protected String user;
    protected String password;
    protected String groupSearchBase = "ou=groups";
    protected String groupNameFilter = "cn={0}";
    protected String allGroupsSearchFilter = "cn=*";
    protected String groupNameAttribute = "cn";
    protected String groupMembershipFilter = "member={0}";
    protected String groupMembershipAttribute = "member";
    protected String userSearchBase = "ou=people";
    protected String userNameFilter = "uid={0}";
    protected String allUsersSearchFilter = "uid=*";
    protected String userNameAttribute = "uid";
    protected boolean lookupUserForDn = false;
    protected boolean useNestedGroups = true;
    protected int maxGroupSearchLevel = 10;
    protected String nestedGroupSearchFilter = "member={0}";

    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        Matcher m;
        super.initializeFromConfig(config);
        LDAPBaseSecurityServiceConfig ldapConfig = (LDAPBaseSecurityServiceConfig)config;
        this.ldapContext = LDAPUtils.createLdapContext(ldapConfig);
        if (ldapConfig.isBindBeforeGroupSearch().booleanValue()) {
            this.user = ldapConfig.getUser();
            this.password = ldapConfig.getPassword();
            this.template = new BindingLdapTemplate((ContextSource)this.ldapContext);
        } else {
            this.template = new SpringSecurityLdapTemplate((ContextSource)this.ldapContext);
        }
        if (!LDAPBaseSecurityService.isEmpty(ldapConfig.getGroupSearchBase())) {
            this.groupSearchBase = ldapConfig.getGroupSearchBase();
        }
        if (!LDAPBaseSecurityService.isEmpty(ldapConfig.getUserSearchBase())) {
            this.userSearchBase = ldapConfig.getUserSearchBase();
        }
        if (!LDAPBaseSecurityService.isEmpty(ldapConfig.getGroupSearchFilter())) {
            this.groupMembershipFilter = ldapConfig.getGroupSearchFilter();
            m = lookForMembershipAttribute.matcher(this.groupMembershipFilter);
            if (m.matches()) {
                if (LDAPBaseSecurityService.isEmpty(ldapConfig.getGroupMembershipAttribute())) {
                    this.groupMembershipAttribute = m.group(1);
                }
                this.lookupUserForDn = m.group(3).equals("1");
                this.userMembershipPattern = Pattern.compile("^" + Pattern.quote(m.group(2)) + "(.*)" + Pattern.quote(m.group(4)) + "$");
            }
        }
        if (!LDAPBaseSecurityService.isEmpty(ldapConfig.getGroupMembershipAttribute())) {
            this.groupMembershipAttribute = ldapConfig.getGroupMembershipAttribute();
            if (LDAPBaseSecurityService.isEmpty(ldapConfig.getGroupSearchFilter())) {
                this.groupMembershipFilter = this.groupMembershipAttribute + "={0}";
            }
        }
        if (!LDAPBaseSecurityService.isEmpty(ldapConfig.getGroupFilter())) {
            this.groupNameFilter = ldapConfig.getGroupFilter();
            if (LDAPBaseSecurityService.isEmpty(ldapConfig.getGroupNameAttribute()) && (m = lookForMembershipAttribute.matcher(this.groupNameFilter)).matches()) {
                this.groupNameAttribute = m.group(1);
            }
        }
        if (!LDAPBaseSecurityService.isEmpty(ldapConfig.getGroupNameAttribute())) {
            this.groupNameAttribute = ldapConfig.getGroupNameAttribute();
            if (LDAPBaseSecurityService.isEmpty(ldapConfig.getGroupFilter())) {
                this.groupNameFilter = this.groupNameAttribute + "={0}";
            }
        }
        this.allGroupsSearchFilter = !LDAPBaseSecurityService.isEmpty(ldapConfig.getAllGroupsSearchFilter()) ? ldapConfig.getAllGroupsSearchFilter() : this.groupNameAttribute + "=*";
        if (!LDAPBaseSecurityService.isEmpty(ldapConfig.getUserFilter())) {
            this.userNameFilter = ldapConfig.getUserFilter();
            m = lookForMembershipAttribute.matcher(this.userNameFilter);
            if (m.matches()) {
                if (LDAPBaseSecurityService.isEmpty(ldapConfig.getUserNameAttribute())) {
                    this.userNameAttribute = m.group(1);
                }
                this.userNamePattern = Pattern.compile("^" + Pattern.quote(m.group(2)) + "(.*)" + Pattern.quote(m.group(4)) + "$");
            }
        }
        if (!LDAPBaseSecurityService.isEmpty(ldapConfig.getUserNameAttribute())) {
            this.userNameAttribute = ldapConfig.getUserNameAttribute();
            if (LDAPBaseSecurityService.isEmpty(ldapConfig.getUserFilter())) {
                this.userNameFilter = this.userNameAttribute + "={0}";
            }
        }
        this.allUsersSearchFilter = !LDAPBaseSecurityService.isEmpty(ldapConfig.getAllUsersSearchFilter()) ? ldapConfig.getAllUsersSearchFilter() : this.userNameAttribute + "=*";
        this.useNestedGroups = ldapConfig.isUseNestedParentGroups();
        this.nestedGroupSearchFilter = !LDAPBaseSecurityService.isEmpty(ldapConfig.getNestedGroupSearchFilter()) ? ldapConfig.getNestedGroupSearchFilter() : "member= {0}";
        this.maxGroupSearchLevel = ldapConfig.getMaxGroupSearchLevel() >= 0 ? ldapConfig.getMaxGroupSearchLevel() : 10;
    }

    protected void authenticateIfNeeded(AuthenticatedLdapEntryContextCallback callback) {
        if (this.user != null && this.password != null) {
            this.template.authenticate((Name)LdapUtils.emptyLdapName(), this.user, this.password, callback);
        } else {
            callback.executeWithContext(null, null);
        }
    }

    protected static boolean isEmpty(String property) {
        return property == null || property.isEmpty();
    }

    protected String getUserNameFromMembership(String user) {
        AtomicReference<String> userName = new AtomicReference<String>(user);
        if (this.lookupUserForDn) {
            this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> {
                DirContextOperations obj = (DirContextOperations)LDAPUtils.getLdapTemplateInContext(ctx, this.template).lookup(user);
                Object attribute = obj.getObjectAttribute(this.userNameAttribute);
                if (attribute != null) {
                    String name = attribute.toString();
                    Matcher m = this.userNamePattern.matcher(name);
                    if (m.matches()) {
                        name = m.group(1);
                    }
                    userName.set(name);
                }
            });
        }
        return userName.get();
    }

    protected String lookupDn(String username) {
        AtomicReference<String> dn = new AtomicReference<String>(username);
        if (this.lookupUserForDn) {
            this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> {
                try {
                    dn.set(LDAPUtils.getLdapTemplateInContext(ctx, this.template).searchForSingleEntry("", this.userNameFilter, (Object[])new String[]{username}).getDn().toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        return dn.get();
    }

    protected ContextMapper<Object> counter(AtomicInteger count) {
        return ctx -> {
            count.set(count.get() + 1);
            return null;
        };
    }

    protected String extractGroupCnFromDn(String dn) {
        String[] parts;
        if (StringUtils.isBlank((CharSequence)dn)) {
            return null;
        }
        for (String part : parts = dn.split(Pattern.quote(","))) {
            if (!part.startsWith(this.groupNameAttribute + "=")) continue;
            int equalsIndex = part.indexOf("=");
            return part.substring(equalsIndex + 1);
        }
        return null;
    }

    protected boolean isOutOfDepthBounds(int depth) {
        if (this.maxGroupSearchLevel == -1) {
            return false;
        }
        return depth >= this.maxGroupSearchLevel;
    }
}

