/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.ldap;

import java.util.SortedSet;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.ldap.LDAPBaseTest;
import org.geoserver.security.ldap.LDAPUserGroupService;
import org.geoserver.security.ldap.LDAPUserGroupServiceConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", address="localhost")}, allowAnonymousAccess=true)
@CreateDS(name="myDS", partitions={@CreatePartition(name="test", suffix="dc=example,dc=com")})
@ApplyLdifFiles(value={"data4.ldif"})
public class LDAPUserGroupServiceTest
extends LDAPBaseTest {
    GeoServerUserGroupService service;

    @Override
    protected void createConfig() {
        this.config = new LDAPUserGroupServiceConfig();
    }

    @Before
    public void createUserGroupService() throws Exception {
        this.config.setGroupNameAttribute("cn");
        this.config.setUserSearchBase("ou=People");
        this.config.setUserNameAttribute("uid");
        this.config.setGroupSearchFilter("member={1},dc=example,dc=com");
        ((LDAPUserGroupServiceConfig)this.config).setPopulatedAttributes("sn, givenName, telephoneNumber, mail");
        this.service = new LDAPUserGroupService((SecurityNamedServiceConfig)this.config);
    }

    @Test
    public void testUsers() throws Exception {
        SortedSet users = this.service.getUsers();
        Assert.assertNotNull((Object)users);
        Assert.assertEquals((long)4L, (long)users.size());
    }

    @Test
    public void testGroupByName() throws Exception {
        Assert.assertNotNull((Object)this.service.getGroupByGroupname("extra"));
        Assert.assertNull((Object)this.service.getGroupByGroupname("dummy"));
    }

    @Test
    public void testUserByName() throws Exception {
        GeoServerUser user = this.service.getUserByUsername("other");
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"other", (Object)user.getProperties().get("givenName"));
        Assert.assertEquals((Object)"dude", (Object)user.getProperties().get("sn"));
        Assert.assertEquals((Object)"2", (Object)user.getProperties().get("telephoneNumber"));
        Assert.assertNull((Object)this.service.getUserByUsername("dummy"));
    }

    @Test
    public void testUsersForGroup() throws Exception {
        SortedSet users = this.service.getUsersForGroup(this.service.getGroupByGroupname("other"));
        Assert.assertNotNull((Object)users);
        Assert.assertEquals((long)2L, (long)users.size());
    }

    @Test
    public void testGroupsForUser() throws Exception {
        SortedSet groups = this.service.getGroupsForUser(this.service.getUserByUsername("other"));
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)1L, (long)groups.size());
    }

    @Test
    public void testUserCount() throws Exception {
        Assert.assertEquals((long)4L, (long)this.service.getUserCount());
    }

    @Test
    public void testGroupCount() throws Exception {
        Assert.assertEquals((long)8L, (long)this.service.getGroupCount());
    }

    @Test
    public void testUsersHavingProperty() throws Exception {
        SortedSet users = this.service.getUsersHavingProperty("mail");
        Assert.assertEquals((long)1L, (long)users.size());
        for (GeoServerUser user : users) {
            Assert.assertEquals((Object)"extra", (Object)user.getUsername());
        }
    }

    @Test
    public void testUsersNotHavingProperty() throws Exception {
        SortedSet users = this.service.getUsersNotHavingProperty("telephoneNumber");
        Assert.assertEquals((long)1L, (long)users.size());
        for (GeoServerUser user : users) {
            Assert.assertEquals((Object)"extra", (Object)user.getUsername());
        }
    }

    @Test
    public void testCountUsersHavingProperty() throws Exception {
        Assert.assertEquals((long)1L, (long)this.service.getUserCountHavingProperty("mail"));
    }

    @Test
    public void testCountUsersNotHavingProperty() throws Exception {
        Assert.assertEquals((long)1L, (long)this.service.getUserCountNotHavingProperty("telephoneNumber"));
    }

    @Test
    public void testUsersHavingPropertyValue() throws Exception {
        SortedSet users = this.service.getUsersHavingPropertyValue("telephoneNumber", "2");
        Assert.assertEquals((long)1L, (long)users.size());
        for (GeoServerUser user : users) {
            Assert.assertEquals((Object)"other", (Object)user.getUsername());
        }
    }

    @Test
    public void testUserCountHavingPropertyValue() throws Exception {
        Assert.assertEquals((long)1L, (long)this.service.getUserCountHavingPropertyValue("telephoneNumber", "2"));
    }

    @Test
    public void testUsersForHierarchicalGroup() throws Exception {
        this.config.setUseNestedParentGroups(true);
        this.service = new LDAPUserGroupService((SecurityNamedServiceConfig)this.config);
        SortedSet users = this.service.getUsersForGroup(this.service.getGroupByGroupname("extra"));
        Assert.assertNotNull((Object)users);
        Assert.assertEquals((long)2L, (long)users.size());
        Assert.assertTrue((boolean)users.stream().anyMatch(x -> "nestedUser".equals(x.getUsername())));
    }

    @Test
    public void testHierarchicalGroupsForUser() throws Exception {
        this.config.setUseNestedParentGroups(true);
        this.service = new LDAPUserGroupService((SecurityNamedServiceConfig)this.config);
        SortedSet groups = this.service.getGroupsForUser(this.service.getUserByUsername("nestedUser"));
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)6L, (long)groups.size());
        Assert.assertTrue((boolean)groups.stream().anyMatch(x -> "extra".equals(x.getGroupname())));
    }
}

