/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.ldap;

import java.io.IOException;
import java.util.SortedSet;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.ldap.LDAPBaseTest;
import org.geoserver.security.ldap.LDAPRoleService;
import org.geoserver.security.ldap.LDAPRoleServiceConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

public class LDAPRoleServiceTest
extends LDAPBaseTest {
    GeoServerRoleService service;

    public void createRoleService(boolean userFilter, Boolean convertToUpperCase, String rolePrefix) throws IOException {
        this.service = new LDAPRoleService();
        if (userFilter) {
            this.config.setGroupSearchFilter("member={1},dc=example,dc=com");
            this.config.setUserFilter("uid={0}");
        } else {
            this.config.setGroupSearchFilter("member=cn={0}");
        }
        if (convertToUpperCase != null) {
            this.config.setConvertToUpperCase(convertToUpperCase);
        }
        if (rolePrefix != null) {
            this.config.setRolePrefix(rolePrefix);
        }
        this.service.initializeFromConfig((SecurityNamedServiceConfig)this.config);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    protected void configureAuthentication() {
        this.config.setUser("uid=admin,ou=People,dc=example,dc=com");
        this.config.setPassword("admin");
        this.config.setBindBeforeGroupSearch(Boolean.valueOf(true));
    }

    protected void checkAdminRoles() throws IOException {
        this.config.setAdminGroup("admin");
        this.config.setGroupAdminGroup("other");
        this.createRoleService(false, null, null);
        Assert.assertNotNull((Object)this.service.getAdminRole());
        Assert.assertNotNull((Object)this.service.getGroupAdminRole());
        this.config.setAdminGroup("dummy1");
        this.config.setGroupAdminGroup("dummy2");
        this.createRoleService(false, null, null);
        Assert.assertNull((Object)this.service.getAdminRole());
        Assert.assertNull((Object)this.service.getGroupAdminRole());
        this.config.setAdminGroup("admin");
        this.config.setGroupAdminGroup("other");
        this.createRoleService(false, false, "test_");
        Assert.assertEquals((Object)"test_admin", (Object)this.service.getAdminRole().toString());
    }

    protected void checkUserNamesForRole(String roleName, int expected, boolean userFilter) throws IOException {
        this.createRoleService(userFilter, null, null);
        SortedSet userNames = this.service.getUserNamesForRole(new GeoServerRole(roleName));
        Assert.assertNotNull((Object)userNames);
        Assert.assertEquals((long)expected, (long)userNames.size());
        this.createRoleService(userFilter, false, "test_");
        userNames = this.service.getUserNamesForRole(new GeoServerRole(roleName));
        Assert.assertNotNull((Object)userNames);
        Assert.assertEquals((long)expected, (long)userNames.size());
    }

    protected void checkRoleByName() throws IOException {
        this.createRoleService(false, null, null);
        Assert.assertNotNull((Object)this.service.getRoleByName("admin"));
        Assert.assertNull((Object)this.service.getRoleByName("dummy"));
        this.createRoleService(false, false, "test_");
        Assert.assertNotNull((Object)this.service.getRoleByName("admin"));
        Assert.assertNull((Object)this.service.getRoleByName("dummy"));
    }

    protected void checkRoleCount() throws IOException {
        this.createRoleService(false, null, null);
        Assert.assertTrue((this.service.getRoleCount() > 0 ? 1 : 0) != 0);
        this.createRoleService(false, false, "test_");
        Assert.assertTrue((this.service.getRoleCount() > 0 ? 1 : 0) != 0);
    }

    protected void checkAllRoles() throws IOException {
        this.createRoleService(false, null, null);
        SortedSet roles = this.service.getRoles();
        Assert.assertNotNull((Object)roles);
        Assert.assertFalse((boolean)roles.isEmpty());
        GeoServerRole role = (GeoServerRole)roles.first();
        Assert.assertTrue((boolean)role.toString().startsWith("ROLE_"));
        Assert.assertEquals((Object)role.toString().toUpperCase(), (Object)role.toString());
        this.createRoleService(false, false, "test_");
        roles = this.service.getRoles();
        Assert.assertNotNull((Object)roles);
        Assert.assertFalse((boolean)roles.isEmpty());
        role = (GeoServerRole)roles.first();
        Assert.assertTrue((boolean)role.toString().startsWith("test_"));
        Assert.assertNotEquals((Object)role.toString().toUpperCase(), (Object)role.toString());
    }

    protected void checkUserRoles(String username, boolean userFilter) throws IOException {
        this.createRoleService(userFilter, null, null);
        SortedSet allRoles = this.service.getRoles();
        SortedSet roles = this.service.getRolesForUser(username);
        Assert.assertNotNull((Object)roles);
        Assert.assertFalse((boolean)roles.isEmpty());
        Assert.assertTrue((roles.size() < allRoles.size() ? 1 : 0) != 0);
        GeoServerRole role = (GeoServerRole)roles.first();
        Assert.assertTrue((boolean)role.toString().startsWith("ROLE_"));
        Assert.assertEquals((Object)role.toString().toUpperCase(), (Object)role.toString());
        this.createRoleService(userFilter, false, "test_");
        allRoles = this.service.getRoles();
        roles = this.service.getRolesForUser(username);
        Assert.assertNotNull((Object)roles);
        Assert.assertFalse((boolean)roles.isEmpty());
        Assert.assertTrue((roles.size() < allRoles.size() ? 1 : 0) != 0);
        role = (GeoServerRole)roles.first();
        Assert.assertTrue((boolean)role.toString().startsWith("test_"));
        Assert.assertNotEquals((Object)role.toString().toUpperCase(), (Object)role.toString());
    }

    @Override
    protected void createConfig() {
        this.config = new LDAPRoleServiceConfig();
    }

    @RunWith(value=FrameworkRunner.class)
    @CreateLdapServer(transports={@CreateTransport(protocol="LDAP", address="localhost")}, allowAnonymousAccess=true)
    @CreateDS(name="myDS", partitions={@CreatePartition(name="test", suffix="dc=example,dc=com")})
    @ApplyLdifFiles(value={"data4.ldif"})
    public static class LDAPRoleServiceLdiff4Test
    extends LDAPRoleServiceTest {
        @Test
        public void checkHierarchicalRolesUsers() throws IOException {
            this.createRoleService(true, null, null);
            this.config.setUserNameAttribute("uid");
            this.config.setGroupNameAttribute("cn");
            this.config.setUseNestedParentGroups(true);
            this.config.setNestedGroupSearchFilter("member={1}");
            this.config.setGroupSearchFilter("member={1},dc=example,dc=com");
            this.config.setUserFilter("uid={0}");
            this.config.setMaxGroupSearchLevel(5);
            this.service = new LDAPRoleService();
            this.service.initializeFromConfig((SecurityNamedServiceConfig)this.config);
            SortedSet userNames = this.service.getUserNamesForRole(this.service.getRoleByName("ROLE_EXTRA"));
            Assert.assertNotNull((Object)userNames);
            Assert.assertEquals((long)2L, (long)userNames.size());
            Assert.assertTrue((boolean)userNames.stream().anyMatch(u -> "nestedUser".equals(u)));
            SortedSet roles = this.service.getRolesForUser("nestedUser");
            Assert.assertEquals((long)6L, (long)roles.size());
        }
    }

    @RunWith(value=FrameworkRunner.class)
    @CreateLdapServer(transports={@CreateTransport(protocol="LDAP", address="localhost")}, allowAnonymousAccess=true)
    @CreateDS(name="myDS", partitions={@CreatePartition(name="test", suffix="dc=example,dc=com")})
    @ApplyLdifFiles(value={"data2.ldif"})
    public static class LDAPRoleServiceLdiff2Test
    extends LDAPRoleServiceTest {
        @Test
        public void testGetRolesForUserUsingUserFilter() throws Exception {
            this.checkUserRoles("admin", true);
        }

        @Test
        public void testGetRolesForUserAuthenticatedUsingUserFilter() throws Exception {
            LDAPRoleServiceLdiff2Test.getService().setAllowAnonymousAccess(false);
            this.configureAuthentication();
            this.checkUserRoles("admin", true);
        }

        @Test
        public void testGetUserNamesForRoleUsingUserFilter() throws Exception {
            LDAPRoleServiceLdiff2Test.getService().setAllowAnonymousAccess(true);
            this.checkUserNamesForRole("admin", 1, true);
            this.checkUserNamesForRole("other", 2, true);
        }
    }

    @RunWith(value=FrameworkRunner.class)
    @CreateLdapServer(transports={@CreateTransport(protocol="LDAP", address="localhost")}, allowAnonymousAccess=true)
    @CreateDS(name="myDS", partitions={@CreatePartition(name="test", suffix="dc=example,dc=com")})
    @ApplyLdifFiles(value={"data.ldif"})
    public static class LDAPRoleServiceLdiffTest
    extends LDAPRoleServiceTest {
        @Test
        public void testGetRoles() throws Exception {
            LDAPRoleServiceLdiffTest.getService().setAllowAnonymousAccess(true);
            this.checkAllRoles();
        }

        @Test
        public void testGetRolesAuthenticated() throws Exception {
            LDAPRoleServiceLdiffTest.getService().setAllowAnonymousAccess(false);
            this.configureAuthentication();
            this.checkAllRoles();
        }

        @Test
        public void testGetRolesCount() throws Exception {
            LDAPRoleServiceLdiffTest.getService().setAllowAnonymousAccess(true);
            this.checkRoleCount();
        }

        @Test
        public void testGetRolesCountAuthenticated() throws Exception {
            LDAPRoleServiceLdiffTest.getService().setAllowAnonymousAccess(true);
            this.configureAuthentication();
            this.checkRoleCount();
        }

        @Test
        public void testGetRoleByName() throws Exception {
            LDAPRoleServiceLdiffTest.getService().setAllowAnonymousAccess(true);
            this.checkRoleByName();
        }

        @Test
        public void testGetRoleByNameAuthenticated() throws Exception {
            LDAPRoleServiceLdiffTest.getService().setAllowAnonymousAccess(false);
            this.configureAuthentication();
            this.checkRoleByName();
        }

        @Test
        public void testGetAdminRoles() throws Exception {
            LDAPRoleServiceLdiffTest.getService().setAllowAnonymousAccess(true);
            this.checkAdminRoles();
        }

        @Test
        public void testGetAdminRolesAuthenticated() throws Exception {
            LDAPRoleServiceLdiffTest.getService().setAllowAnonymousAccess(false);
            this.configureAuthentication();
            this.checkAdminRoles();
        }

        @Test
        public void testGetRolesForUser() throws Exception {
            LDAPRoleServiceLdiffTest.getService().setAllowAnonymousAccess(true);
            this.checkUserRoles("admin", false);
        }

        @Test
        public void testGetRolesForUserAuthenticated() throws Exception {
            LDAPRoleServiceLdiffTest.getService().setAllowAnonymousAccess(false);
            this.configureAuthentication();
            this.checkUserRoles("admin", false);
        }

        @Test
        public void testGetUserNamesForRole() throws Exception {
            LDAPRoleServiceLdiffTest.getService().setAllowAnonymousAccess(true);
            this.checkUserNamesForRole("admin", 1, false);
            this.checkUserNamesForRole("other", 2, false);
        }

        @Test
        public void checkUserHierarchicalRoles() throws IOException {
            this.config.setUseNestedParentGroups(true);
            this.config.setNestedGroupSearchFilter("member=cn={0}");
            this.config.setGroupSearchFilter("member=cn={0}");
            this.config.setUserFilter("uid={0}");
            this.service = new LDAPRoleService();
            this.service.initializeFromConfig((SecurityNamedServiceConfig)this.config);
            SortedSet roles = this.service.getRolesForUser("nestedUser");
            Assert.assertNotNull((Object)roles);
            Assert.assertEquals((long)2L, (long)roles.size());
            Assert.assertTrue((boolean)roles.stream().anyMatch(r -> "ROLE_EXTRA".equals(r.getAuthority())));
        }
    }
}

