/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.ldap;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.event.UserGroupLoadedListener;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.impl.RoleCalculator;
import org.geoserver.security.ldap.LDAPBaseSecurityService;
import org.geoserver.security.ldap.LDAPUserGroupServiceConfig;
import org.geoserver.security.ldap.LDAPUtils;
import org.geotools.util.logging.Logging;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.util.Assert;

public class LDAPUserGroupService
extends LDAPBaseSecurityService
implements GeoServerUserGroupService {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.ldap");
    private String passwordEncoderName;
    private String passwordValidatorName;
    private String[] populatedAttributes = new String[0];

    public LDAPUserGroupService(SecurityNamedServiceConfig config) throws IOException {
        this.initializeFromConfig(config);
    }

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        LDAPUserGroupServiceConfig ldapConfig = (LDAPUserGroupServiceConfig)config;
        this.passwordEncoderName = ldapConfig.getPasswordEncoderName();
        this.passwordValidatorName = ldapConfig.getPasswordPolicyName();
        if (!LDAPUserGroupService.isEmpty(ldapConfig.getPopulatedAttributes())) {
            this.populatedAttributes = ldapConfig.getPopulatedAttributes().trim().split("[\\s]*,[\\s]*");
        }
    }

    public GeoServerUserGroupStore createStore() throws IOException {
        return null;
    }

    public void load() throws IOException {
    }

    public void registerUserGroupLoadedListener(UserGroupLoadedListener listener) {
    }

    public void unregisterUserGroupLoadedListener(UserGroupLoadedListener listener) {
    }

    public String getPasswordEncoderName() {
        return this.passwordEncoderName;
    }

    public String getPasswordValidatorName() {
        return this.passwordValidatorName;
    }

    public GeoServerUser createUserObject(String username, String password, boolean isEnabled) throws IOException {
        GeoServerUser user = new GeoServerUser(username);
        user.setEnabled(isEnabled);
        user.setPassword(password);
        return user;
    }

    public GeoServerUserGroup createGroupObject(String groupname, boolean isEnabled) throws IOException {
        GeoServerUserGroup group = new GeoServerUserGroup(groupname);
        group.setEnabled(isEnabled);
        return group;
    }

    public SortedSet<GeoServerUserGroup> getUserGroups() {
        TreeSet groups = new TreeSet();
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> {
            Set groupNames = LDAPUtils.getLdapTemplateInContext(ctx, this.template).searchForSingleAttributeValues(this.groupSearchBase, this.allGroupsSearchFilter, (Object[])new String[0], this.groupNameAttribute);
            for (String groupName : groupNames) {
                groups.add(new GeoServerUserGroup(groupName));
            }
        });
        return Collections.unmodifiableSortedSet(groups);
    }

    protected GeoServerUser createUser(DirContextOperations dco) {
        GeoServerUser gsUser = new GeoServerUser(dco.getStringAttribute(this.userNameAttribute));
        for (String attName : this.populatedAttributes) {
            try {
                Object value;
                Attribute att = dco.getAttributes().get(attName.toLowerCase());
                if (att == null || !((value = att.get()) instanceof String)) continue;
                gsUser.getProperties().put(attName, value);
            }
            catch (NamingException e) {
                LOGGER.log(Level.WARNING, "Could not populate value for user attribute " + attName, e);
            }
        }
        return gsUser;
    }

    protected ContextMapper<Object> addToUsers(SortedSet<GeoServerUser> users) {
        return ctx -> {
            users.add(this.createUser((DirContextOperations)((DirContextAdapter)ctx)));
            return null;
        };
    }

    public SortedSet<GeoServerUser> getUsers() {
        TreeSet users = new TreeSet();
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> LDAPUtils.getLdapTemplateInContext(ctx, this.template).search(this.userSearchBase, LDAPUtils.escapeSearchString(this.allUsersSearchFilter), this.addToUsers(users)));
        return Collections.unmodifiableSortedSet(users);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        GeoServerUser user = null;
        try {
            user = this.getUserByUsername(username);
            if (user == null) {
                throw new UsernameNotFoundException(this.userNotFoundMessage(username));
            }
            RoleCalculator calculator = new RoleCalculator((GeoServerUserGroupService)this, this.getSecurityManager().getActiveRoleService());
            user.setAuthorities((Set)calculator.calculateRoles(user));
        }
        catch (IOException e) {
            throw new UsernameNotFoundException(this.userNotFoundMessage(username), (Throwable)e);
        }
        return user;
    }

    protected String userNotFoundMessage(String username) {
        return "User  " + username + " not found in usergroupservice: " + this.getName();
    }

    public GeoServerUserGroup getGroupByGroupname(String groupname) {
        AtomicReference group = new AtomicReference();
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> {
            try {
                DirContextOperations dco = LDAPUtils.getLdapTemplateInContext(ctx, this.template).searchForSingleEntry(this.groupSearchBase, this.groupNameFilter, (Object[])new String[]{groupname});
                if (dco != null) {
                    group.set(new GeoServerUserGroup(dco.getStringAttribute(this.groupNameAttribute)));
                }
            }
            catch (IncorrectResultSizeDataAccessException incorrectResultSizeDataAccessException) {
                // empty catch block
            }
        });
        return (GeoServerUserGroup)group.get();
    }

    public GeoServerUser getUserByUsername(String username) {
        AtomicReference user = new AtomicReference();
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> {
            try {
                DirContextOperations dco = LDAPUtils.getLdapTemplateInContext(ctx, this.template).searchForSingleEntry(this.userSearchBase, this.userNameFilter, (Object[])new String[]{username});
                if (dco != null) {
                    user.set(this.createUser(dco));
                }
            }
            catch (IncorrectResultSizeDataAccessException incorrectResultSizeDataAccessException) {
                // empty catch block
            }
        });
        return (GeoServerUser)user.get();
    }

    public SortedSet<GeoServerUser> getUsersForGroup(GeoServerUserGroup group) {
        TreeSet<GeoServerUser> users = new TreeSet<GeoServerUser>();
        if (!this.useNestedGroups) {
            this.addUsersFromGroup(group, users);
        } else {
            HashSet<GeoServerUserGroup> groups = new HashSet<GeoServerUserGroup>();
            groups.add(group);
            this.searchAllNestedChildGroups(group, groups, 1);
            for (GeoServerUserGroup egroup : groups) {
                this.addUsersFromGroup(egroup, users);
            }
        }
        return Collections.unmodifiableSortedSet(users);
    }

    private void addUsersFromGroup(GeoServerUserGroup group, Set<GeoServerUser> users) {
        String groupDn = this.getGroupDn(group);
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> {
            try {
                Object[] usernames;
                DirContextOperations roleObj = LDAPUtils.getLdapTemplateInContext(ctx, this.template).searchForSingleEntry(this.groupSearchBase, this.groupNameFilter, (Object[])new String[]{group.getGroupname(), groupDn});
                if (roleObj != null && (usernames = roleObj.getObjectAttributes(this.groupMembershipAttribute)) != null) {
                    for (Object username : usernames) {
                        GeoServerUser userByUsername;
                        String userNameFromMembership;
                        String user = username.toString();
                        Matcher m = this.userMembershipPattern.matcher(user);
                        if (m.matches()) {
                            user = m.group(1);
                        }
                        if (!StringUtils.isNotBlank((CharSequence)(userNameFromMembership = this.getUserNameFromMembership(user))) || (userByUsername = this.getUserByUsername(userNameFromMembership)) == null) continue;
                        users.add(userByUsername);
                    }
                }
            }
            catch (IncorrectResultSizeDataAccessException incorrectResultSizeDataAccessException) {
                // empty catch block
            }
        });
    }

    private void searchAllNestedChildGroups(GeoServerUserGroup group, Set<GeoServerUserGroup> visitedGroups, int depth) {
        if (this.isOutOfDepthBounds(depth)) {
            return;
        }
        for (GeoServerUserGroup echild : this.getChildrenGroups(group)) {
            if (visitedGroups.contains(echild)) continue;
            visitedGroups.add(echild);
            this.searchAllNestedChildGroups(echild, visitedGroups, depth + 1);
        }
    }

    private Set<GeoServerUserGroup> getChildrenGroups(GeoServerUserGroup parent) {
        Assert.notNull((Object)parent, (String)"Geoserver group shouldn't be null.");
        String groupName = parent.getGroupname();
        HashSet memberGroupDns = new HashSet();
        HashSet<GeoServerUserGroup> childGroups = new HashSet<GeoServerUserGroup>();
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> {
            SpringSecurityLdapTemplate authTemplate = LDAPUtils.getLdapTemplateInContext(ctx, this.template);
            Set membersDns = authTemplate.searchForSingleAttributeValues(this.groupSearchBase, this.groupNameFilter, (Object[])new String[]{groupName}, this.groupMembershipAttribute).stream().filter(this::acceptChildGroup).collect(Collectors.toSet());
            memberGroupDns.addAll(membersDns);
        });
        for (String dn : memberGroupDns) {
            String memberGroupName = this.extractGroupCnFromDn(dn);
            if (!StringUtils.isNotBlank((CharSequence)memberGroupName)) continue;
            childGroups.add(new GeoServerUserGroup(memberGroupName));
        }
        return childGroups;
    }

    private boolean acceptChildGroup(String x) {
        return !this.useNestedGroups || StringUtils.containsIgnoreCase((CharSequence)x, (CharSequence)this.groupSearchBase);
    }

    public SortedSet<GeoServerUserGroup> getGroupsForUser(GeoServerUser user) {
        TreeSet<GeoServerUserGroup> groups = new TreeSet<GeoServerUserGroup>();
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> {
            Set groupNames = LDAPUtils.getLdapTemplateInContext(ctx, this.template).searchForSingleAttributeValues(this.groupSearchBase, this.groupMembershipFilter, (Object[])new String[]{user.getUsername(), this.lookupDn(user.getUsername())}, this.groupNameAttribute);
            for (String groupName : groupNames) {
                groups.add(new GeoServerUserGroup(groupName));
            }
        });
        if (this.useNestedGroups) {
            TreeSet parentGroups = new TreeSet(groups);
            for (GeoServerUserGroup egroup : parentGroups) {
                this.addNestedParentGroups(egroup, groups, 1);
            }
        }
        return Collections.unmodifiableSortedSet(groups);
    }

    private void addNestedParentGroups(GeoServerUserGroup group, Set<GeoServerUserGroup> visitedGroups, int depth) {
        if (this.isOutOfDepthBounds(depth)) {
            return;
        }
        String groupDn = this.getGroupDn(group);
        HashSet parents = new HashSet();
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> {
            SpringSecurityLdapTemplate authTemplate = LDAPUtils.getLdapTemplateInContext(ctx, this.template);
            Set parentGroupsNames = authTemplate.searchForSingleAttributeValues(this.groupSearchBase, this.groupMembershipFilter, (Object[])new String[]{group.getGroupname(), groupDn}, this.groupNameAttribute);
            for (String ename : parentGroupsNames) {
                parents.add(new GeoServerUserGroup(ename));
            }
        });
        for (GeoServerUserGroup eparent : parents) {
            if (visitedGroups.contains(eparent)) continue;
            visitedGroups.add(eparent);
            this.addNestedParentGroups(eparent, visitedGroups, depth + 1);
        }
    }

    private String getGroupDn(GeoServerUserGroup group) {
        String groupName = group.getGroupname();
        MutableObject groupDnReference = new MutableObject(null);
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> {
            String dn = LDAPUtils.getLdapTemplateInContext(ctx, this.template).searchForSingleEntry(this.groupSearchBase, this.groupNameFilter, (Object[])new String[]{groupName}).getDn().toString();
            groupDnReference.setValue((Object)dn);
        });
        return (String)groupDnReference.getValue();
    }

    public int getUserCount() {
        AtomicInteger size = new AtomicInteger(0);
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> LDAPUtils.getLdapTemplateInContext(ctx, this.template).search(this.userSearchBase, LDAPUtils.escapeSearchString(this.allUsersSearchFilter), this.counter(size)));
        return size.get();
    }

    public int getGroupCount() {
        AtomicInteger size = new AtomicInteger(0);
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> LDAPUtils.getLdapTemplateInContext(ctx, this.template).search(this.groupSearchBase, LDAPUtils.escapeSearchString(this.allGroupsSearchFilter), this.counter(size)));
        return size.get();
    }

    public SortedSet<GeoServerUser> getUsersHavingProperty(String propname) {
        TreeSet<GeoServerUser> users = new TreeSet<GeoServerUser>();
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> LDAPUtils.getLdapTemplateInContext(ctx, this.template).search(this.userSearchBase, propname + "=*", this.addToUsers(users)));
        return users;
    }

    public int getUserCountHavingProperty(String propname) {
        AtomicInteger size = new AtomicInteger(0);
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> LDAPUtils.getLdapTemplateInContext(ctx, this.template).search(this.userSearchBase, propname + "=*", this.counter(size)));
        return size.get();
    }

    public SortedSet<GeoServerUser> getUsersNotHavingProperty(String propname) {
        TreeSet<GeoServerUser> users = new TreeSet<GeoServerUser>();
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> LDAPUtils.getLdapTemplateInContext(ctx, this.template).search(this.userSearchBase, "(&(!(" + propname + "=*))(" + LDAPUtils.escapeSearchString(this.allUsersSearchFilter) + "))", this.addToUsers(users)));
        return users;
    }

    public int getUserCountNotHavingProperty(String propname) {
        AtomicInteger size = new AtomicInteger(0);
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> LDAPUtils.getLdapTemplateInContext(ctx, this.template).search(this.userSearchBase, "(&(!(" + propname + "=*))(" + LDAPUtils.escapeSearchString(this.allUsersSearchFilter) + "))", this.counter(size)));
        return size.get();
    }

    public SortedSet<GeoServerUser> getUsersHavingPropertyValue(String propname, String propvalue) throws IOException {
        TreeSet<GeoServerUser> users = new TreeSet<GeoServerUser>();
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> LDAPUtils.getLdapTemplateInContext(ctx, this.template).search(this.userSearchBase, propname + "=" + LDAPUtils.escapeSearchString(propvalue), this.addToUsers(users)));
        return users;
    }

    public int getUserCountHavingPropertyValue(String propname, String propvalue) throws IOException {
        AtomicInteger size = new AtomicInteger(0);
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> LDAPUtils.getLdapTemplateInContext(ctx, this.template).search(this.userSearchBase, propname + "=" + LDAPUtils.escapeSearchString(propvalue), this.counter(size)));
        return size.get();
    }
}

