/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.ldap;

import org.geoserver.security.config.BaseSecurityNamedServiceConfig;

public abstract class LDAPBaseSecurityServiceConfig
extends BaseSecurityNamedServiceConfig {
    private static final long serialVersionUID = -6478665500954608763L;
    public static final String ROLE_PREFIX_DEFAULT = "ROLE_";
    public static final boolean CONVERT_ROLE_UPPERCASE_DEFAULT = true;
    String serverURL;
    String groupSearchBase;
    String groupFilter;
    String groupNameAttribute;
    String allGroupsSearchFilter;
    String groupSearchFilter;
    String groupMembershipAttribute;
    String userSearchBase;
    String userFilter;
    String userNameAttribute;
    String allUsersSearchFilter;
    Boolean useTLS;
    private boolean useNestedParentGroups = false;
    private int maxGroupSearchLevel = 10;
    private String nestedGroupSearchFilter = "(member={0})";
    Boolean bindBeforeGroupSearch;
    String adminGroup;
    String groupAdminGroup;
    String rolePrefix = "ROLE_";
    Boolean convertToUpperCase = true;
    String user;
    String password;

    public LDAPBaseSecurityServiceConfig() {
    }

    public LDAPBaseSecurityServiceConfig(LDAPBaseSecurityServiceConfig other) {
        super((BaseSecurityNamedServiceConfig)other);
        this.serverURL = other.getServerURL();
        this.groupSearchBase = other.getGroupSearchBase();
        this.groupFilter = other.getGroupFilter();
        this.adminGroup = other.getAdminGroup();
        this.groupAdminGroup = other.getGroupAdminGroup();
        this.bindBeforeGroupSearch = other.isBindBeforeGroupSearch();
        this.userFilter = other.getUserFilter();
        this.useTLS = other.isUseTLS();
        this.user = other.getUser();
        this.password = other.getPassword();
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public String getGroupSearchBase() {
        return this.groupSearchBase;
    }

    public void setGroupSearchBase(String groupSearchBase) {
        this.groupSearchBase = groupSearchBase;
    }

    public String getGroupFilter() {
        return this.groupFilter;
    }

    public void setGroupFilter(String groupSearchFilter) {
        this.groupFilter = groupSearchFilter;
    }

    public void setUseTLS(Boolean useTLS) {
        this.useTLS = useTLS;
    }

    public Boolean isUseTLS() {
        return this.useTLS;
    }

    public Boolean isBindBeforeGroupSearch() {
        return this.bindBeforeGroupSearch == null ? false : this.bindBeforeGroupSearch;
    }

    public void setBindBeforeGroupSearch(Boolean bindBeforeGroupSearch) {
        this.bindBeforeGroupSearch = bindBeforeGroupSearch;
    }

    public String getAdminGroup() {
        return this.adminGroup;
    }

    public void setAdminGroup(String adminGroup) {
        this.adminGroup = adminGroup;
    }

    public String getGroupAdminGroup() {
        return this.groupAdminGroup;
    }

    public void setGroupAdminGroup(String groupAdminGroup) {
        this.groupAdminGroup = groupAdminGroup;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public void setUserFilter(String userFilter) {
        this.userFilter = userFilter;
    }

    public String getGroupNameAttribute() {
        return this.groupNameAttribute;
    }

    public void setGroupNameAttribute(String groupNameAttribute) {
        this.groupNameAttribute = groupNameAttribute;
    }

    public String getAllGroupsSearchFilter() {
        return this.allGroupsSearchFilter;
    }

    public void setAllGroupsSearchFilter(String allGroupsSearchFilter) {
        this.allGroupsSearchFilter = allGroupsSearchFilter;
    }

    public String getGroupSearchFilter() {
        return this.groupSearchFilter;
    }

    public void setGroupSearchFilter(String groupMembershipFilter) {
        this.groupSearchFilter = groupMembershipFilter;
    }

    public String getGroupMembershipAttribute() {
        return this.groupMembershipAttribute;
    }

    public void setGroupMembershipAttribute(String groupMembershipAttribute) {
        this.groupMembershipAttribute = groupMembershipAttribute;
    }

    public String getUserSearchBase() {
        return this.userSearchBase;
    }

    public void setUserSearchBase(String userSearchBase) {
        this.userSearchBase = userSearchBase;
    }

    public String getUserNameAttribute() {
        return this.userNameAttribute;
    }

    public void setUserNameAttribute(String userNameAttribute) {
        this.userNameAttribute = userNameAttribute;
    }

    public String getAllUsersSearchFilter() {
        return this.allUsersSearchFilter;
    }

    public void setAllUsersSearchFilter(String allUsersSearchFilter) {
        this.allUsersSearchFilter = allUsersSearchFilter;
    }

    public Boolean getUseTLS() {
        return this.useTLS;
    }

    public Boolean getBindBeforeGroupSearch() {
        return this.bindBeforeGroupSearch;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String userDn) {
        this.user = userDn;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isUseNestedParentGroups() {
        return this.useNestedParentGroups;
    }

    public void setUseNestedParentGroups(boolean useNestedParentGroups) {
        this.useNestedParentGroups = useNestedParentGroups;
    }

    public int getMaxGroupSearchLevel() {
        return this.maxGroupSearchLevel;
    }

    public void setMaxGroupSearchLevel(int maxGroupSearchLevel) {
        this.maxGroupSearchLevel = maxGroupSearchLevel;
    }

    public String getNestedGroupSearchFilter() {
        return this.nestedGroupSearchFilter;
    }

    public void setNestedGroupSearchFilter(String nestedGroupSearchFilter) {
        this.nestedGroupSearchFilter = nestedGroupSearchFilter;
    }

    public String getRolePrefix() {
        if (this.rolePrefix == null) {
            return ROLE_PREFIX_DEFAULT;
        }
        return this.rolePrefix;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public Boolean getConvertToUpperCase() {
        if (this.convertToUpperCase == null) {
            return true;
        }
        return this.convertToUpperCase;
    }

    public void setConvertToUpperCase(Boolean convertToUpperCase) {
        this.convertToUpperCase = convertToUpperCase;
    }
}

