/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import org.geoserver.data.test.LiveSystemTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.GroupAdminServiceTest;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.jdbc.AbstractJDBCService;
import org.geoserver.security.jdbc.JDBCRoleService;
import org.geoserver.security.jdbc.JDBCRoleStore;
import org.geoserver.security.jdbc.JDBCTestSupport;
import org.geoserver.security.jdbc.JDBCUserGroupService;
import org.geoserver.security.jdbc.JDBCUserGroupStore;
import org.geoserver.security.jdbc.config.JDBCRoleServiceConfig;
import org.junit.After;

public class JDBCGroupAdminServiceTest
extends GroupAdminServiceTest {
    protected SystemTestData createTestData() throws Exception {
        return new LiveSystemTestData(JDBCGroupAdminServiceTest.unpackTestDataDir());
    }

    @After
    public void rollback() throws Exception {
        if (this.ugStore != null) {
            this.ugStore.load();
        }
        if (this.roleStore != null) {
            this.roleStore.load();
        }
    }

    public GeoServerUserGroupService createUserGroupService(String name) throws Exception {
        JDBCUserGroupService service = (JDBCUserGroupService)JDBCTestSupport.createH2UserGroupService(name, this.getSecurityManager());
        if (!service.tablesAlreadyCreated()) {
            service.createTables();
        }
        return service;
    }

    public GeoServerRoleService createRoleService(String name) throws Exception {
        JDBCRoleService service = (JDBCRoleService)JDBCTestSupport.createH2RoleService(name, this.getSecurityManager());
        if (!service.tablesAlreadyCreated()) {
            service.createTables();
        }
        JDBCRoleServiceConfig gaConfig = (JDBCRoleServiceConfig)this.getSecurityManager().loadRoleServiceConfig(name);
        gaConfig.setAdminRoleName("adminRole");
        gaConfig.setGroupAdminRoleName("groupAdminRole");
        this.getSecurityManager().saveRoleService((SecurityRoleServiceConfig)gaConfig);
        return this.getSecurityManager().loadRoleService(name);
    }

    public GeoServerRoleStore createStore(GeoServerRoleService service) throws IOException {
        JDBCRoleStore store = (JDBCRoleStore)super.createStore(service);
        try {
            JDBCTestSupport.dropExistingTables((AbstractJDBCService)store, store.getConnection());
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        store.createTables();
        store.store();
        return store;
    }

    public GeoServerUserGroupStore createStore(GeoServerUserGroupService service) throws IOException {
        JDBCUserGroupStore store = (JDBCUserGroupStore)super.createStore(service);
        try {
            JDBCTestSupport.dropExistingTables((AbstractJDBCService)store, store.getConnection());
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        store.createTables();
        store.store();
        return store;
    }
}

