/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jdbc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import org.geoserver.data.test.LiveDbmsData;
import org.geoserver.security.AbstractSecurityServiceTest;
import org.geoserver.security.impl.Util;
import org.geoserver.util.IOUtils;
import org.geotools.util.logging.Logging;

public class LiveDbmsDataSecurity
extends LiveDbmsData {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.jdbc");
    protected Boolean available = null;

    public LiveDbmsDataSecurity(File dataDirSourceDirectory, String fixtureId, File sqlScript) throws IOException {
        super(dataDirSourceDirectory, fixtureId, sqlScript);
    }

    public LiveDbmsDataSecurity(String fixtureId) throws Exception {
        this(AbstractSecurityServiceTest.unpackTestDataDir(), fixtureId, null);
    }

    public void setUp() throws Exception {
        this.data = IOUtils.createRandomDirectory((String)"./target", (String)"live", (String)"data");
        IOUtils.deepCopy((File)this.source, (File)this.data);
    }

    public boolean isTestDataAvailable() {
        if (this.available != null) {
            return this.available;
        }
        this.available = super.isTestDataAvailable();
        if (!this.available.booleanValue()) {
            return this.available;
        }
        Properties props = null;
        try {
            props = Util.loadUniversal((InputStream)new FileInputStream(this.fixture));
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        String msgPrefix = "Disabling test based on fixture " + this.fixtureId + " since ";
        String driverClassName = props.getProperty("driver");
        if (driverClassName == null) {
            LOGGER.warning(msgPrefix + "property \"driver\" not found in " + this.fixture.getAbsolutePath());
            this.available = false;
            return this.available;
        }
        String url = props.getProperty("url");
        if (url == null) {
            LOGGER.warning(msgPrefix + "property \"url\" not found in " + this.fixture.getAbsolutePath());
            this.available = false;
            return this.available;
        }
        String user = props.getProperty("user");
        if (user == null) {
            user = props.getProperty("username");
        }
        String password = props.getProperty("password");
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warning(msgPrefix + " driver class not found: " + driverClassName);
            this.available = false;
            return this.available;
        }
        try {
            Connection con;
            Connection connection = con = user == null ? DriverManager.getConnection(url) : DriverManager.getConnection(url, user, password);
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException ex) {
            LOGGER.warning(msgPrefix + " an sql error:\n " + ex.getMessage());
            this.available = false;
            return this.available;
        }
        this.available = true;
        return this.available;
    }

    public File getFixture() {
        return this.fixture;
    }
}

