/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.dispatch;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.ServiceInfoImpl;
import org.geoserver.gwc.dispatch.GwcOperationProxy;
import org.geotools.util.Version;
import org.geowebcache.GeoWebCacheDispatcher;
import org.geowebcache.GeoWebCacheExtensions;

public class GwcServiceProxy {
    private final ServiceInfoImpl serviceInfo = new ServiceInfoImpl();
    private final GeoWebCacheDispatcher gwcDispatcher;

    public GwcServiceProxy() {
        this.serviceInfo.setId("gwc");
        this.serviceInfo.setName("gwc");
        this.serviceInfo.setEnabled(true);
        this.serviceInfo.setVersions((List)ImmutableList.of((Object)new Version("1.0.0")));
        this.gwcDispatcher = (GeoWebCacheDispatcher)GeoWebCacheExtensions.bean(GeoWebCacheDispatcher.class);
    }

    public ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    public GwcOperationProxy dispatch(HttpServletRequest rawRequest, HttpServletResponse rawRespose) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper(rawRespose);
        this.gwcDispatcher.handleRequest(rawRequest, (HttpServletResponse)responseWrapper);
        String contentType = responseWrapper.getContentType();
        Map<String, String> headers = responseWrapper.getHeaders();
        byte[] bytes = responseWrapper.out.getBytes();
        return new GwcOperationProxy(contentType, headers, bytes);
    }

    private static class BufferedServletOutputStream
    extends ServletOutputStream {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);

        private BufferedServletOutputStream() {
        }

        public void write(int b) throws IOException {
            this.outputStream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.outputStream.write(b, off, len);
        }

        public byte[] getBytes() {
            return this.outputStream.toByteArray();
        }
    }

    private final class ResponseWrapper
    extends HttpServletResponseWrapper {
        final BufferedServletOutputStream out;
        Map<String, String> headers;

        private ResponseWrapper(HttpServletResponse response) {
            super(response);
            this.out = new BufferedServletOutputStream();
            this.headers = new LinkedHashMap<String, String>();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.out;
        }

        public void setHeader(String name, String value) {
            this.headers.put(name, value);
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }
    }
}

