/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.wms;

import java.util.List;
import junit.framework.Test;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.CatalogConfiguration;
import org.geoserver.test.GeoServerTestSupport;
import org.geoserver.test.OneTimeSetupTest;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class CachingExtendedCapabilitiesProviderTest
extends GeoServerTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new CachingExtendedCapabilitiesProviderTest());
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setProxyBaseUrl("../wms/src/test/resources/geoserver");
        this.getGeoServer().save(global);
    }

    public void testCapabilitiesContributedInternalDTD() throws Exception {
        GWC.get().getConfig().setDirectWMSIntegrationEnabled(false);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1&tiled=true"), false);
        DocumentType doctype = dom.getDoctype();
        CachingExtendedCapabilitiesProviderTest.assertNotNull((Object)doctype);
        CachingExtendedCapabilitiesProviderTest.assertEquals((String)"WMT_MS_Capabilities", (String)doctype.getName());
        String systemId = doctype.getSystemId();
        CachingExtendedCapabilitiesProviderTest.assertEquals((String)"../wms/src/test/resources/geoserver/schemas/wms/1.1.1/WMS_MS_Capabilities.dtd", (String)systemId);
        String internalSubset = doctype.getInternalSubset();
        CachingExtendedCapabilitiesProviderTest.assertTrue((internalSubset == null || !internalSubset.contains("TileSet") ? 1 : 0) != 0);
        GWC.get().getConfig().setDirectWMSIntegrationEnabled(true);
        dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1&tiled=true"), false);
        doctype = dom.getDoctype();
        CachingExtendedCapabilitiesProviderTest.assertNotNull((Object)doctype);
        CachingExtendedCapabilitiesProviderTest.assertEquals((String)"WMT_MS_Capabilities", (String)doctype.getName());
        systemId = doctype.getSystemId();
        CachingExtendedCapabilitiesProviderTest.assertEquals((String)"../wms/src/test/resources/geoserver/schemas/wms/1.1.1/WMS_MS_Capabilities.dtd", (String)systemId);
        internalSubset = doctype.getInternalSubset();
        CachingExtendedCapabilitiesProviderTest.assertNotNull((Object)internalSubset);
        CachingExtendedCapabilitiesProviderTest.assertTrue((String)internalSubset, (boolean)internalSubset.trim().startsWith("<!ELEMENT VendorSpecificCapabilities"));
        CachingExtendedCapabilitiesProviderTest.assertTrue((String)internalSubset, (boolean)internalSubset.contains("(TileSet*)"));
        CachingExtendedCapabilitiesProviderTest.assertTrue((String)internalSubset, (boolean)internalSubset.contains("<!ELEMENT TileSet (SRS,BoundingBox?,Resolutions,Width,Height,Format,Layers*,Styles*)>"));
        CachingExtendedCapabilitiesProviderTest.assertTrue((String)internalSubset, (boolean)internalSubset.contains("<!ELEMENT Resolutions (#PCDATA)>"));
        CachingExtendedCapabilitiesProviderTest.assertTrue((String)internalSubset, (boolean)internalSubset.contains("<!ELEMENT Width (#PCDATA)>"));
        CachingExtendedCapabilitiesProviderTest.assertTrue((String)internalSubset, (boolean)internalSubset.contains("<!ELEMENT Height (#PCDATA)>"));
        CachingExtendedCapabilitiesProviderTest.assertTrue((String)internalSubset, (boolean)internalSubset.contains("<!ELEMENT Layers (#PCDATA)>"));
        CachingExtendedCapabilitiesProviderTest.assertTrue((String)internalSubset, (boolean)internalSubset.contains("<!ELEMENT Styles (#PCDATA)>"));
    }

    public void testTileSets() throws Exception {
        int validLayers = 0;
        List layers = this.getCatalog().getLayers();
        for (LayerInfo l : layers) {
            if (!CatalogConfiguration.isLayerExposable((LayerInfo)l)) continue;
            ++validLayers;
        }
        int numLayers = validLayers;
        int numCRSs = 2;
        int numFormats = 2;
        int numTileSets = numLayers * 2 * 2;
        String tileSetPath = "/WMT_MS_Capabilities/Capability/VendorSpecificCapabilities/TileSet";
        GWC.get().getConfig().setDirectWMSIntegrationEnabled(false);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1&tiled=true"), false);
        XMLAssert.assertXpathNotExists((String)tileSetPath, (Document)dom);
        GWC.get().getConfig().setDirectWMSIntegrationEnabled(true);
        dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1&tiled=true"), false);
        XMLAssert.assertXpathExists((String)tileSetPath, (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(numTileSets), (String)("count(" + tileSetPath + ")"), (Document)dom);
        XMLAssert.assertXpathExists((String)(tileSetPath + "[1]/SRS"), (Document)dom);
        XMLAssert.assertXpathExists((String)(tileSetPath + "[1]/BoundingBox"), (Document)dom);
        XMLAssert.assertXpathExists((String)(tileSetPath + "[1]/Resolutions"), (Document)dom);
        XMLAssert.assertXpathExists((String)(tileSetPath + "[1]/Width"), (Document)dom);
        XMLAssert.assertXpathExists((String)(tileSetPath + "[1]/Height"), (Document)dom);
        XMLAssert.assertXpathExists((String)(tileSetPath + "[1]/Format"), (Document)dom);
        XMLAssert.assertXpathExists((String)(tileSetPath + "[1]/Layers"), (Document)dom);
        XMLAssert.assertXpathExists((String)(tileSetPath + "[1]/Styles"), (Document)dom);
    }

    public void testLocalWorkspaceIntegration() throws Exception {
        String tileSetPath = "//WMT_MS_Capabilities/Capability/VendorSpecificCapabilities/TileSet";
        String localName = MockData.BASIC_POLYGONS.getLocalPart();
        String qualifiedName = super.getLayerId(MockData.BASIC_POLYGONS);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1&tiled=true"), false);
        XMLAssert.assertXpathExists((String)("//WMT_MS_Capabilities/Capability/VendorSpecificCapabilities/TileSet/Layers[text() = '" + qualifiedName + "']"), (Document)dom);
        dom = this.dom(this.get("cite/wms?request=getCapabilities&version=1.1.1&tiled=true"), false);
        XMLAssert.assertXpathExists((String)("//WMT_MS_Capabilities/Capability/VendorSpecificCapabilities/TileSet/Layers[text() = '" + localName + "']"), (Document)dom);
    }
}

