/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import junit.framework.TestCase;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.impl.LayerGroupInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.GWCTestHelpers;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geowebcache.filter.parameters.FloatParameterFilter;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.RegexParameterFilter;

public class TileLayerInfoUtilTest
extends TestCase {
    private GWCConfig defaults;
    private GeoServerTileLayerInfo defaultVectorInfo;

    protected void setUp() throws Exception {
        this.defaults = GWCConfig.getOldDefaults();
        this.defaultVectorInfo = TileLayerInfoUtil.create((GWCConfig)this.defaults);
        this.defaultVectorInfo.getMimeFormats().clear();
        this.defaultVectorInfo.getMimeFormats().addAll(this.defaults.getDefaultVectorCacheFormats());
    }

    public void testCreateLayerInfo() {
        LayerInfoImpl layer = GWCTestHelpers.mockLayer("testLayer", new String[0], LayerInfo.Type.RASTER);
        GeoServerTileLayerInfoImpl info = TileLayerInfoUtil.loadOrCreate((LayerInfo)layer, (GWCConfig)this.defaults);
        this.defaultVectorInfo.setId(layer.getId());
        this.defaultVectorInfo.setName(GWC.tileLayerName((LayerInfo)layer));
        TileLayerInfoUtilTest.assertNotNull((Object)info);
        TileLayerInfoUtilTest.assertEquals((Object)this.defaultVectorInfo, (Object)info);
    }

    public void testCreateLayerGroupInfo() {
        LayerGroupInfoImpl group = GWCTestHelpers.mockGroup("testGroup", new LayerInfo[]{GWCTestHelpers.mockLayer("testLayer", new String[0], LayerInfo.Type.RASTER)});
        this.defaults.getDefaultOtherCacheFormats().clear();
        this.defaults.getDefaultOtherCacheFormats().add("image/png8");
        this.defaults.getDefaultOtherCacheFormats().add("image/jpeg");
        GeoServerTileLayerInfoImpl expected = TileLayerInfoUtil.create((GWCConfig)this.defaults);
        expected.setId(group.getId());
        expected.setName(GWC.tileLayerName((LayerGroupInfo)group));
        GeoServerTileLayerInfoImpl info = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)group, (GWCConfig)this.defaults);
        TileLayerInfoUtilTest.assertNotNull((Object)info);
        TileLayerInfoUtilTest.assertEquals((Object)expected, (Object)info);
    }

    public void testCreateLayerInfoAutoCacheStyles() {
        GeoServerTileLayerInfo info = this.defaultVectorInfo;
        info.setAutoCacheStyles(true);
        this.defaults.setCacheNonDefaultStyles(true);
        LayerInfoImpl layer = GWCTestHelpers.mockLayer("testLayer", new String[]{"style1", "style2"}, LayerInfo.Type.RASTER);
        GeoServerTileLayerInfoImpl actual = TileLayerInfoUtil.loadOrCreate((LayerInfo)layer, (GWCConfig)this.defaults);
        TileLayerInfoUtil.setCachedStyles((GeoServerTileLayerInfo)info, (String)"default", (Set)ImmutableSet.of((Object)"style1", (Object)"style2"));
        TileLayerInfoUtilTest.assertEquals((Object)info.cachedStyles(), (Object)actual.cachedStyles());
        layer.setDefaultStyle(null);
        TileLayerInfoUtil.setCachedStyles((GeoServerTileLayerInfo)info, (String)"", (Set)ImmutableSet.of((Object)"style1", (Object)"style2"));
        actual = TileLayerInfoUtil.loadOrCreate((LayerInfo)layer, (GWCConfig)this.defaults);
        TileLayerInfoUtilTest.assertEquals((Object)ImmutableSet.of((Object)"style1", (Object)"style2"), (Object)actual.cachedStyles());
    }

    public void testCreateLayerGroup() {
        LayerGroupInfoImpl lg = GWCTestHelpers.mockGroup("tesGroup", new LayerInfo[]{GWCTestHelpers.mockLayer("L1", new String[0], LayerInfo.Type.RASTER), GWCTestHelpers.mockLayer("L2", new String[0], LayerInfo.Type.RASTER)});
        GeoServerTileLayerInfo info = this.defaultVectorInfo;
        info.setId(lg.getId());
        info.setName(GWC.tileLayerName((LayerGroupInfo)lg));
        info.getMimeFormats().clear();
        info.getMimeFormats().addAll(this.defaults.getDefaultOtherCacheFormats());
        GeoServerTileLayerInfoImpl actual = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)lg, (GWCConfig)this.defaults);
        TileLayerInfoUtilTest.assertEquals((Object)info, (Object)actual);
    }

    public void testUpdateAcceptAllRegExParameterFilter() {
        GeoServerTileLayerInfo info = this.defaultVectorInfo;
        TileLayerInfoUtil.updateAcceptAllRegExParameterFilter((GeoServerTileLayerInfo)info, (String)"ENV", (boolean)true);
        ParameterFilter filter = TileLayerInfoUtil.findParameterFilter((String)"ENV", (Set)info.getParameterFilters());
        TileLayerInfoUtilTest.assertTrue((boolean)(filter instanceof RegexParameterFilter));
        TileLayerInfoUtilTest.assertEquals((String)".*", (String)((RegexParameterFilter)filter).getRegex());
        TileLayerInfoUtil.updateAcceptAllRegExParameterFilter((GeoServerTileLayerInfo)info, (String)"ENV", (boolean)true);
        ParameterFilter filter2 = TileLayerInfoUtil.findParameterFilter((String)"ENV", (Set)info.getParameterFilters());
        TileLayerInfoUtilTest.assertNotSame((Object)filter, (Object)filter2);
        TileLayerInfoUtilTest.assertEquals((Object)filter, (Object)filter2);
        TileLayerInfoUtil.updateAcceptAllRegExParameterFilter((GeoServerTileLayerInfo)info, (String)"ENV", (boolean)false);
        TileLayerInfoUtilTest.assertNull((Object)TileLayerInfoUtil.findParameterFilter((String)"ENV", (Set)info.getParameterFilters()));
    }

    public void testUpdateAcceptAllFloatParameterFilter() {
        GeoServerTileLayerInfo info = this.defaultVectorInfo;
        TileLayerInfoUtil.updateAcceptAllFloatParameterFilter((GeoServerTileLayerInfo)info, (String)"ELEVATION", (boolean)true);
        ParameterFilter filter = TileLayerInfoUtil.findParameterFilter((String)"ELEVATION", (Set)info.getParameterFilters());
        TileLayerInfoUtilTest.assertTrue((boolean)(filter instanceof FloatParameterFilter));
        TileLayerInfoUtilTest.assertEquals((int)0, (int)((FloatParameterFilter)filter).getValues().size());
        TileLayerInfoUtil.updateAcceptAllFloatParameterFilter((GeoServerTileLayerInfo)info, (String)"ELEVATION", (boolean)true);
        ParameterFilter filter2 = TileLayerInfoUtil.findParameterFilter((String)"ELEVATION", (Set)info.getParameterFilters());
        TileLayerInfoUtilTest.assertNotSame((Object)filter, (Object)filter2);
        TileLayerInfoUtilTest.assertEquals((Object)filter, (Object)filter2);
        TileLayerInfoUtil.updateAcceptAllFloatParameterFilter((GeoServerTileLayerInfo)info, (String)"ELEVATION", (boolean)false);
        TileLayerInfoUtilTest.assertNull((Object)TileLayerInfoUtil.findParameterFilter((String)"ELEVATION", (Set)info.getParameterFilters()));
    }
}

