/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import junit.framework.TestCase;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.impl.LayerGroupInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.GWCTestHelpers;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.gwc.layer.LegacyTileLayerInfoLoader;
import org.geoserver.gwc.layer.TileLayerInfoUtil;

public class LegacyTileLayerInfoLoaderTest
extends TestCase {
    private GWCConfig defaults;
    private GeoServerTileLayerInfo defaultVectorInfo;

    public void setUp() {
        this.defaults = GWCConfig.getOldDefaults();
        this.defaultVectorInfo = TileLayerInfoUtil.create((GWCConfig)this.defaults);
        this.defaultVectorInfo.getMimeFormats().clear();
        this.defaultVectorInfo.getMimeFormats().addAll(this.defaults.getDefaultVectorCacheFormats());
    }

    public void testLoadLayerInfo() {
        LayerInfoImpl layer = GWCTestHelpers.mockLayer("testLayer", new String[0], LayerInfo.Type.RASTER);
        LegacyTileLayerInfoLoaderTest.assertNull((Object)LegacyTileLayerInfoLoader.load((LayerInfo)layer));
        LegacyTileLayerInfoLoader.save((GeoServerTileLayerInfo)this.defaultVectorInfo, (MetadataMap)layer.getMetadata());
        GeoServerTileLayerInfoImpl info2 = LegacyTileLayerInfoLoader.load((LayerInfo)layer);
        this.defaultVectorInfo.setId(layer.getId());
        this.defaultVectorInfo.setName(GWC.tileLayerName((LayerInfo)layer));
        LegacyTileLayerInfoLoaderTest.assertEquals((Object)this.defaultVectorInfo, (Object)info2);
    }

    public void testLoadLayerInfoExtraStyles() {
        GeoServerTileLayerInfo info = this.defaultVectorInfo;
        info.setAutoCacheStyles(false);
        TileLayerInfoUtil.setCachedStyles((GeoServerTileLayerInfo)info, (String)"default", (Set)ImmutableSet.of((Object)"style1"));
        LayerInfoImpl layer = GWCTestHelpers.mockLayer("testLayer", new String[]{"style1", "style2"}, LayerInfo.Type.RASTER);
        LegacyTileLayerInfoLoaderTest.assertNull((Object)LegacyTileLayerInfoLoader.load((LayerInfo)layer));
        LegacyTileLayerInfoLoader.save((GeoServerTileLayerInfo)info, (MetadataMap)layer.getMetadata());
        GeoServerTileLayerInfoImpl actual = LegacyTileLayerInfoLoader.load((LayerInfo)layer);
        info.setId(layer.getId());
        info.setName(GWC.tileLayerName((LayerInfo)layer));
        LegacyTileLayerInfoLoaderTest.assertEquals((Object)info, (Object)actual);
        layer.setDefaultStyle(null);
        TileLayerInfoUtil.setCachedStyles((GeoServerTileLayerInfo)info, null, (Set)ImmutableSet.of((Object)"style1"));
        LegacyTileLayerInfoLoader.save((GeoServerTileLayerInfo)info, (MetadataMap)layer.getMetadata());
        actual = LegacyTileLayerInfoLoader.load((LayerInfo)layer);
        LegacyTileLayerInfoLoaderTest.assertEquals((Object)ImmutableSet.of((Object)"style1"), (Object)actual.cachedStyles());
    }

    public void testLoadLayerInfoAutoCacheStyles() {
        GeoServerTileLayerInfo info = this.defaultVectorInfo;
        info.setAutoCacheStyles(true);
        LayerInfoImpl layer = GWCTestHelpers.mockLayer("testLayer", new String[]{"style1", "style2"}, LayerInfo.Type.RASTER);
        LegacyTileLayerInfoLoaderTest.assertNull((Object)LegacyTileLayerInfoLoader.load((LayerInfo)layer));
        LegacyTileLayerInfoLoader.save((GeoServerTileLayerInfo)info, (MetadataMap)layer.getMetadata());
        GeoServerTileLayerInfoImpl actual = LegacyTileLayerInfoLoader.load((LayerInfo)layer);
        TileLayerInfoUtil.setCachedStyles((GeoServerTileLayerInfo)info, (String)"default", (Set)ImmutableSet.of((Object)"style1", (Object)"style2"));
        info.setId(layer.getId());
        info.setName(GWC.tileLayerName((LayerInfo)layer));
        LegacyTileLayerInfoLoaderTest.assertEquals((Object)info, (Object)actual);
        layer.setDefaultStyle(null);
        TileLayerInfoUtil.setCachedStyles((GeoServerTileLayerInfo)info, null, (Set)ImmutableSet.of((Object)"style1", (Object)"style2"));
        actual = LegacyTileLayerInfoLoader.load((LayerInfo)layer);
        LegacyTileLayerInfoLoaderTest.assertEquals((Object)ImmutableSet.of((Object)"style1", (Object)"style2"), (Object)actual.cachedStyles());
    }

    public void testLoadLayerGroup() {
        LayerGroupInfoImpl lg = GWCTestHelpers.mockGroup("tesGroup", new LayerInfo[]{GWCTestHelpers.mockLayer("L1", new String[0], LayerInfo.Type.RASTER), GWCTestHelpers.mockLayer("L2", new String[0], LayerInfo.Type.RASTER)});
        LegacyTileLayerInfoLoaderTest.assertNull((Object)LegacyTileLayerInfoLoader.load((LayerGroupInfo)lg));
        GeoServerTileLayerInfo info = this.defaultVectorInfo;
        info.getMimeFormats().clear();
        info.getMimeFormats().addAll(this.defaults.getDefaultOtherCacheFormats());
        LegacyTileLayerInfoLoader.save((GeoServerTileLayerInfo)info, (MetadataMap)lg.getMetadata());
        GeoServerTileLayerInfoImpl actual = LegacyTileLayerInfoLoader.load((LayerGroupInfo)lg);
        info.setId(lg.getId());
        info.setName(GWC.tileLayerName((LayerGroupInfo)lg));
        LegacyTileLayerInfoLoaderTest.assertEquals((Object)info, (Object)actual);
    }

    public void testClear() {
        LayerGroupInfoImpl lg = GWCTestHelpers.mockGroup("tesGroup", new LayerInfo[]{GWCTestHelpers.mockLayer("L1", new String[0], LayerInfo.Type.RASTER), GWCTestHelpers.mockLayer("L2", new String[0], LayerInfo.Type.RASTER)});
        LegacyTileLayerInfoLoaderTest.assertNull((Object)LegacyTileLayerInfoLoader.load((LayerGroupInfo)lg));
        GeoServerTileLayerInfo info = this.defaultVectorInfo;
        info.getMimeFormats().clear();
        info.getMimeFormats().addAll(this.defaults.getDefaultOtherCacheFormats());
        LegacyTileLayerInfoLoader.save((GeoServerTileLayerInfo)info, (MetadataMap)lg.getMetadata());
        GeoServerTileLayerInfoImpl actual = LegacyTileLayerInfoLoader.load((LayerGroupInfo)lg);
        LegacyTileLayerInfoLoaderTest.assertNotNull((Object)actual);
        LegacyTileLayerInfoLoader.clear((MetadataMap)lg.getMetadata());
        LegacyTileLayerInfoLoaderTest.assertNull((Object)LegacyTileLayerInfoLoader.load((LayerGroupInfo)lg));
    }
}

