/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.collect.ImmutableSet;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.gwc.layer.DefaultTileLayerCatalog;
import org.geoserver.gwc.layer.GWCGeoServerConfigurationProvider;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geowebcache.config.XMLConfiguration;

public class DefaultTileLayerCatalogTest
extends TestCase {
    private File baseDirectory;
    private DefaultTileLayerCatalog catalog;

    protected void setUp() throws Exception {
        this.baseDirectory = new File("target", "mockTileLayerCatalog");
        FileUtils.deleteDirectory((File)this.baseDirectory);
        this.baseDirectory.mkdirs();
        GeoServerResourceLoader resourceLoader = new GeoServerResourceLoader(this.baseDirectory);
        XStream xStream = XMLConfiguration.getConfiguredXStream((XStream)new XStream(), null);
        xStream = new GWCGeoServerConfigurationProvider().getConfiguredXStream(xStream);
        this.catalog = new DefaultTileLayerCatalog(resourceLoader, xStream);
    }

    protected void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.baseDirectory);
    }

    public void testGetLayerById() {
        GeoServerTileLayerInfoImpl info = new GeoServerTileLayerInfoImpl();
        info.setId("id1");
        info.setName("name1");
        this.catalog.save((GeoServerTileLayerInfo)info);
        GeoServerTileLayerInfo actual = this.catalog.getLayerById("id1");
        actual = (GeoServerTileLayerInfo)ModificationProxy.unwrap((Object)actual);
        DefaultTileLayerCatalogTest.assertEquals((Object)info, (Object)actual);
    }

    public void testGetLayerByName() {
        GeoServerTileLayerInfoImpl info = new GeoServerTileLayerInfoImpl();
        info.setId("id1");
        info.setName("name1");
        this.catalog.save((GeoServerTileLayerInfo)info);
        GeoServerTileLayerInfo actual = this.catalog.getLayerByName("name1");
        actual = (GeoServerTileLayerInfo)ModificationProxy.unwrap((Object)actual);
        DefaultTileLayerCatalogTest.assertEquals((Object)info, (Object)actual);
    }

    public void testDelete() {
        GeoServerTileLayerInfoImpl info = new GeoServerTileLayerInfoImpl();
        info.setId("id1");
        info.setName("name1");
        this.catalog.save((GeoServerTileLayerInfo)info);
        GeoServerTileLayerInfo actual = this.catalog.getLayerByName("name1");
        actual = (GeoServerTileLayerInfo)ModificationProxy.unwrap((Object)actual);
        DefaultTileLayerCatalogTest.assertEquals((Object)info, (Object)actual);
        GeoServerTileLayerInfo deleted = this.catalog.delete("id1");
        DefaultTileLayerCatalogTest.assertEquals((Object)info, (Object)ModificationProxy.unwrap((Object)deleted));
        DefaultTileLayerCatalogTest.assertNull((Object)this.catalog.getLayerById("id1"));
    }

    public void testSave() {
        GeoServerTileLayerInfoImpl info = new GeoServerTileLayerInfoImpl();
        info.setId("id1");
        info.setName("name1");
        info.getMimeFormats().add("image/png");
        info.getMimeFormats().add("image/jpeg");
        DefaultTileLayerCatalogTest.assertNull((Object)this.catalog.save((GeoServerTileLayerInfo)info));
        GeoServerTileLayerInfo original = this.catalog.getLayerById("id1");
        DefaultTileLayerCatalogTest.assertEquals((Object)info.getMimeFormats(), (Object)original.getMimeFormats());
        original.getMimeFormats().clear();
        original.getMimeFormats().add("image/gif");
        original.setName("name2");
        GeoServerTileLayerInfo oldValue = this.catalog.save(original);
        DefaultTileLayerCatalogTest.assertNotNull((Object)oldValue);
        DefaultTileLayerCatalogTest.assertEquals((Object)ImmutableSet.of((Object)"image/png", (Object)"image/jpeg"), (Object)oldValue.getMimeFormats());
        DefaultTileLayerCatalogTest.assertEquals((String)"name1", (String)oldValue.getName());
        DefaultTileLayerCatalogTest.assertNull((Object)this.catalog.getLayerByName("name1"));
        DefaultTileLayerCatalogTest.assertNotNull((Object)this.catalog.getLayerByName("name2"));
        GeoServerTileLayerInfo modified = this.catalog.getLayerById("id1");
        DefaultTileLayerCatalogTest.assertEquals((Object)ImmutableSet.of((Object)"image/gif"), (Object)modified.getMimeFormats());
    }
}

