/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.config;

import junit.framework.TestCase;
import org.geoserver.gwc.config.GWCConfig;

public class GWCConfigTest
extends TestCase {
    private GWCConfig oldDefaults;
    private GWCConfig config;

    protected void setUp() throws Exception {
        this.oldDefaults = GWCConfig.getOldDefaults();
        this.config = new GWCConfig();
    }

    public void testSaneConfig() {
        GWCConfigTest.assertTrue((boolean)this.config.isSane());
        GWCConfigTest.assertSame((Object)this.config, (Object)this.config.saneConfig());
        GWCConfigTest.assertTrue((boolean)this.oldDefaults.isSane());
        GWCConfigTest.assertSame((Object)this.oldDefaults, (Object)this.oldDefaults.saneConfig());
        this.config.setMetaTilingX(-1);
        GWCConfigTest.assertFalse((boolean)this.config.isSane());
        this.config = this.config.saneConfig();
        GWCConfigTest.assertTrue((boolean)this.config.isSane());
        this.config.setMetaTilingY(-1);
        GWCConfigTest.assertFalse((boolean)this.config.isSane());
        this.config = this.config.saneConfig();
        GWCConfigTest.assertTrue((boolean)this.config.isSane());
        this.config.setGutter(-1);
        GWCConfigTest.assertFalse((boolean)this.config.isSane());
        this.config = this.config.saneConfig();
        GWCConfigTest.assertTrue((boolean)this.config.isSane());
        this.config.getDefaultCachingGridSetIds().clear();
        GWCConfigTest.assertFalse((boolean)this.config.isSane());
        this.config = this.config.saneConfig();
        GWCConfigTest.assertTrue((boolean)this.config.isSane());
        this.config.getDefaultCoverageCacheFormats().clear();
        GWCConfigTest.assertFalse((boolean)this.config.isSane());
        this.config = this.config.saneConfig();
        GWCConfigTest.assertTrue((boolean)this.config.isSane());
        this.config.getDefaultOtherCacheFormats().clear();
        GWCConfigTest.assertFalse((boolean)this.config.isSane());
        this.config = this.config.saneConfig();
        GWCConfigTest.assertTrue((boolean)this.config.isSane());
        this.config.getDefaultVectorCacheFormats().clear();
        GWCConfigTest.assertFalse((boolean)this.config.isSane());
        this.config = this.config.saneConfig();
        GWCConfigTest.assertTrue((boolean)this.config.isSane());
    }

    public void testClone() {
        GWCConfig clone = this.config.clone();
        GWCConfigTest.assertEquals((Object)this.config, (Object)clone);
        GWCConfigTest.assertNotSame((Object)this.config.getDefaultCachingGridSetIds(), (Object)clone.getDefaultCachingGridSetIds());
        GWCConfigTest.assertNotSame((Object)this.config.getDefaultCoverageCacheFormats(), (Object)clone.getDefaultCoverageCacheFormats());
        GWCConfigTest.assertNotSame((Object)this.config.getDefaultOtherCacheFormats(), (Object)clone.getDefaultOtherCacheFormats());
        GWCConfigTest.assertNotSame((Object)this.config.getDefaultVectorCacheFormats(), (Object)clone.getDefaultVectorCacheFormats());
    }

    public void testIsServiceEnabled() {
        this.config.setWMSCEnabled(!this.config.isWMSCEnabled());
        this.config.setTMSEnabled(!this.config.isTMSEnabled());
        this.config.setWMTSEnabled(!this.config.isWMTSEnabled());
        GWCConfigTest.assertEquals((boolean)this.config.isEnabled("wms"), (boolean)this.config.isWMSCEnabled());
        GWCConfigTest.assertEquals((boolean)this.config.isEnabled("WMS"), (boolean)this.config.isWMSCEnabled());
        GWCConfigTest.assertEquals((boolean)this.config.isEnabled("wmts"), (boolean)this.config.isWMTSEnabled());
        GWCConfigTest.assertEquals((boolean)this.config.isEnabled("WMTS"), (boolean)this.config.isWMTSEnabled());
        GWCConfigTest.assertEquals((boolean)this.config.isEnabled("tms"), (boolean)this.config.isTMSEnabled());
        GWCConfigTest.assertEquals((boolean)this.config.isEnabled("TMS"), (boolean)this.config.isTMSEnabled());
        GWCConfigTest.assertTrue((boolean)this.config.isEnabled("anything else"));
    }
}

