/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.config;

import java.io.File;
import junit.framework.TestCase;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.config.GWCConfigPersister;
import org.geoserver.platform.GeoServerResourceLoader;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class GWCConfigPersisterTest
extends TestCase {
    private GeoServerResourceLoader resourceLoader;
    private GWCConfigPersister persister;

    protected void setUp() throws Exception {
        this.resourceLoader = (GeoServerResourceLoader)Mockito.mock(GeoServerResourceLoader.class);
        this.persister = new GWCConfigPersister(new XStreamPersisterFactory(), this.resourceLoader);
    }

    public void testPrecondition() throws Exception {
        Mockito.when((Object)this.resourceLoader.find((String)Matchers.eq((Object)"gwc-gs.xml"))).thenReturn(null);
        try {
            this.persister.getConfig();
            GWCConfigPersisterTest.fail((String)"Expected assertion error");
        }
        catch (RuntimeException e) {
            GWCConfigPersisterTest.assertTrue((boolean)e.getMessage().contains("gwc-gs.xml"));
        }
    }

    public void testSaveLoad() throws Exception {
        File baseDirectory = new File("target");
        baseDirectory.mkdirs();
        File configFile = new File(baseDirectory, "gwc-gs.xml");
        if (configFile.exists()) {
            GWCConfigPersisterTest.assertTrue((boolean)configFile.delete());
        }
        Mockito.when((Object)this.resourceLoader.getBaseDirectory()).thenReturn((Object)baseDirectory);
        Mockito.when((Object)this.resourceLoader.find((String)Matchers.eq((Object)"gwc-gs.xml"))).thenReturn((Object)configFile);
        GWCConfig config = GWCConfig.getOldDefaults();
        config.setCacheNonDefaultStyles(true);
        config.setDirectWMSIntegrationEnabled(true);
        this.persister.save(config);
        GWCConfigPersisterTest.assertSame((Object)config, (Object)this.persister.getConfig());
        this.persister = new GWCConfigPersister(new XStreamPersisterFactory(), this.resourceLoader);
        GWCConfigPersisterTest.assertEquals((Object)config, (Object)this.persister.getConfig());
        Mockito.when((Object)this.resourceLoader.find((String)Matchers.eq((Object)"gwc-gs.xml"))).thenReturn((Object)new File("shall_not_exist"));
        this.persister = new GWCConfigPersister(new XStreamPersisterFactory(), this.resourceLoader);
        GWCConfig expected = new GWCConfig();
        GWCConfig actual = this.persister.getConfig();
        GWCConfigPersisterTest.assertEquals((Object)expected, (Object)actual);
    }
}

