/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import com.google.common.collect.ImmutableSet;
import com.vividsolutions.jts.geom.Envelope;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import net.opengis.wfs.InsertElementType;
import net.opengis.wfs.TransactionResponseType;
import net.opengis.wfs.TransactionType;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.GWCTransactionListener;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionEventType;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GWCTransactionListenerTest
extends TestCase {
    private GWC mediator;
    private GWCTransactionListener listener;

    protected void setUp() throws Exception {
        this.mediator = (GWC)Mockito.mock(GWC.class);
        this.listener = new GWCTransactionListener(this.mediator);
    }

    public void testNoInteractionsInUnusedMethods() {
        TransactionType request = (TransactionType)Mockito.mock(TransactionType.class);
        TransactionType returned = this.listener.beforeTransaction(request);
        GWCTransactionListenerTest.assertSame((Object)request, (Object)returned);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{request, this.mediator});
        this.listener.beforeCommit(request);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{request, this.mediator});
    }

    public void testAfterTransactionUncommitted() {
        TransactionType request = (TransactionType)Mockito.mock(TransactionType.class);
        TransactionResponseType result = (TransactionResponseType)Mockito.mock(TransactionResponseType.class);
        boolean committed = false;
        this.listener.afterTransaction(request, result, committed);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{request, result, this.mediator});
    }

    public void testDataStoreChangeDoesNotPropagateExceptions() {
        TransactionEvent event = (TransactionEvent)Mockito.mock(TransactionEvent.class);
        Mockito.when((Object)event.getSource()).thenThrow(new Throwable[]{new RuntimeException("fake")});
        try {
            this.listener.dataStoreChange(event);
        }
        catch (RuntimeException e) {
            GWCTransactionListenerTest.fail((String)"Exception should have been eaten to prevent the transaction from failing due to a gwc integration error");
        }
    }

    public void testDataStoreChangeOfNoInterest() {
        TransactionEvent event = (TransactionEvent)Mockito.mock(TransactionEvent.class);
        Mockito.when((Object)event.getSource()).thenReturn(new Object());
        this.listener.dataStoreChange(event);
        ((TransactionEvent)Mockito.verify((Object)event, (VerificationMode)Mockito.times((int)1))).getLayerName();
        ((TransactionEvent)Mockito.verify((Object)event, (VerificationMode)Mockito.times((int)1))).getType();
        ((TransactionEvent)Mockito.verify((Object)event, (VerificationMode)Mockito.times((int)1))).getSource();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{event, this.mediator});
    }

    public void testDataStoreChangePostInsert() {
        InsertElementType insert = (InsertElementType)Mockito.mock(InsertElementType.class);
        TransactionEvent event = (TransactionEvent)Mockito.mock(TransactionEvent.class);
        QName layerName = new QName("testType");
        Mockito.when((Object)event.getLayerName()).thenReturn((Object)layerName);
        Mockito.when((Object)event.getSource()).thenReturn((Object)insert);
        Mockito.when((Object)event.getType()).thenReturn((Object)TransactionEventType.POST_INSERT);
        this.listener.dataStoreChange(event);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mediator});
    }

    public void testDataStoreChangeDoesNotAffectTileLayer() {
        InsertElementType insert = (InsertElementType)Mockito.mock(InsertElementType.class);
        TransactionEvent event = (TransactionEvent)Mockito.mock(TransactionEvent.class);
        QName layerName = new QName("testType");
        Mockito.when((Object)event.getLayerName()).thenReturn((Object)layerName);
        Mockito.when((Object)event.getSource()).thenReturn((Object)insert);
        Mockito.when((Object)event.getType()).thenReturn((Object)TransactionEventType.PRE_INSERT);
        Mockito.when((Object)this.mediator.getTileLayersByFeatureType((String)Matchers.eq((Object)layerName.getNamespaceURI()), (String)Matchers.eq((Object)layerName.getLocalPart()))).thenReturn((Object)Collections.EMPTY_SET);
        this.listener.dataStoreChange(event);
        ((GWC)Mockito.verify((Object)this.mediator, (VerificationMode)Mockito.times((int)1))).getTileLayersByFeatureType((String)Matchers.eq((Object)layerName.getNamespaceURI()), (String)Matchers.eq((Object)layerName.getLocalPart()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mediator});
    }

    public void testDataStoreChangeInsert() {
        HashMap<Object, Object> extendedProperties = new HashMap<Object, Object>();
        ReferencedEnvelope affectedBounds = new ReferencedEnvelope(-180.0, 0.0, 0.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.issueInsert(extendedProperties, affectedBounds);
        GWCTransactionListenerTest.assertTrue((boolean)extendedProperties.containsKey("GWC_TRANSACTION_INFO_PLACEHOLDER"));
        Map placeHolder = (Map)extendedProperties.get("GWC_TRANSACTION_INFO_PLACEHOLDER");
        GWCTransactionListenerTest.assertNotNull(placeHolder.get("theLayer"));
        GWCTransactionListenerTest.assertSame((Object)affectedBounds, ((List)placeHolder.get("theLayer")).get(0));
        GWCTransactionListenerTest.assertSame((Object)affectedBounds, ((List)placeHolder.get("theGroup")).get(0));
    }

    public void testAfterTransaction() throws Exception {
        HashMap<Object, Object> extendedProperties = new HashMap<Object, Object>();
        ReferencedEnvelope affectedBounds1 = new ReferencedEnvelope(-180.0, 0.0, 0.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ReferencedEnvelope affectedBounds2 = new ReferencedEnvelope(0.0, 180.0, 0.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.issueInsert(extendedProperties, affectedBounds1);
        this.issueInsert(extendedProperties, affectedBounds2);
        TransactionType request = (TransactionType)Mockito.mock(TransactionType.class);
        TransactionResponseType result = (TransactionResponseType)Mockito.mock(TransactionResponseType.class);
        Mockito.when((Object)request.getExtendedProperties()).thenReturn(extendedProperties);
        Mockito.when((Object)this.mediator.getDeclaredCrs(Matchers.anyString())).thenReturn((Object)DefaultGeographicCRS.WGS84);
        this.listener.afterTransaction(request, result, true);
        ReferencedEnvelope expectedEnv = new ReferencedEnvelope(affectedBounds1);
        expectedEnv.expandToInclude((Envelope)affectedBounds2);
        ((GWC)Mockito.verify((Object)this.mediator, (VerificationMode)Mockito.times((int)1))).truncate((String)Matchers.eq((Object)"theLayer"), (ReferencedEnvelope)Matchers.eq((Object)expectedEnv));
        ((GWC)Mockito.verify((Object)this.mediator, (VerificationMode)Mockito.times((int)1))).truncate((String)Matchers.eq((Object)"theGroup"), (ReferencedEnvelope)Matchers.eq((Object)expectedEnv));
    }

    private void issueInsert(Map<Object, Object> extendedProperties, ReferencedEnvelope affectedBounds) {
        TransactionType transaction = (TransactionType)Mockito.mock(TransactionType.class);
        Mockito.when((Object)transaction.getExtendedProperties()).thenReturn(extendedProperties);
        TransactionEvent event = (TransactionEvent)Mockito.mock(TransactionEvent.class);
        Mockito.when((Object)event.getRequest()).thenReturn((Object)transaction);
        QName layerName = new QName("testType");
        Mockito.when((Object)event.getLayerName()).thenReturn((Object)layerName);
        InsertElementType insert = (InsertElementType)Mockito.mock(InsertElementType.class);
        Mockito.when((Object)event.getSource()).thenReturn((Object)insert);
        Mockito.when((Object)event.getType()).thenReturn((Object)TransactionEventType.PRE_INSERT);
        Mockito.when((Object)this.mediator.getTileLayersByFeatureType((String)Matchers.eq((Object)layerName.getNamespaceURI()), (String)Matchers.eq((Object)layerName.getLocalPart()))).thenReturn((Object)ImmutableSet.of((Object)"theLayer", (Object)"theGroup"));
        SimpleFeatureCollection affectedFeatures = (SimpleFeatureCollection)Mockito.mock(SimpleFeatureCollection.class);
        Mockito.when((Object)affectedFeatures.getBounds()).thenReturn((Object)affectedBounds);
        Mockito.when((Object)event.getAffectedFeatures()).thenReturn((Object)affectedFeatures);
        this.listener.dataStoreChange(event);
    }
}

