/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.gwc.GWC;
import org.geoserver.test.GeoServerTestSupport;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.layer.TileLayerDispatcher;

public class GWCListenerIntegrationTest
extends GeoServerTestSupport {
    protected boolean useLegacyDataDirectory() {
        return false;
    }

    public void testRemoveLayerAfterReload() throws Exception {
        Catalog cat = this.getCatalog();
        TileLayerDispatcher tld = (TileLayerDispatcher)GeoWebCacheExtensions.bean(TileLayerDispatcher.class);
        LayerInfo li = cat.getLayerByName(super.getLayerId(MockData.MPOINTS));
        String layerName = GWC.tileLayerName((LayerInfo)li);
        GWCListenerIntegrationTest.assertNotNull((Object)tld.getTileLayer(layerName));
        this.getGeoServer().reload();
        cat.remove(li);
        try {
            tld.getTileLayer(layerName);
            GWCListenerIntegrationTest.fail((String)"Layer should not exist");
        }
        catch (GeoWebCacheException gwce) {
            // empty catch block
        }
    }
}

