/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geotools.util.logging.Logging;
import org.geowebcache.grid.GridSetBroker;

public class CatalogLayerEventListener
implements CatalogListener {
    private static Logger log = Logging.getLogger(CatalogLayerEventListener.class);
    private final GWC mediator;
    private static ThreadLocal<CatalogModifyEvent> PRE_MODIFY_EVENT = new ThreadLocal();
    private static ThreadLocal<GeoServerTileLayerInfo> PRE_MODIFY_TILELAYER = new ThreadLocal();

    public CatalogLayerEventListener(GWC mediator) {
        this.mediator = mediator;
    }

    public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
        CatalogInfo obj;
        GWCConfig config = this.mediator.getConfig();
        boolean sane = config.isSane();
        boolean cacheLayersByDefault = config.isCacheLayersByDefault();
        if (!cacheLayersByDefault) {
            return;
        }
        if (!sane) {
            log.info("Ignoring auto-creation of tile layer for " + event.getSource() + ": global gwc settings are not sane");
        }
        if ((obj = event.getSource()) instanceof LayerInfo) {
            log.finer("Handling add event: " + obj);
            LayerInfo layerInfo = (LayerInfo)obj;
            this.createTileLayer(layerInfo);
        } else if (obj instanceof LayerGroupInfo) {
            LayerGroupInfo lgi = (LayerGroupInfo)obj;
            this.createTileLayer(lgi);
        }
    }

    void createTileLayer(LayerInfo layerInfo) {
        GWCConfig defaults = this.mediator.getConfig();
        if (defaults.isSane() && defaults.isCacheLayersByDefault()) {
            GridSetBroker gridSetBroker = this.mediator.getGridSetBroker();
            GeoServerTileLayer tileLayer = new GeoServerTileLayer(layerInfo, defaults, gridSetBroker);
            this.mediator.add(tileLayer);
        }
    }

    public void createTileLayer(LayerGroupInfo lgi) {
        GWCConfig defaults = this.mediator.getConfig();
        GridSetBroker gridSetBroker = this.mediator.getGridSetBroker();
        GeoServerTileLayer tileLayer = new GeoServerTileLayer(lgi, defaults, gridSetBroker);
        this.mediator.add(tileLayer);
    }

    public void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
        CatalogInfo source = event.getSource();
        if (source instanceof LayerInfo || source instanceof LayerGroupInfo || source instanceof FeatureTypeInfo || source instanceof CoverageInfo || source instanceof WMSLayerInfo) {
            PRE_MODIFY_EVENT.set(event);
            if (this.mediator.hasTileLayer(source)) {
                try {
                    GeoServerTileLayer tileLayer = this.mediator.getTileLayer(source);
                    GeoServerTileLayerInfo tileLayerInfo = tileLayer.getInfo();
                    PRE_MODIFY_TILELAYER.set(tileLayerInfo);
                }
                catch (RuntimeException e) {
                    log.info("Ignoring misconfigured tile layer info for " + source);
                }
            }
        }
    }

    public void handlePostModifyEvent(CatalogPostModifyEvent event) throws CatalogException {
        CatalogInfo source = event.getSource();
        if (!(source instanceof LayerInfo || source instanceof LayerGroupInfo || source instanceof FeatureTypeInfo || source instanceof CoverageInfo || source instanceof WMSLayerInfo)) {
            return;
        }
        GeoServerTileLayerInfo tileLayerInfo = PRE_MODIFY_TILELAYER.get();
        PRE_MODIFY_TILELAYER.remove();
        CatalogModifyEvent preModifyEvent = PRE_MODIFY_EVENT.get();
        PRE_MODIFY_EVENT.remove();
        if (tileLayerInfo == null) {
            return;
        }
        if (preModifyEvent == null) {
            throw new IllegalStateException("PostModifyEvent called without having called handlePreModify first?");
        }
        List changedProperties = preModifyEvent.getPropertyNames();
        List oldValues = preModifyEvent.getOldValues();
        List newValues = preModifyEvent.getNewValues();
        log.finer("Handling modify event for " + source);
        if ((source instanceof FeatureTypeInfo || source instanceof CoverageInfo || source instanceof WMSLayerInfo || source instanceof LayerGroupInfo) && (changedProperties.contains("name") || changedProperties.contains("namespace") || changedProperties.contains("workspace"))) {
            this.handleRename(tileLayerInfo, source, changedProperties, oldValues, newValues);
        }
        if (source instanceof LayerInfo) {
            LayerInfo li = (LayerInfo)source;
            this.handleLayerInfoChange(changedProperties, oldValues, newValues, li, tileLayerInfo);
        } else if (source instanceof LayerGroupInfo) {
            LayerGroupInfo lgInfo = (LayerGroupInfo)source;
            this.handleLayerGroupInfoChange(changedProperties, oldValues, newValues, lgInfo, tileLayerInfo);
        }
    }

    private void handleLayerGroupInfoChange(List<String> changedProperties, List<Object> oldValues, List<Object> newValues, LayerGroupInfo lgInfo, GeoServerTileLayerInfo tileLayerInfo) {
        Preconditions.checkNotNull((Object)lgInfo);
        Preconditions.checkNotNull((Object)tileLayerInfo);
        String layerName = GWC.tileLayerName(lgInfo);
        boolean truncate = false;
        if (changedProperties.contains("layers")) {
            Object newLayers;
            int layersIndex = changedProperties.indexOf("layers");
            Object oldLayers = oldValues.get(layersIndex);
            boolean bl = truncate = !oldLayers.equals(newLayers = newValues.get(layersIndex));
        }
        if (!truncate && changedProperties.contains("styles")) {
            Object newStyles;
            int stylesIndex = changedProperties.indexOf("styles");
            Object oldStyles = oldValues.get(stylesIndex);
            boolean bl = truncate = !oldStyles.equals(newStyles = newValues.get(stylesIndex));
        }
        if (truncate) {
            log.info("Truncating TileLayer for layer group '" + layerName + "' due to a change in its layers or styles");
            this.mediator.truncate(layerName);
        }
    }

    private void handleLayerInfoChange(List<String> changedProperties, List<Object> oldValues, List<Object> newValues, LayerInfo li, GeoServerTileLayerInfo tileLayerInfo) {
        String defaultStyle;
        Preconditions.checkNotNull((Object)tileLayerInfo);
        String layerName = GWC.tileLayerName(li);
        boolean save = false;
        if (changedProperties.contains("defaultStyle")) {
            int propIndex = changedProperties.indexOf("defaultStyle");
            StyleInfo oldStyle = (StyleInfo)oldValues.get(propIndex);
            StyleInfo newStyle = (StyleInfo)newValues.get(propIndex);
            String oldStyleName = oldStyle.getName();
            if (!Objects.equal((Object)oldStyleName, (Object)(defaultStyle = newStyle.getName()))) {
                save = true;
                log.info("Truncating default style for layer " + layerName + ", as it changed from " + oldStyleName + " to " + defaultStyle);
                this.mediator.truncateByLayerAndStyle(layerName, oldStyleName);
            }
        } else {
            StyleInfo styleInfo = li.getDefaultStyle();
            String string = defaultStyle = styleInfo == null ? null : styleInfo.getName();
        }
        if (tileLayerInfo.isAutoCacheStyles()) {
            HashSet<String> styles = new HashSet<String>();
            for (StyleInfo s : li.getStyles()) {
                styles.add(s.getName());
            }
            ImmutableSet<String> cachedStyles = tileLayerInfo.cachedStyles();
            if (!((Object)styles).equals(cachedStyles)) {
                Sets.SetView notCachedAnyMore = Sets.difference(cachedStyles, styles);
                for (String oldCachedStyle : notCachedAnyMore) {
                    log.info("Truncating cached style " + oldCachedStyle + " of layer " + layerName + " as it's no longer one of the layer's styles");
                    this.mediator.truncateByLayerAndStyle(layerName, oldCachedStyle);
                }
                boolean createParamIfNotExists = true;
                TileLayerInfoUtil.updateStringParameterFilter(tileLayerInfo, "STYLES", true, defaultStyle, styles);
                save = true;
            }
        }
        if (save) {
            GridSetBroker gridSetBroker = this.mediator.getGridSetBroker();
            GeoServerTileLayer tileLayer = new GeoServerTileLayer(li, gridSetBroker, tileLayerInfo);
            this.mediator.save(tileLayer);
        }
    }

    private void handleRename(GeoServerTileLayerInfo tileLayerInfo, CatalogInfo source, List<String> changedProperties, List<Object> oldValues, List<Object> newValues) {
        String oldLayerName;
        String newLayerName;
        int nameIndex = changedProperties.indexOf("name");
        int namespaceIndex = changedProperties.indexOf("namespace");
        if (source instanceof ResourceInfo) {
            ResourceInfo resourceInfo = (ResourceInfo)source;
            NamespaceInfo currNamespace = resourceInfo.getNamespace();
            NamespaceInfo oldNamespace = namespaceIndex > -1 ? (NamespaceInfo)oldValues.get(namespaceIndex) : currNamespace;
            newLayerName = resourceInfo.prefixedName();
            oldLayerName = nameIndex > -1 ? (String)oldValues.get(nameIndex) : resourceInfo.getName();
            oldLayerName = oldNamespace.getPrefix() + ":" + oldLayerName;
        } else {
            oldLayerName = tileLayerInfo.getName();
            newLayerName = GWC.tileLayerName((LayerGroupInfo)source);
        }
        if (!oldLayerName.equals(newLayerName)) {
            GeoServerTileLayer modifiedTileLayer;
            tileLayerInfo.setName(newLayerName);
            GridSetBroker gridSetBroker = this.mediator.getGridSetBroker();
            GeoServerTileLayer oldTileLayer = (GeoServerTileLayer)this.mediator.getTileLayerByName(oldLayerName);
            Preconditions.checkState((null != oldTileLayer ? 1 : 0) != 0, (Object)("hanldeRename: old tile layer not found: '" + oldLayerName + "'. New name: '" + newLayerName + "'"));
            if (oldTileLayer.getLayerInfo() != null) {
                LayerInfo layerInfo = oldTileLayer.getLayerInfo();
                modifiedTileLayer = new GeoServerTileLayer(layerInfo, gridSetBroker, tileLayerInfo);
            } else {
                LayerGroupInfo layerGroup = oldTileLayer.getLayerGroupInfo();
                modifiedTileLayer = new GeoServerTileLayer(layerGroup, gridSetBroker, tileLayerInfo);
            }
            this.mediator.save(modifiedTileLayer);
        }
    }

    public void handleRemoveEvent(CatalogRemoveEvent event) throws CatalogException {
        CatalogInfo obj = event.getSource();
        if (!(obj instanceof LayerInfo) && !(obj instanceof LayerGroupInfo)) {
            return;
        }
        if (!this.mediator.hasTileLayer(obj)) {
            return;
        }
        String prefixedName = null;
        if (obj instanceof LayerGroupInfo) {
            LayerGroupInfo lgInfo = (LayerGroupInfo)obj;
            prefixedName = GWC.tileLayerName(lgInfo);
        } else if (obj instanceof LayerInfo) {
            LayerInfo layerInfo = (LayerInfo)obj;
            prefixedName = GWC.tileLayerName(layerInfo);
        }
        if (null != prefixedName) {
            this.mediator.removeTileLayers(Arrays.asList(prefixedName));
        }
    }

    public void reloaded() {
    }
}

