/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.config;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInitializer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.config.GWCConfigPersister;
import org.geoserver.gwc.layer.CatalogConfiguration;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.gwc.layer.LegacyTileLayerInfoLoader;
import org.geoserver.gwc.layer.TileLayerCatalog;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geoserver.wms.WMSInfo;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;

public class GWCInitializer
implements GeoServerInitializer {
    private static final Logger LOGGER = Logging.getLogger(GWCInitializer.class);
    static String WMS_INTEGRATION_ENABLED_KEY = "GWC_WMS_Integration";
    private final GWCConfigPersister configPersister;
    private final Catalog rawCatalog;
    private final TileLayerCatalog tileLayerCatalog;

    public GWCInitializer(GWCConfigPersister configPersister, Catalog rawCatalog, TileLayerCatalog tileLayerCatalog) {
        this.configPersister = configPersister;
        this.rawCatalog = rawCatalog;
        this.tileLayerCatalog = tileLayerCatalog;
    }

    public void initialize(GeoServer geoServer) throws Exception {
        GWCConfig config;
        Version version;
        LOGGER.info("Initializing GeoServer specific GWC configuration from gwc-gs.xml");
        Version currentVersion = new Version("1.0.0");
        File configFile = this.configPersister.findConfigFile();
        if (configFile == null) {
            LOGGER.fine("GWC's GeoServer specific configuration not found, creating with old defaults");
            GWCConfig oldDefaults = GWCConfig.getOldDefaults();
            oldDefaults.setVersion(currentVersion.toString());
            this.upgradeWMSIntegrationConfig(geoServer, oldDefaults);
            this.createDefaultTileLayerInfos(oldDefaults);
            this.configPersister.save(oldDefaults);
        }
        if (currentVersion.compareTo(version = new Version((config = this.configPersister.getConfig()).getVersion())) > 0) {
            this.moveTileLayerInfosToTileLayerCatalog();
            config.setVersion(currentVersion.toString());
            this.configPersister.save(config);
        }
        GWCConfig gwcConfig = this.configPersister.getConfig();
        Preconditions.checkNotNull((Object)gwcConfig);
    }

    private void moveTileLayerInfosToTileLayerCatalog() {
        MetadataMap metadata;
        GeoServerTileLayerInfoImpl tileLayerInfo;
        for (LayerInfo layer : this.rawCatalog.getLayers()) {
            if (!CatalogConfiguration.isLayerExposable(layer)) continue;
            try {
                tileLayerInfo = LegacyTileLayerInfoLoader.load(layer);
                if (tileLayerInfo == null) continue;
                this.tileLayerCatalog.save(tileLayerInfo);
                metadata = layer.getMetadata();
                LegacyTileLayerInfoLoader.clear(metadata);
                this.rawCatalog.save(layer);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Error migrating GWC Tile Layer settings for Layer '" + layer.getName() + "'", e);
            }
        }
        for (LayerInfo layer : this.rawCatalog.getLayerGroups()) {
            try {
                tileLayerInfo = LegacyTileLayerInfoLoader.load((LayerGroupInfo)layer);
                if (tileLayerInfo == null) continue;
                this.tileLayerCatalog.save(tileLayerInfo);
                metadata = layer.getMetadata();
                LegacyTileLayerInfoLoader.clear(metadata);
                this.rawCatalog.save((LayerGroupInfo)layer);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Error occurred saving default GWC Tile Layer settings for LayerGroup '" + GWC.tileLayerName((LayerGroupInfo)layer) + "'", e);
            }
        }
    }

    private void createDefaultTileLayerInfos(GWCConfig defaultSettings) {
        MetadataMap metadata;
        GeoServerTileLayerInfoImpl tileLayerInfo;
        Preconditions.checkArgument((boolean)defaultSettings.isSane());
        for (LayerInfo layer : this.rawCatalog.getLayers()) {
            if (!CatalogConfiguration.isLayerExposable(layer)) continue;
            try {
                tileLayerInfo = TileLayerInfoUtil.loadOrCreate(layer, defaultSettings);
                this.tileLayerCatalog.save(tileLayerInfo);
                metadata = layer.getMetadata();
                if (!metadata.containsKey((Object)"GWC.enabled")) continue;
                LegacyTileLayerInfoLoader.clear(metadata);
                this.rawCatalog.save(layer);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Error occurred saving default GWC Tile Layer settings for Layer '" + layer.getName() + "'", e);
            }
        }
        for (LayerInfo layer : this.rawCatalog.getLayerGroups()) {
            try {
                tileLayerInfo = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)layer, defaultSettings);
                this.tileLayerCatalog.save(tileLayerInfo);
                metadata = layer.getMetadata();
                if (!metadata.containsKey((Object)"GWC.enabled")) continue;
                LegacyTileLayerInfoLoader.clear(metadata);
                this.rawCatalog.save((LayerGroupInfo)layer);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Error occurred saving default GWC Tile Layer settings for LayerGroup '" + GWC.tileLayerName((LayerGroupInfo)layer) + "'", e);
            }
        }
    }

    private void upgradeWMSIntegrationConfig(GeoServer geoServer, GWCConfig gwcConfig) throws IOException {
        WMSInfo service = (WMSInfo)geoServer.getService(WMSInfo.class);
        if (service != null) {
            Boolean storedValue;
            MetadataMap metadata = service.getMetadata();
            if (service != null && metadata != null && (storedValue = (Boolean)metadata.get(WMS_INTEGRATION_ENABLED_KEY, Boolean.class)) != null) {
                boolean enabled = storedValue;
                gwcConfig.setDirectWMSIntegrationEnabled(enabled);
                metadata.remove((Object)WMS_INTEGRATION_ENABLED_KEY);
                geoServer.save((ServiceInfo)service);
            }
        }
    }
}

