/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpServletResponse;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.LayerGroupInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.LegacyTileLayerInfoLoader;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.TileObject;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoServerTileLayerTest
extends TestCase {
    private LayerInfoImpl layerInfo;
    private GeoServerTileLayer layerInfoTileLayer;
    private LayerGroupInfoImpl layerGroup;
    private GeoServerTileLayer layerGroupInfoTileLayer;
    private Catalog catalog;
    private GridSetBroker gridSetBroker;
    private GWCConfig defaults;
    private GWC mockGWC;

    public void tearDown() throws Exception {
        GWC.set(null);
    }

    public void setUp() throws Exception {
        this.mockGWC = (GWC)Mockito.mock(GWC.class);
        GWC.set((GWC)this.mockGWC);
        String layerInfoId = "mock-layer-info";
        NamespaceInfoImpl ns = new NamespaceInfoImpl();
        ns.setPrefix("test");
        ns.setURI("http://goserver.org/test");
        DataStoreInfoImpl storeInfo = new DataStoreInfoImpl(null);
        storeInfo.setId("mock-store-info");
        storeInfo.setEnabled(true);
        FeatureTypeInfoImpl resource = new FeatureTypeInfoImpl((Catalog)null);
        resource.setStore((StoreInfo)storeInfo);
        resource.setId("mock-resource-info");
        resource.setName("MockLayerInfoName");
        resource.setNamespace((NamespaceInfo)ns);
        resource.setTitle("Test resource title");
        resource.setAbstract("Test resource abstract");
        resource.setEnabled(true);
        resource.setDescription("Test resource description");
        resource.setLatLonBoundingBox(new ReferencedEnvelope(-180.0, -90.0, 0.0, 0.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        resource.setNativeBoundingBox(new ReferencedEnvelope(-180.0, -90.0, 0.0, 0.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        resource.setSRS("EPSG:4326");
        resource.setKeywords(Arrays.asList(new Keyword("kwd1"), new Keyword("kwd2")));
        this.layerInfo = new LayerInfoImpl();
        this.layerInfo.setId("mock-layer-info");
        this.layerInfo.setEnabled(true);
        this.layerInfo.setResource((ResourceInfo)resource);
        this.layerInfo.setName("MockLayerInfoName");
        this.layerInfo.setType(LayerInfo.Type.VECTOR);
        StyleInfoImpl defaultStyle = new StyleInfoImpl(null);
        defaultStyle.setName("default_style");
        this.layerInfo.setDefaultStyle((StyleInfo)defaultStyle);
        StyleInfoImpl alternateStyle1 = new StyleInfoImpl(null);
        alternateStyle1.setName("alternateStyle-1");
        StyleInfoImpl alternateStyle2 = new StyleInfoImpl(null);
        alternateStyle2.setName("alternateStyle-2");
        HashSet<StyleInfo> alternateStyles = new HashSet<StyleInfo>(Arrays.asList(alternateStyle1, alternateStyle2));
        this.layerInfo.setStyles(alternateStyles);
        this.layerGroup = new LayerGroupInfoImpl();
        String layerGroupId = "mock-layergroup-id";
        this.layerGroup.setId("mock-layergroup-id");
        this.layerGroup.setName("MockLayerGroup");
        this.layerGroup.setLayers(Collections.singletonList(this.layerInfo));
        this.defaults = GWCConfig.getOldDefaults();
        this.catalog = (Catalog)Mockito.mock(Catalog.class);
        Mockito.when((Object)this.catalog.getLayer((String)Matchers.eq((Object)"mock-layer-info"))).thenReturn((Object)this.layerInfo);
        Mockito.when((Object)this.catalog.getLayerGroup((String)Matchers.eq((Object)"mock-layergroup-id"))).thenReturn((Object)this.layerGroup);
        this.gridSetBroker = new GridSetBroker(true, true);
        this.gridSetBroker.put(this.gridSetBroker.WORLD_EPSG4326);
        this.gridSetBroker.put(this.gridSetBroker.WORLD_EPSG3857);
    }

    public void testEnabled() {
        this.layerInfo.setEnabled(true);
        this.layerInfoTileLayer = new GeoServerTileLayer((LayerInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        GeoServerTileLayerTest.assertTrue((boolean)this.layerInfoTileLayer.isEnabled());
        this.layerInfo.setEnabled(false);
        this.layerInfoTileLayer = new GeoServerTileLayer((LayerInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        GeoServerTileLayerTest.assertFalse((boolean)this.layerInfoTileLayer.isEnabled());
        this.layerInfo.setEnabled(true);
        this.layerInfoTileLayer.setEnabled(true);
        GeoServerTileLayerTest.assertTrue((boolean)this.layerInfoTileLayer.isEnabled());
        GeoServerTileLayerTest.assertTrue((boolean)this.layerInfoTileLayer.getInfo().isEnabled());
        this.layerInfoTileLayer.setConfigErrorMessage("fake error message");
        GeoServerTileLayerTest.assertFalse((boolean)this.layerInfoTileLayer.isEnabled());
        this.layerInfoTileLayer.setConfigErrorMessage(null);
        this.layerInfoTileLayer.setEnabled(false);
        GeoServerTileLayerTest.assertFalse((boolean)this.layerInfoTileLayer.isEnabled());
        GeoServerTileLayerTest.assertFalse((boolean)this.layerInfoTileLayer.getInfo().isEnabled());
        this.layerGroupInfoTileLayer = new GeoServerTileLayer((LayerGroupInfo)this.layerGroup, this.defaults, this.gridSetBroker);
        GeoServerTileLayerTest.assertTrue((boolean)this.layerGroupInfoTileLayer.isEnabled());
    }

    public void testGetMetaTilingFactors() {
        this.layerInfoTileLayer = new GeoServerTileLayer((LayerInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        int[] metaTilingFactors = this.layerInfoTileLayer.getMetaTilingFactors();
        GeoServerTileLayerTest.assertEquals((int)this.defaults.getMetaTilingX(), (int)metaTilingFactors[0]);
        GeoServerTileLayerTest.assertEquals((int)this.defaults.getMetaTilingY(), (int)metaTilingFactors[1]);
        GeoServerTileLayerInfo info = this.layerInfoTileLayer.getInfo();
        info.setMetaTilingX(1 + this.defaults.getMetaTilingX());
        info.setMetaTilingY(2 + this.defaults.getMetaTilingY());
        LegacyTileLayerInfoLoader.save((GeoServerTileLayerInfo)info, (MetadataMap)this.layerInfo.getMetadata());
        this.layerInfoTileLayer = new GeoServerTileLayer((LayerInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        metaTilingFactors = this.layerInfoTileLayer.getMetaTilingFactors();
        GeoServerTileLayerTest.assertEquals((int)(1 + this.defaults.getMetaTilingX()), (int)metaTilingFactors[0]);
        GeoServerTileLayerTest.assertEquals((int)(2 + this.defaults.getMetaTilingY()), (int)metaTilingFactors[1]);
    }

    public void testIsQueryable() {
        this.layerInfoTileLayer = new GeoServerTileLayer((LayerInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        Mockito.when((Object)this.mockGWC.isQueryable((GeoServerTileLayer)Matchers.same((Object)this.layerInfoTileLayer))).thenReturn((Object)true);
        GeoServerTileLayerTest.assertTrue((boolean)this.layerInfoTileLayer.isQueryable());
        Mockito.when((Object)this.mockGWC.isQueryable((GeoServerTileLayer)Matchers.same((Object)this.layerInfoTileLayer))).thenReturn((Object)false);
        GeoServerTileLayerTest.assertFalse((boolean)this.layerInfoTileLayer.isQueryable());
        ((GWC)Mockito.verify((Object)this.mockGWC, (VerificationMode)Mockito.times((int)2))).isQueryable((GeoServerTileLayer)Matchers.same((Object)this.layerInfoTileLayer));
    }

    public void testGetName() {
        this.layerInfoTileLayer = new GeoServerTileLayer((LayerInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        GeoServerTileLayerTest.assertEquals((String)GWC.tileLayerName((LayerInfo)this.layerInfo), (String)this.layerInfoTileLayer.getName());
        this.layerGroupInfoTileLayer = new GeoServerTileLayer((LayerGroupInfo)this.layerGroup, this.defaults, this.gridSetBroker);
        GeoServerTileLayerTest.assertEquals((String)GWC.tileLayerName((LayerGroupInfo)this.layerGroup), (String)this.layerGroupInfoTileLayer.getName());
    }

    public void testGetParameterFilters() {
        this.layerInfoTileLayer = new GeoServerTileLayer((LayerInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        List parameterFilters = this.layerInfoTileLayer.getParameterFilters();
        GeoServerTileLayerTest.assertNotNull((Object)parameterFilters);
        GeoServerTileLayerTest.assertEquals((int)1, (int)parameterFilters.size());
        GeoServerTileLayerTest.assertTrue((boolean)(parameterFilters.get(0) instanceof StringParameterFilter));
        StringParameterFilter styleFilter = (StringParameterFilter)parameterFilters.get(0);
        GeoServerTileLayerTest.assertEquals((String)"STYLES", (String)styleFilter.getKey());
        GeoServerTileLayerTest.assertEquals((String)"default_style", (String)styleFilter.getDefaultValue());
        GeoServerTileLayerTest.assertEquals(new HashSet<String>(Arrays.asList("alternateStyle-1", "alternateStyle-2")), new HashSet(styleFilter.getLegalValues()));
    }

    public void testGetDefaultParameterFilters() {
        this.layerInfoTileLayer = new GeoServerTileLayer((LayerInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        Map defaultFilters = this.layerInfoTileLayer.getDefaultParameterFilters();
        GeoServerTileLayerTest.assertEquals((int)1, (int)defaultFilters.size());
        GeoServerTileLayerTest.assertEquals((String)"default_style", (String)((String)defaultFilters.get("STYLES")));
    }

    public void testGetModifiableParameters() throws GeoWebCacheException {
        this.layerInfoTileLayer = new GeoServerTileLayer((LayerInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        ParameterFilter stylesParamFilter = (ParameterFilter)this.layerInfoTileLayer.getParameterFilters().get(0);
        List legalValues = stylesParamFilter.getLegalValues();
        Map<String, String> requestParams = Collections.singletonMap("sTyLeS", "");
        Map modifiedParams = this.layerInfoTileLayer.getModifiableParameters(requestParams, "UTF-8");
        GeoServerTileLayerTest.assertEquals((int)0, (int)modifiedParams.size());
        for (String legalStyle : legalValues) {
            requestParams = new HashMap<String, String>();
            requestParams.put("sTyLeS", legalStyle);
            modifiedParams = this.layerInfoTileLayer.getModifiableParameters(requestParams, "UTF-8");
            if (legalStyle.equals(stylesParamFilter.getDefaultValue())) {
                GeoServerTileLayerTest.assertEquals((int)0, (int)modifiedParams.size());
                continue;
            }
            GeoServerTileLayerTest.assertEquals(Collections.singletonMap("STYLES", legalStyle), (Object)modifiedParams);
        }
    }

    public void testGetMetaInformation() {
        this.layerInfoTileLayer = new GeoServerTileLayer((LayerInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        this.layerGroupInfoTileLayer = new GeoServerTileLayer((LayerGroupInfo)this.layerGroup, this.defaults, this.gridSetBroker);
        LayerMetaInformation metaInformation = this.layerInfoTileLayer.getMetaInformation();
        GeoServerTileLayerTest.assertNotNull((Object)metaInformation);
        String title = metaInformation.getTitle();
        String description = metaInformation.getDescription();
        List keywords = metaInformation.getKeywords();
        GeoServerTileLayerTest.assertEquals((String)this.layerInfo.getResource().getTitle(), (String)title);
        GeoServerTileLayerTest.assertEquals((String)this.layerInfo.getResource().getAbstract(), (String)description);
        GeoServerTileLayerTest.assertEquals((int)this.layerInfo.getResource().getKeywords().size(), (int)keywords.size());
        for (String kw : keywords) {
            GeoServerTileLayerTest.assertTrue((boolean)this.layerInfo.getResource().getKeywords().contains(new Keyword(kw)));
        }
        metaInformation = this.layerGroupInfoTileLayer.getMetaInformation();
        GeoServerTileLayerTest.assertNotNull((Object)metaInformation);
        title = metaInformation.getTitle();
        description = metaInformation.getDescription();
        keywords = metaInformation.getKeywords();
        GeoServerTileLayerTest.assertEquals((String)GWC.tileLayerName((LayerGroupInfo)this.layerGroup), (String)title);
        GeoServerTileLayerTest.assertEquals((String)"", (String)description);
        GeoServerTileLayerTest.assertEquals((int)0, (int)keywords.size());
    }

    public void testGetStyles() {
        this.layerInfoTileLayer = new GeoServerTileLayer((LayerInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        this.layerGroupInfoTileLayer = new GeoServerTileLayer((LayerGroupInfo)this.layerGroup, this.defaults, this.gridSetBroker);
        GeoServerTileLayerTest.assertEquals((String)"default_style", (String)this.layerInfoTileLayer.getStyles());
        GeoServerTileLayerTest.assertNull((Object)this.layerGroupInfoTileLayer.getStyles());
        StyleInfoImpl newDefaultStyle = new StyleInfoImpl(null);
        newDefaultStyle.setName("newDefault");
        this.layerInfo.setDefaultStyle((StyleInfo)newDefaultStyle);
        GeoServerTileLayerTest.assertEquals((String)"newDefault", (String)this.layerInfoTileLayer.getStyles());
    }

    public void testGetGridSubsets() throws Exception {
        this.layerInfoTileLayer = new GeoServerTileLayer((LayerInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        Set gridSubsets = this.layerInfoTileLayer.getGridSubsets();
        GeoServerTileLayerTest.assertNotNull((Object)gridSubsets);
        GeoServerTileLayerTest.assertEquals((int)2, (int)gridSubsets.size());
        Set subsets = this.layerInfoTileLayer.getInfo().getGridSubsets();
        subsets.clear();
        XMLGridSubset xmlGridSubset = new XMLGridSubset();
        xmlGridSubset.setGridSetName("EPSG:900913");
        subsets.add(xmlGridSubset);
        LegacyTileLayerInfoLoader.save((GeoServerTileLayerInfo)this.layerInfoTileLayer.getInfo(), (MetadataMap)this.layerInfo.getMetadata());
        this.layerInfoTileLayer = new GeoServerTileLayer((LayerInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        gridSubsets = this.layerInfoTileLayer.getGridSubsets();
        GeoServerTileLayerTest.assertNotNull((Object)gridSubsets);
        GeoServerTileLayerTest.assertEquals((int)1, (int)gridSubsets.size());
        this.layerGroup.setBounds(this.layerInfo.getResource().getLatLonBoundingBox());
        this.layerGroupInfoTileLayer = new GeoServerTileLayer((LayerGroupInfo)this.layerGroup, this.defaults, this.gridSetBroker);
        gridSubsets = this.layerGroupInfoTileLayer.getGridSubsets();
        GeoServerTileLayerTest.assertNotNull((Object)gridSubsets);
        GeoServerTileLayerTest.assertEquals((int)2, (int)gridSubsets.size());
    }

    public void testGridSubsetBoundsClippedToTargetCrsAreaOfValidity() throws Exception {
        CoordinateReferenceSystem nativeCrs = CRS.decode((String)"EPSG:4326", (boolean)true);
        ReferencedEnvelope nativeBounds = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, nativeCrs);
        this.layerGroup.setBounds(nativeBounds);
        this.defaults.getDefaultCachingGridSetIds().clear();
        this.defaults.getDefaultCachingGridSetIds().add("EPSG:900913");
        this.layerGroupInfoTileLayer = new GeoServerTileLayer((LayerGroupInfo)this.layerGroup, this.defaults, this.gridSetBroker);
        this.layerGroupInfoTileLayer.getGridSubsets();
        XMLGridSubset savedSubset = (XMLGridSubset)this.layerGroupInfoTileLayer.getInfo().getGridSubsets().iterator().next();
        BoundingBox gridSubsetExtent = savedSubset.getExtent();
        BoundingBox expected = this.gridSetBroker.WORLD_EPSG3857.getOriginalExtent();
        double threshold = 1.0E-16;
        GeoServerTileLayerTest.assertTrue((String)("Expected " + expected + ", got " + gridSubsetExtent), (boolean)expected.equals(gridSubsetExtent, threshold));
    }

    public void testGetFeatureInfo() throws Exception {
        this.layerInfoTileLayer = new GeoServerTileLayer((LayerInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        ConveyorTile convTile = new ConveyorTile(null, null, null, null);
        convTile.setTileLayer((TileLayer)this.layerInfoTileLayer);
        convTile.setMimeType(MimeType.createFromFormat((String)"image/png"));
        convTile.setGridSetId("EPSG:4326");
        convTile.servletReq = new MockHttpServletRequest();
        BoundingBox bbox = new BoundingBox(0.0, 0.0, 10.0, 10.0);
        Resource mockResult = (Resource)Mockito.mock(Resource.class);
        ArgumentCaptor argument = ArgumentCaptor.forClass(Map.class);
        Mockito.when((Object)this.mockGWC.dispatchOwsRequest((Map)argument.capture(), (Cookie[])Matchers.anyObject())).thenReturn((Object)mockResult);
        Resource result = this.layerInfoTileLayer.getFeatureInfo(convTile, bbox, 100, 100, 50, 50);
        GeoServerTileLayerTest.assertSame((Object)mockResult, (Object)result);
        Map capturedParams = (Map)argument.getValue();
        GeoServerTileLayerTest.assertEquals((String)"image/png", (String)((String)capturedParams.get("INFO_FORMAT")));
        GeoServerTileLayerTest.assertEquals((String)"0.0,0.0,10.0,10.0", (String)((String)capturedParams.get("BBOX")));
        GeoServerTileLayerTest.assertEquals((String)"test:MockLayerInfoName", (String)((String)capturedParams.get("QUERY_LAYERS")));
        GeoServerTileLayerTest.assertEquals((String)"WMS", (String)((String)capturedParams.get("SERVICE")));
        GeoServerTileLayerTest.assertEquals((String)"100", (String)((String)capturedParams.get("HEIGHT")));
        GeoServerTileLayerTest.assertEquals((String)"100", (String)((String)capturedParams.get("WIDTH")));
        GeoServerTileLayerTest.assertEquals((String)"GetFeatureInfo", (String)((String)capturedParams.get("REQUEST")));
        GeoServerTileLayerTest.assertEquals((String)"default_style", (String)((String)capturedParams.get("STYLES")));
        GeoServerTileLayerTest.assertEquals((String)"SE_XML", (String)((String)capturedParams.get("EXCEPTIONS")));
        GeoServerTileLayerTest.assertEquals((String)"1.1.1", (String)((String)capturedParams.get("VERSION")));
        GeoServerTileLayerTest.assertEquals((String)"image/png", (String)((String)capturedParams.get("FORMAT")));
        GeoServerTileLayerTest.assertEquals((String)"test:MockLayerInfoName", (String)((String)capturedParams.get("LAYERS")));
        GeoServerTileLayerTest.assertEquals((String)"EPSG:4326", (String)((String)capturedParams.get("SRS")));
        GeoServerTileLayerTest.assertEquals((String)"50", (String)((String)capturedParams.get("X")));
        GeoServerTileLayerTest.assertEquals((String)"50", (String)((String)capturedParams.get("Y")));
        ((GWC)Mockito.verify((Object)this.mockGWC, (VerificationMode)Mockito.times((int)1))).dispatchOwsRequest((Map)Matchers.anyObject(), (Cookie[])Matchers.anyObject());
        Mockito.when((Object)this.mockGWC.dispatchOwsRequest((Map)Matchers.anyObject(), (Cookie[])Matchers.anyObject())).thenThrow(new Throwable[]{new RuntimeException("mock exception")});
        try {
            this.layerInfoTileLayer.getFeatureInfo(convTile, bbox, 100, 100, 50, 50);
            GeoServerTileLayerTest.fail((String)"Expected GeoWebCacheException");
        }
        catch (GeoWebCacheException e) {
            GeoServerTileLayerTest.assertTrue((boolean)true);
        }
    }

    public void testGetTilePreconditions() throws Exception {
        long[][] outsideTiles;
        StorageBroker storageBroker = (StorageBroker)Mockito.mock(StorageBroker.class);
        this.layerInfoTileLayer = new GeoServerTileLayer((LayerInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        MockHttpServletRequest servletReq = new MockHttpServletRequest();
        MockHttpServletResponse servletResp = new MockHttpServletResponse();
        ConveyorTile tile = new ConveyorTile(storageBroker, this.layerInfoTileLayer.getName(), (HttpServletRequest)servletReq, (HttpServletResponse)servletResp);
        tile.setMimeType(MimeType.createFromFormat((String)"image/gif"));
        try {
            this.layerInfoTileLayer.getTile(tile);
            GeoServerTileLayerTest.fail((String)"Expected exception, requested mime is invalid for the layer");
        }
        catch (IllegalArgumentException e) {
            GeoServerTileLayerTest.assertTrue((boolean)e.getMessage().contains("is not a supported format"));
        }
        tile.setMimeType(MimeType.createFromFormat((String)"image/png"));
        tile.setGridSetId("EPSG:2003");
        try {
            this.layerInfoTileLayer.getTile(tile);
            GeoServerTileLayerTest.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            GeoServerTileLayerTest.assertTrue((boolean)e.getMessage().contains("gridset not found"));
        }
        for (long[] tileIndex : outsideTiles = new long[][]{{0L, 1L, 1L}, {1L, 1L, 1L}, {1L, 0L, 1L}}) {
            MimeType mimeType = MimeType.createFromFormat((String)"image/png");
            tile = new ConveyorTile(storageBroker, this.layerInfoTileLayer.getName(), "EPSG:900913", tileIndex, mimeType, null, (HttpServletRequest)servletReq, (HttpServletResponse)servletResp);
            try {
                this.layerInfoTileLayer.getTile(tile);
                GeoServerTileLayerTest.fail((String)"Expected outside coverage exception");
            }
            catch (OutsideCoverageException e) {
                GeoServerTileLayerTest.assertTrue((boolean)true);
            }
        }
    }

    public void testGetTile() throws Exception {
        Resource mockResult = (Resource)Mockito.mock(Resource.class);
        ArgumentCaptor argument = ArgumentCaptor.forClass(Map.class);
        Mockito.when((Object)this.mockGWC.dispatchOwsRequest((Map)argument.capture(), (Cookie[])Matchers.anyObject())).thenReturn((Object)mockResult);
        BufferedImage image = new BufferedImage(256, 256, 2);
        RenderedImageMap fakeDispatchedMap = new RenderedImageMap(new WMSMapContent(), (RenderedImage)image, "image/png");
        RenderedImageMapResponse fakeResponseEncoder = (RenderedImageMapResponse)Mockito.mock(RenderedImageMapResponse.class);
        MimeType mimeType = MimeType.createFromFormat((String)"image/png");
        Mockito.when((Object)this.mockGWC.getResponseEncoder((MimeType)Matchers.eq((Object)mimeType), (RenderedImageMap)Matchers.anyObject())).thenReturn((Object)fakeResponseEncoder);
        StorageBroker storageBroker = (StorageBroker)Mockito.mock(StorageBroker.class);
        Mockito.when((Object)storageBroker.get((TileObject)Matchers.anyObject())).thenReturn((Object)false);
        this.layerInfoTileLayer = new GeoServerTileLayer((LayerInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        MockHttpServletRequest servletReq = new MockHttpServletRequest();
        MockHttpServletResponse servletResp = new MockHttpServletResponse();
        long[] tileIndex = new long[]{0L, 0L, 0L};
        ConveyorTile tile = new ConveyorTile(storageBroker, this.layerInfoTileLayer.getName(), "EPSG:4326", tileIndex, mimeType, null, (HttpServletRequest)servletReq, (HttpServletResponse)servletResp);
        GeoServerTileLayer.WEB_MAP.set(fakeDispatchedMap);
        ConveyorTile returned = this.layerInfoTileLayer.getTile(tile);
        GeoServerTileLayerTest.assertNotNull((Object)returned);
        GeoServerTileLayerTest.assertNotNull((Object)returned.getBlob());
        GeoServerTileLayerTest.assertEquals((Object)Conveyor.CacheResult.MISS, (Object)returned.getCacheResult());
        GeoServerTileLayerTest.assertEquals((int)200, (int)returned.getStatus());
        ((StorageBroker)Mockito.verify((Object)storageBroker, (VerificationMode)Mockito.atLeastOnce())).get((TileObject)Matchers.anyObject());
        ((GWC)Mockito.verify((Object)this.mockGWC, (VerificationMode)Mockito.times((int)1))).getResponseEncoder((MimeType)Matchers.eq((Object)mimeType), (RenderedImageMap)Matchers.isA(RenderedImageMap.class));
    }

    public void testGetMimeTypes() throws Exception {
        this.layerInfoTileLayer = new GeoServerTileLayer((LayerInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        List mimeTypes = this.layerInfoTileLayer.getMimeTypes();
        GeoServerTileLayerTest.assertEquals((int)this.defaults.getDefaultOtherCacheFormats().size(), (int)mimeTypes.size());
        this.layerInfoTileLayer.getInfo().getMimeFormats().clear();
        this.layerInfoTileLayer.getInfo().getMimeFormats().add("image/gif");
        mimeTypes = this.layerInfoTileLayer.getMimeTypes();
        GeoServerTileLayerTest.assertEquals((int)1, (int)mimeTypes.size());
        GeoServerTileLayerTest.assertEquals((Object)MimeType.createFromFormat((String)"image/gif"), mimeTypes.get(0));
    }
}

