/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.thoughtworks.xstream.XStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.TestCase;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.gwc.GWCTestHelpers;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.GWCGeoServerConfigurationProvider;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.filter.parameters.FloatParameterFilter;
import org.geowebcache.filter.parameters.RegexParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.grid.BoundingBox;

public class GeoServerTileLayerInfoPersistenceTest
extends TestCase {
    private GeoServerTileLayerInfo info;
    private GWCConfig defaults;
    private GeoServerTileLayerInfo defaultVectorInfo;

    protected void setUp() throws Exception {
        this.info = new GeoServerTileLayerInfoImpl();
        this.defaults = GWCConfig.getOldDefaults();
        this.defaultVectorInfo = TileLayerInfoUtil.create((GWCConfig)this.defaults);
        this.defaultVectorInfo.getMimeFormats().clear();
        this.defaultVectorInfo.getMimeFormats().addAll(this.defaults.getDefaultVectorCacheFormats());
    }

    private void testMarshaling(GeoServerTileLayerInfo info) {
        XStream xstream = XMLConfiguration.getConfiguredXStream((XStream)new XStream(), null);
        xstream = new GWCGeoServerConfigurationProvider().getConfiguredXStream(xstream);
        String marshalled = xstream.toXML((Object)info);
        GeoServerTileLayerInfo unmarshalled = (GeoServerTileLayerInfo)xstream.fromXML((Reader)new StringReader(marshalled));
        GeoServerTileLayerInfoPersistenceTest.assertNotNull((Object)unmarshalled);
        GeoServerTileLayerInfoPersistenceTest.assertEquals((String)"enabled", (boolean)info.isEnabled(), (boolean)unmarshalled.isEnabled());
        GeoServerTileLayerInfoPersistenceTest.assertEquals((String)"autoCacheStyles", (boolean)info.isAutoCacheStyles(), (boolean)unmarshalled.isAutoCacheStyles());
        GeoServerTileLayerInfoPersistenceTest.assertEquals((String)"gutter", (int)info.getGutter(), (int)unmarshalled.getGutter());
        GeoServerTileLayerInfoPersistenceTest.assertEquals((String)"metaTilingX", (int)info.getMetaTilingX(), (int)unmarshalled.getMetaTilingX());
        GeoServerTileLayerInfoPersistenceTest.assertEquals((String)"metaTilingY", (int)info.getMetaTilingY(), (int)unmarshalled.getMetaTilingY());
        GeoServerTileLayerInfoPersistenceTest.assertEquals((String)"cachedStyles", (Object)info.cachedStyles(), (Object)unmarshalled.cachedStyles());
        GeoServerTileLayerInfoPersistenceTest.assertEquals((String)"gridSubsets", (Object)info.getGridSubsets(), (Object)unmarshalled.getGridSubsets());
        GeoServerTileLayerInfoPersistenceTest.assertEquals((String)"mimeFormats", (Object)info.getMimeFormats(), (Object)unmarshalled.getMimeFormats());
        this.assertCollection("parameterFilters", info.getParameterFilters(), unmarshalled.getParameterFilters());
        GeoServerTileLayerInfoPersistenceTest.assertEquals((String)"info", (Object)info, (Object)unmarshalled);
    }

    private void assertCollection(String message, Collection<?> c1, Collection<?> c2) {
        if (c1 == null && c2 != null) {
            GeoServerTileLayerInfoPersistenceTest.assertEquals((String)message, (int)0, (int)c2.size());
        } else if (c1 != null && c2 == null) {
            GeoServerTileLayerInfoPersistenceTest.assertEquals((String)message, (int)0, (int)c1.size());
        } else {
            GeoServerTileLayerInfoPersistenceTest.assertEquals((String)message, c1, c2);
        }
    }

    public void testMarshallingDefaults() {
        GWCConfig oldDefaults = GWCConfig.getOldDefaults();
        LayerInfoImpl layerInfo = GWCTestHelpers.mockLayer("testLayer", new String[0], LayerInfo.Type.RASTER);
        this.info = TileLayerInfoUtil.loadOrCreate((LayerInfo)layerInfo, (GWCConfig)oldDefaults);
        this.testMarshaling(this.info);
    }

    public void testMarshallingGridSubsets() {
        ArrayList<XMLGridSubset> subsets = new ArrayList<XMLGridSubset>();
        XMLGridSubset subset = new XMLGridSubset();
        subset.setGridSetName("EPSG:4326");
        subset.setZoomStart(Integer.valueOf(1));
        subset.setZoomStop(Integer.valueOf(10));
        subset.setExtent(new BoundingBox(0.0, 0.0, 180.0, 90.0));
        subsets.add(subset);
        subset = new XMLGridSubset();
        subset.setGridSetName("EPSG:900913");
        subsets.add(subset);
        subset = new XMLGridSubset();
        subset.setGridSetName("GlobalCRS84Scale");
        subset.setZoomStart(Integer.valueOf(4));
        subset.setExtent(new BoundingBox(-100.0, -40.0, 100.0, 40.0));
        subsets.add(subset);
        this.info.getGridSubsets().add(subsets.get(0));
        this.testMarshaling(this.info);
        this.info.getGridSubsets().clear();
        this.info.getGridSubsets().add(subsets.get(1));
        this.testMarshaling(this.info);
        this.info.getGridSubsets().clear();
        this.info.getGridSubsets().add(subsets.get(2));
        this.testMarshaling(this.info);
        this.info.getGridSubsets().addAll(subsets);
        this.testMarshaling(this.info);
    }

    public void testMarshallingParameterFilters() throws Exception {
        StringParameterFilter strParam = new StringParameterFilter();
        strParam.setKey("TIME");
        strParam.setDefaultValue("now");
        strParam.getValues().addAll(Arrays.asList("today", "yesterday", "tomorrow"));
        RegexParameterFilter regExParam = new RegexParameterFilter();
        regExParam.setKey("CQL_FILTER");
        regExParam.setDefaultValue("INCLUDE");
        regExParam.setRegex(".*");
        FloatParameterFilter floatParam = new FloatParameterFilter();
        floatParam.setKey("ENV");
        floatParam.setThreshold(Float.valueOf(1.0E-4f));
        floatParam.getValues().addAll(Arrays.asList(Float.valueOf(1.0f), Float.valueOf(1.5f), Float.valueOf(2.0f), Float.valueOf(2.5f)));
        this.info.getParameterFilters().clear();
        this.testMarshaling(this.info);
        this.info.getParameterFilters().clear();
        this.info.getParameterFilters().add(strParam);
        this.testMarshaling(this.info);
        this.info.getParameterFilters().clear();
        this.info.getParameterFilters().add(regExParam);
        this.testMarshaling(this.info);
        this.info.getParameterFilters().clear();
        this.info.getParameterFilters().add(floatParam);
        this.testMarshaling(this.info);
        this.info.getParameterFilters().clear();
        this.info.getParameterFilters().add(strParam);
        this.info.getParameterFilters().add(regExParam);
        this.info.getParameterFilters().add(floatParam);
        this.testMarshaling(this.info);
        StringParameterFilter strParam2 = new StringParameterFilter();
        strParam2.setKey("ELEVATION");
        strParam2.setDefaultValue("1");
        strParam2.getValues().addAll(Arrays.asList("1", "2", "3"));
        this.info.getParameterFilters().add(strParam2);
        this.testMarshaling(this.info);
    }
}

