/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.impl.CatalogModifyEventImpl;
import org.geoserver.catalog.event.impl.CatalogPostModifyEventImpl;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.CatalogStyleChangeListener;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CatalogStyleChangeListenerTest
extends TestCase {
    private final String STYLE_NAME = "highways";
    private String STYLE_NAME_MODIFIED = "highways_modified";
    private final String PREFIXED_RESOURCE_NAME = "mock:Layer";
    private GWC mockMediator;
    private ResourceInfo mockResourceInfo;
    private LayerInfo mockLayerInfo;
    private StyleInfo mockStyle;
    private GeoServerTileLayer mockTileLayer;
    private GeoServerTileLayerInfoImpl mockTileLayerInfo;
    private CatalogModifyEventImpl styleNameModifyEvent;
    private CatalogStyleChangeListener listener;

    protected void setUp() throws Exception {
        this.mockMediator = (GWC)Mockito.mock(GWC.class);
        this.mockStyle = (StyleInfo)Mockito.mock(StyleInfo.class);
        Mockito.when((Object)this.mockStyle.getName()).thenReturn((Object)"highways");
        this.mockResourceInfo = (ResourceInfo)Mockito.mock(FeatureTypeInfo.class);
        Mockito.when((Object)this.mockResourceInfo.prefixedName()).thenReturn((Object)"mock:Layer");
        this.mockLayerInfo = (LayerInfo)Mockito.mock(LayerInfo.class);
        Mockito.when((Object)this.mockLayerInfo.getResource()).thenReturn((Object)this.mockResourceInfo);
        this.mockTileLayer = (GeoServerTileLayer)Mockito.mock(GeoServerTileLayer.class);
        this.mockTileLayerInfo = (GeoServerTileLayerInfoImpl)Mockito.mock(GeoServerTileLayerInfoImpl.class);
        ImmutableSet empty = ImmutableSet.of();
        Mockito.when((Object)this.mockTileLayerInfo.cachedStyles()).thenReturn((Object)empty);
        Mockito.when((Object)this.mockTileLayer.getLayerInfo()).thenReturn((Object)this.mockLayerInfo);
        Mockito.when((Object)this.mockTileLayer.getInfo()).thenReturn((Object)this.mockTileLayerInfo);
        Mockito.when((Object)this.mockTileLayer.getName()).thenReturn((Object)"mock:Layer");
        Mockito.when((Object)this.mockMediator.getTileLayersForStyle((String)Matchers.eq((Object)"highways"))).thenReturn(Collections.singletonList(this.mockTileLayer));
        this.listener = new CatalogStyleChangeListener(this.mockMediator);
        this.styleNameModifyEvent = new CatalogModifyEventImpl();
        this.styleNameModifyEvent.setSource((CatalogInfo)this.mockStyle);
        this.styleNameModifyEvent.setPropertyNames(Arrays.asList("name"));
        this.styleNameModifyEvent.setOldValues(Arrays.asList("highways"));
        this.styleNameModifyEvent.setNewValues(Arrays.asList(this.STYLE_NAME_MODIFIED));
    }

    public void testIgnorableChange() throws Exception {
        this.styleNameModifyEvent.setPropertyNames(Arrays.asList("fileName"));
        this.listener.handleModifyEvent((CatalogModifyEvent)this.styleNameModifyEvent);
        this.styleNameModifyEvent.setPropertyNames(Arrays.asList("name"));
        this.styleNameModifyEvent.setOldValues(Arrays.asList("highways"));
        this.styleNameModifyEvent.setNewValues(Arrays.asList("highways"));
        this.listener.handleModifyEvent((CatalogModifyEvent)this.styleNameModifyEvent);
        this.styleNameModifyEvent.setSource((CatalogInfo)Mockito.mock(LayerInfo.class));
        this.listener.handleModifyEvent((CatalogModifyEvent)this.styleNameModifyEvent);
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.never())).truncateByLayerAndStyle(Matchers.anyString(), Matchers.anyString());
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.never())).save((GeoServerTileLayer)Matchers.anyObject());
        ((GeoServerTileLayer)Mockito.verify((Object)this.mockTileLayer, (VerificationMode)Mockito.never())).getInfo();
        ((GeoServerTileLayerInfoImpl)Mockito.verify((Object)this.mockTileLayerInfo, (VerificationMode)Mockito.never())).cachedStyles();
    }

    public void testRenameDefaultStyle() throws Exception {
        this.listener.handleModifyEvent((CatalogModifyEvent)this.styleNameModifyEvent);
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.never())).truncateByLayerAndStyle(Matchers.anyString(), Matchers.anyString());
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.never())).save((GeoServerTileLayer)Matchers.anyObject());
        ((GeoServerTileLayer)Mockito.verify((Object)this.mockTileLayer, (VerificationMode)Mockito.atLeastOnce())).getInfo();
        ((GeoServerTileLayerInfoImpl)Mockito.verify((Object)this.mockTileLayerInfo, (VerificationMode)Mockito.atLeastOnce())).cachedStyles();
    }

    public void testRenameAlternateStyle() throws Exception {
        HashSet params = new HashSet();
        Mockito.when((Object)this.mockTileLayerInfo.getParameterFilters()).thenReturn(params);
        TileLayerInfoUtil.setCachedStyles((GeoServerTileLayerInfo)this.mockTileLayerInfo, null, (Set)ImmutableSet.of((Object)"highways"));
        CatalogStyleChangeListenerTest.assertEquals((int)1, (int)params.size());
        ImmutableSet styles = ImmutableSet.of((Object)"highways");
        Mockito.when((Object)this.mockTileLayerInfo.cachedStyles()).thenReturn((Object)styles);
        this.listener.handleModifyEvent((CatalogModifyEvent)this.styleNameModifyEvent);
        CatalogStyleChangeListenerTest.assertEquals((int)1, (int)params.size());
        ParameterFilter updated = (ParameterFilter)params.iterator().next();
        CatalogStyleChangeListenerTest.assertTrue((boolean)(updated instanceof StringParameterFilter));
        CatalogStyleChangeListenerTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{this.STYLE_NAME_MODIFIED}), (Object)((StringParameterFilter)updated).getValues());
        ((GeoServerTileLayer)Mockito.verify((Object)this.mockTileLayer, (VerificationMode)Mockito.times((int)1))).resetParameterFilters();
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).truncateByLayerAndStyle((String)Matchers.eq((Object)"mock:Layer"), (String)Matchers.eq((Object)"highways"));
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).save((GeoServerTileLayer)Matchers.same((Object)this.mockTileLayer));
    }

    public void testLayerInfoDefaultOrAlternateStyleChanged() throws Exception {
        Mockito.when((Object)this.mockMediator.getLayerInfosFor((StyleInfo)Matchers.same((Object)this.mockStyle))).thenReturn(Collections.singleton(this.mockLayerInfo));
        Mockito.when((Object)this.mockMediator.getLayerGroupsFor((StyleInfo)Matchers.same((Object)this.mockStyle))).thenReturn((Object)Collections.EMPTY_LIST);
        CatalogPostModifyEventImpl postModifyEvent = new CatalogPostModifyEventImpl();
        postModifyEvent.setSource((CatalogInfo)this.mockStyle);
        this.listener.handlePostModifyEvent((CatalogPostModifyEvent)postModifyEvent);
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).truncateByLayerAndStyle((String)Matchers.eq((Object)"mock:Layer"), (String)Matchers.eq((Object)"highways"));
    }

    public void testLayerGroupInfoImplicitOrExplicitStyleChanged() throws Exception {
        LayerGroupInfo mockGroup = (LayerGroupInfo)Mockito.mock(LayerGroupInfo.class);
        Mockito.when((Object)GWC.tileLayerName((LayerGroupInfo)mockGroup)).thenReturn((Object)"mockGroup");
        Mockito.when((Object)this.mockMediator.getLayerInfosFor((StyleInfo)Matchers.same((Object)this.mockStyle))).thenReturn((Object)Collections.EMPTY_LIST);
        Mockito.when((Object)this.mockMediator.getLayerGroupsFor((StyleInfo)Matchers.same((Object)this.mockStyle))).thenReturn(Collections.singleton(mockGroup));
        CatalogPostModifyEventImpl postModifyEvent = new CatalogPostModifyEventImpl();
        postModifyEvent.setSource((CatalogInfo)this.mockStyle);
        this.listener.handlePostModifyEvent((CatalogPostModifyEvent)postModifyEvent);
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).truncate((String)Matchers.eq((Object)"mockGroup"));
    }
}

