/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.GWCTestHelpers;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.CatalogConfiguration;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.gwc.layer.TileLayerCatalog;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opengis.feature.type.FeatureType;

public class CatalogConfigurationTest
extends TestCase {
    private Catalog catalog;
    private TileLayerCatalog tileLayerCatalog;
    private GridSetBroker gridSetBroker;
    private CatalogConfiguration config;
    private LayerInfo layer1;
    private LayerInfo layer2;
    private LayerInfo layerWithNoTileLayer;
    private LayerGroupInfo group1;
    private LayerGroupInfo group2;
    private LayerGroupInfo groupWithNoTileLayer;
    private GeoServerTileLayerInfo layerInfo1;
    private GeoServerTileLayerInfo layerInfo2;
    private GeoServerTileLayerInfo groupInfo1;
    private GeoServerTileLayerInfo groupInfo2;
    private GWC mockMediator;
    private GWCConfig defaults;

    protected void setUp() throws Exception {
        this.defaults = GWCConfig.getOldDefaults();
        this.defaults.getDefaultVectorCacheFormats().clear();
        this.defaults.getDefaultVectorCacheFormats().add("image/png8");
        this.defaults.getDefaultOtherCacheFormats().clear();
        this.defaults.getDefaultOtherCacheFormats().add("image/jpeg");
        this.defaults.setCacheLayersByDefault(false);
        this.defaults.setCacheNonDefaultStyles(true);
        this.layer1 = GWCTestHelpers.mockLayer("layer1", new String[0], LayerInfo.Type.RASTER);
        this.layer2 = GWCTestHelpers.mockLayer("layer2", new String[0], LayerInfo.Type.RASTER);
        this.layerWithNoTileLayer = GWCTestHelpers.mockLayer("layerWithNoTileLayer", new String[0], LayerInfo.Type.RASTER);
        this.group1 = GWCTestHelpers.mockGroup("group1", this.layer1, this.layer2);
        this.group2 = GWCTestHelpers.mockGroup("group2", this.layer2, this.layer1);
        this.groupWithNoTileLayer = GWCTestHelpers.mockGroup("groupWithNoTileLayer", this.layerWithNoTileLayer, this.layer1, this.layer2);
        this.layerInfo1 = TileLayerInfoUtil.loadOrCreate((LayerInfo)this.layer1, (GWCConfig)this.defaults);
        this.layerInfo1.setMetaTilingX(1);
        this.layerInfo1.setMetaTilingY(1);
        this.layerInfo2 = TileLayerInfoUtil.loadOrCreate((LayerInfo)this.layer2, (GWCConfig)this.defaults);
        this.layerInfo2.setMetaTilingX(2);
        this.layerInfo2.setMetaTilingY(2);
        this.groupInfo1 = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)this.group1, (GWCConfig)this.defaults);
        this.groupInfo1.setMetaTilingX(3);
        this.groupInfo1.setMetaTilingY(3);
        this.groupInfo2 = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)this.group2, (GWCConfig)this.defaults);
        this.groupInfo2.setMetaTilingX(4);
        this.groupInfo2.setMetaTilingY(4);
        this.catalog = (Catalog)Mockito.mock(Catalog.class);
        Mockito.when((Object)this.catalog.getLayers()).thenReturn((Object)ImmutableList.of((Object)this.layer1, (Object)this.layerWithNoTileLayer, (Object)this.layer2));
        Mockito.when((Object)this.catalog.getLayer(this.layer1.getId())).thenReturn((Object)this.layer1);
        Mockito.when((Object)this.catalog.getLayer(this.layer2.getId())).thenReturn((Object)this.layer2);
        Mockito.when((Object)this.catalog.getLayerGroup(this.group1.getId())).thenReturn((Object)this.group1);
        Mockito.when((Object)this.catalog.getLayerGroup(this.group2.getId())).thenReturn((Object)this.group2);
        Mockito.when((Object)this.catalog.getLayerGroups()).thenReturn((Object)ImmutableList.of((Object)this.group1, (Object)this.groupWithNoTileLayer, (Object)this.group2));
        Mockito.when((Object)this.catalog.getLayerByName((String)Matchers.eq((Object)GWC.tileLayerName((LayerInfo)this.layer1)))).thenReturn((Object)this.layer1);
        Mockito.when((Object)this.catalog.getLayerByName((String)Matchers.eq((Object)GWC.tileLayerName((LayerInfo)this.layer2)))).thenReturn((Object)this.layer2);
        Mockito.when((Object)this.catalog.getLayerByName((String)Matchers.eq((Object)GWC.tileLayerName((LayerInfo)this.layerWithNoTileLayer)))).thenReturn((Object)this.layerWithNoTileLayer);
        Mockito.when((Object)this.catalog.getLayerGroupByName((String)Matchers.eq((Object)GWC.tileLayerName((LayerGroupInfo)this.group1)))).thenReturn((Object)this.group1);
        Mockito.when((Object)this.catalog.getLayerGroupByName((String)Matchers.eq((Object)GWC.tileLayerName((LayerGroupInfo)this.group2)))).thenReturn((Object)this.group2);
        Mockito.when((Object)this.catalog.getLayerGroupByName((String)Matchers.eq((Object)GWC.tileLayerName((LayerGroupInfo)this.groupWithNoTileLayer)))).thenReturn((Object)this.groupWithNoTileLayer);
        this.gridSetBroker = new GridSetBroker(true, true);
        ImmutableSet layerNames = ImmutableSet.of((Object)GWC.tileLayerName((LayerInfo)this.layer1), (Object)GWC.tileLayerName((LayerInfo)this.layer2), (Object)GWC.tileLayerName((LayerGroupInfo)this.group1), (Object)GWC.tileLayerName((LayerGroupInfo)this.group2));
        this.tileLayerCatalog = (TileLayerCatalog)Mockito.mock(TileLayerCatalog.class);
        Mockito.when((Object)this.tileLayerCatalog.getLayerIds()).thenReturn((Object)ImmutableSet.of((Object)this.layer1.getId(), (Object)this.layer2.getId(), (Object)this.group1.getId(), (Object)this.group2.getId()));
        Mockito.when((Object)this.tileLayerCatalog.getLayerNames()).thenReturn((Object)layerNames);
        Mockito.when((Object)this.tileLayerCatalog.getLayerById(this.layer1.getId())).thenReturn((Object)this.layerInfo1);
        Mockito.when((Object)this.tileLayerCatalog.getLayerById(this.layer2.getId())).thenReturn((Object)this.layerInfo2);
        Mockito.when((Object)this.tileLayerCatalog.getLayerById(this.group1.getId())).thenReturn((Object)this.groupInfo1);
        Mockito.when((Object)this.tileLayerCatalog.getLayerById(this.group2.getId())).thenReturn((Object)this.groupInfo2);
        Mockito.when((Object)this.tileLayerCatalog.exists(this.layer1.getId())).thenReturn((Object)true);
        Mockito.when((Object)this.tileLayerCatalog.exists(this.layer2.getId())).thenReturn((Object)true);
        Mockito.when((Object)this.tileLayerCatalog.exists(this.group1.getId())).thenReturn((Object)true);
        Mockito.when((Object)this.tileLayerCatalog.exists(this.group2.getId())).thenReturn((Object)true);
        Mockito.when((Object)this.tileLayerCatalog.getLayerByName(GWC.tileLayerName((LayerInfo)this.layer1))).thenReturn((Object)this.layerInfo1);
        Mockito.when((Object)this.tileLayerCatalog.getLayerByName(GWC.tileLayerName((LayerInfo)this.layer2))).thenReturn((Object)this.layerInfo2);
        Mockito.when((Object)this.tileLayerCatalog.getLayerByName(GWC.tileLayerName((LayerGroupInfo)this.group1))).thenReturn((Object)this.groupInfo1);
        Mockito.when((Object)this.tileLayerCatalog.getLayerByName(GWC.tileLayerName((LayerGroupInfo)this.group2))).thenReturn((Object)this.groupInfo2);
        Mockito.when((Object)this.tileLayerCatalog.getLayerId(GWC.tileLayerName((LayerInfo)this.layer1))).thenReturn((Object)this.layer1.getId());
        Mockito.when((Object)this.tileLayerCatalog.getLayerId(GWC.tileLayerName((LayerInfo)this.layer2))).thenReturn((Object)this.layer2.getId());
        Mockito.when((Object)this.tileLayerCatalog.getLayerId(GWC.tileLayerName((LayerGroupInfo)this.group1))).thenReturn((Object)this.group1.getId());
        Mockito.when((Object)this.tileLayerCatalog.getLayerId(GWC.tileLayerName((LayerGroupInfo)this.group2))).thenReturn((Object)this.group2.getId());
        this.config = new CatalogConfiguration(this.catalog, this.tileLayerCatalog, this.gridSetBroker);
        this.mockMediator = (GWC)Mockito.mock(GWC.class);
        GWC.set((GWC)this.mockMediator);
        Mockito.when((Object)this.mockMediator.getConfig()).thenReturn((Object)this.defaults);
    }

    protected void tearDown() {
        GWC.set(null);
    }

    public void testGoofyMethods() {
        CatalogConfigurationTest.assertEquals((String)"GeoServer Catalog Configuration", (String)this.config.getIdentifier());
        CatalogConfigurationTest.assertNull((Object)this.config.getServiceInformation());
        CatalogConfigurationTest.assertTrue((boolean)this.config.isRuntimeStatsEnabled());
    }

    public void testInitialize() {
        CatalogConfigurationTest.assertEquals((int)4, (int)this.config.initialize(this.gridSetBroker));
    }

    public void testGetTileLayerCount() {
        CatalogConfigurationTest.assertEquals((int)4, (int)this.config.getTileLayerCount());
    }

    public void testGetTileLayerNames() {
        ImmutableSet expected = ImmutableSet.of((Object)GWC.tileLayerName((LayerInfo)this.layer1), (Object)GWC.tileLayerName((LayerInfo)this.layer2), (Object)GWC.tileLayerName((LayerGroupInfo)this.group1), (Object)GWC.tileLayerName((LayerGroupInfo)this.group2));
        Set actual = this.config.getTileLayerNames();
        CatalogConfigurationTest.assertEquals((Object)expected, (Object)actual);
    }

    public void testGetLayers() {
        Iterable layers = this.config.getLayers();
        this.testGetLayers(layers);
    }

    public void testDeprecatedGetTileLayers() {
        List layers = this.config.getTileLayers();
        this.testGetLayers(layers);
    }

    private void testGetLayers(Iterable<GeoServerTileLayer> layers) {
        CatalogConfigurationTest.assertEquals((int)3, (int)this.catalog.getLayers().size());
        CatalogConfigurationTest.assertEquals((int)3, (int)this.catalog.getLayerGroups().size());
        CatalogConfigurationTest.assertEquals((int)4, (int)Iterables.size(layers));
        ImmutableSet expected = ImmutableSet.of((Object)this.layerInfo1, (Object)this.layerInfo2, (Object)this.groupInfo1, (Object)this.groupInfo2);
        HashSet<GeoServerTileLayerInfo> actual = new HashSet<GeoServerTileLayerInfo>();
        for (GeoServerTileLayer layer : layers) {
            actual.add(layer.getInfo());
        }
        CatalogConfigurationTest.assertEquals((int)4, (int)actual.size());
        CatalogConfigurationTest.assertEquals((Object)expected, actual);
    }

    public void testGetTileLayer() {
        String layerName = GWC.tileLayerName((LayerInfo)this.layerWithNoTileLayer);
        CatalogConfigurationTest.assertNull((Object)this.config.getTileLayer(layerName));
        CatalogConfigurationTest.assertNull((Object)this.config.getTileLayer(GWC.tileLayerName((LayerGroupInfo)this.groupWithNoTileLayer)));
        CatalogConfigurationTest.assertNotNull((Object)this.config.getTileLayer(GWC.tileLayerName((LayerInfo)this.layer1)));
        CatalogConfigurationTest.assertNotNull((Object)this.config.getTileLayer(GWC.tileLayerName((LayerInfo)this.layer2)));
        CatalogConfigurationTest.assertNotNull((Object)this.config.getTileLayer(GWC.tileLayerName((LayerGroupInfo)this.group1)));
        CatalogConfigurationTest.assertNotNull((Object)this.config.getTileLayer(GWC.tileLayerName((LayerGroupInfo)this.group2)));
        CatalogConfigurationTest.assertNull((Object)this.config.getTileLayer("anythingElse"));
    }

    public void testModifyLayer() {
        try {
            this.config.modifyLayer(null);
            CatalogConfigurationTest.fail((String)"expected precondition exception");
        }
        catch (RuntimeException e) {
            CatalogConfigurationTest.assertTrue((boolean)e.getMessage().contains("is null"));
        }
        try {
            this.config.modifyLayer((TileLayer)Mockito.mock(TileLayer.class));
            CatalogConfigurationTest.fail((String)"expected precondition exception");
        }
        catch (RuntimeException e) {
            CatalogConfigurationTest.assertTrue((boolean)e.getMessage().contains("Can't save TileLayer of type"));
        }
        GeoServerTileLayer tileLayer1 = this.config.getTileLayer(GWC.tileLayerName((LayerInfo)this.layer1));
        GeoServerTileLayer tileLayer2 = this.config.getTileLayer(GWC.tileLayerName((LayerGroupInfo)this.group1));
        this.testModifyLayer(tileLayer1);
        this.testModifyLayer(tileLayer2);
    }

    private void testModifyLayer(GeoServerTileLayer orig) {
        GeoServerTileLayerInfoImpl newState = TileLayerInfoUtil.create((GWCConfig)this.defaults);
        newState.setId(orig.getInfo().getId());
        newState.setName(orig.getInfo().getName());
        CatalogConfigurationTest.assertFalse((boolean)orig.equals(newState));
        GeoServerTileLayer modified = orig.getLayerInfo() != null ? new GeoServerTileLayer(orig.getLayerInfo(), this.gridSetBroker, (GeoServerTileLayerInfo)newState) : new GeoServerTileLayer(orig.getLayerGroupInfo(), this.gridSetBroker, (GeoServerTileLayerInfo)newState);
        CatalogConfigurationTest.assertEquals((Object)orig.getInfo(), (Object)this.config.getTileLayer(orig.getName()).getInfo());
        this.config.modifyLayer((TileLayer)modified);
        CatalogConfigurationTest.assertEquals((Object)newState, (Object)this.config.getTileLayer(orig.getName()).getInfo());
        String origName = orig.getName();
        modified.getInfo().setName("changed");
        this.config.modifyLayer((TileLayer)modified);
        CatalogConfigurationTest.assertNull((Object)this.config.getTileLayer(origName));
        CatalogConfigurationTest.assertFalse((boolean)this.config.getTileLayerNames().contains(origName));
    }

    public void testRemoveLayer() {
        try {
            this.config.removeLayer(null);
            CatalogConfigurationTest.fail((String)"expected precondition violation exception");
        }
        catch (RuntimeException e) {
            CatalogConfigurationTest.assertTrue((boolean)true);
        }
        CatalogConfigurationTest.assertFalse((boolean)this.config.removeLayer(GWC.tileLayerName((LayerInfo)this.layerWithNoTileLayer)));
        CatalogConfigurationTest.assertFalse((boolean)this.config.removeLayer(GWC.tileLayerName((LayerGroupInfo)this.groupWithNoTileLayer)));
        String layerName = GWC.tileLayerName((LayerInfo)this.layer1);
        CatalogConfigurationTest.assertNotNull((Object)this.config.getTileLayer(layerName));
        int initialCount = this.config.getTileLayerCount();
        CatalogConfigurationTest.assertTrue((boolean)this.config.removeLayer(layerName));
        CatalogConfigurationTest.assertNull((Object)this.config.getTileLayer(layerName));
        CatalogConfigurationTest.assertFalse((boolean)this.config.getTileLayerNames().contains(layerName));
        CatalogConfigurationTest.assertEquals((int)(initialCount - 1), (int)this.config.getTileLayerCount());
        layerName = GWC.tileLayerName((LayerGroupInfo)this.group1);
        CatalogConfigurationTest.assertNotNull((Object)this.config.getTileLayer(layerName));
        CatalogConfigurationTest.assertTrue((boolean)this.config.removeLayer(layerName));
        CatalogConfigurationTest.assertNull((Object)this.config.getTileLayer(layerName));
        CatalogConfigurationTest.assertEquals((int)(initialCount - 2), (int)this.config.getTileLayerCount());
    }

    public void testSaveRename() {
        GeoServerTileLayerInfo originalState = this.layerInfo1;
        GeoServerTileLayerInfoImpl forceState1 = TileLayerInfoUtil.loadOrCreate((LayerInfo)this.layer1, (GWCConfig)this.defaults);
        Mockito.when((Object)this.tileLayerCatalog.save((GeoServerTileLayerInfo)Matchers.same((Object)forceState1))).thenReturn((Object)originalState);
        forceState1.setName("newName");
        this.config.modifyLayer((TileLayer)new GeoServerTileLayer(this.layer1, this.gridSetBroker, (GeoServerTileLayerInfo)forceState1));
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.never())).layerRemoved(Matchers.anyString());
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.never())).layerRenamed(Matchers.anyString(), Matchers.anyString());
        this.config.save();
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).save((GeoServerTileLayerInfo)Matchers.same((Object)forceState1));
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).layerRenamed((String)Matchers.eq((Object)this.layerInfo1.getName()), (String)Matchers.eq((Object)"newName"));
    }

    public void testSave() {
        Mockito.when((Object)this.tileLayerCatalog.delete((String)Matchers.eq((Object)this.layerInfo2.getId()))).thenReturn((Object)this.layerInfo2);
        CatalogConfigurationTest.assertTrue((boolean)this.config.removeLayer(this.layerInfo2.getName()));
        Mockito.when((Object)this.tileLayerCatalog.delete((String)Matchers.eq((Object)this.groupInfo1.getId()))).thenReturn((Object)this.groupInfo1);
        CatalogConfigurationTest.assertTrue((boolean)this.config.removeLayer(this.groupInfo1.getName()));
        ((TileLayerCatalog)Mockito.doThrow((Throwable)new IllegalArgumentException("failedDelete")).when((Object)this.tileLayerCatalog)).delete((String)Matchers.eq((Object)this.group1.getId()));
        GeoServerTileLayerInfoImpl forceState1 = TileLayerInfoUtil.loadOrCreate((LayerInfo)this.layer1, (GWCConfig)this.defaults);
        forceState1.setName("newName");
        GeoServerTileLayerInfoImpl forceState2 = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)this.group2, (GWCConfig)this.defaults);
        Mockito.when((Object)this.tileLayerCatalog.save((GeoServerTileLayerInfo)Matchers.same((Object)forceState1))).thenReturn((Object)this.layerInfo1);
        this.config.modifyLayer((TileLayer)new GeoServerTileLayer(this.layer1, this.gridSetBroker, (GeoServerTileLayerInfo)forceState1));
        this.config.modifyLayer((TileLayer)new GeoServerTileLayer(this.group2, this.gridSetBroker, (GeoServerTileLayerInfo)forceState2));
        ((TileLayerCatalog)Mockito.doThrow((Throwable)new IllegalArgumentException("failedSave")).when((Object)this.tileLayerCatalog)).save((GeoServerTileLayerInfo)Matchers.eq((Object)forceState2));
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.never())).layerRemoved(Matchers.anyString());
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.never())).layerRenamed(Matchers.anyString(), Matchers.anyString());
        GeoServerTileLayerInfoImpl addedState1 = TileLayerInfoUtil.loadOrCreate((LayerInfo)this.layerWithNoTileLayer, (GWCConfig)this.defaults);
        this.config.addLayer((TileLayer)new GeoServerTileLayer(this.layerWithNoTileLayer, this.gridSetBroker, (GeoServerTileLayerInfo)addedState1));
        ((GWC)Mockito.doThrow((Throwable)new IllegalArgumentException("callback exception")).when((Object)this.mockMediator)).layerAdded((String)Matchers.eq((Object)addedState1.getName()));
        GeoServerTileLayerInfoImpl addedState2 = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)this.groupWithNoTileLayer, (GWCConfig)this.defaults);
        this.config.addLayer((TileLayer)new GeoServerTileLayer(this.groupWithNoTileLayer, this.gridSetBroker, (GeoServerTileLayerInfo)addedState2));
        this.config.save();
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).delete((String)Matchers.eq((Object)this.group1.getId()));
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).delete((String)Matchers.eq((Object)this.layer2.getId()));
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).save((GeoServerTileLayerInfo)Matchers.same((Object)forceState1));
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).save((GeoServerTileLayerInfo)Matchers.same((Object)forceState2));
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).save((GeoServerTileLayerInfo)Matchers.same((Object)addedState1));
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).save((GeoServerTileLayerInfo)Matchers.same((Object)addedState2));
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).layerRemoved((String)Matchers.eq((Object)this.layerInfo2.getName()));
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).layerRenamed((String)Matchers.eq((Object)this.layerInfo1.getName()), (String)Matchers.eq((Object)"newName"));
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).layerAdded((String)Matchers.eq((Object)addedState1.getName()));
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).layerAdded((String)Matchers.eq((Object)addedState2.getName()));
    }

    public void testNoGeometry() throws Exception {
        FeatureType featureTypeWithNoGeometry = (FeatureType)Mockito.mock(FeatureType.class);
        Mockito.when((Object)featureTypeWithNoGeometry.getGeometryDescriptor()).thenReturn(null);
        FeatureTypeInfo resourceWithNoGeometry = (FeatureTypeInfo)Mockito.mock(FeatureTypeInfo.class);
        Mockito.when((Object)resourceWithNoGeometry.getFeatureType()).thenReturn((Object)featureTypeWithNoGeometry);
        LayerInfoImpl layerWithNoGeometry = GWCTestHelpers.mockLayer("layerWithNoGeometry", new String[0], LayerInfo.Type.VECTOR);
        layerWithNoGeometry.setResource((ResourceInfo)resourceWithNoGeometry);
        GeoServerTileLayer tl = (GeoServerTileLayer)Mockito.mock(GeoServerTileLayer.class);
        GeoServerTileLayerInfoImpl info = new GeoServerTileLayerInfoImpl();
        info.setId("layerWithNoGeometry");
        info.setName("layerWithNoGeometry");
        Mockito.when((Object)tl.getId()).thenReturn((Object)"layerWithNoGeometry");
        Mockito.when((Object)tl.getInfo()).thenReturn((Object)info);
        Mockito.when((Object)tl.getLayerInfo()).thenReturn((Object)layerWithNoGeometry);
        Mockito.when((Object)this.catalog.getLayer(layerWithNoGeometry.getId())).thenReturn((Object)layerWithNoGeometry);
        Mockito.when((Object)this.catalog.getLayerByName((String)Matchers.eq((Object)GWC.tileLayerName((LayerInfo)layerWithNoGeometry)))).thenReturn((Object)layerWithNoGeometry);
        this.config.addLayer((TileLayer)tl);
        this.config.save();
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.never())).save((GeoServerTileLayerInfo)info);
    }
}

