/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import junit.framework.TestCase;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.impl.LayerGroupInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.gwc.GWCTestHelpers;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.config.GWCConfigPersister;
import org.geoserver.gwc.config.GWCInitializer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.gwc.layer.LegacyTileLayerInfoLoader;
import org.geoserver.gwc.layer.TileLayerCatalog;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSInfoImpl;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class GWCInitializerTest
extends TestCase {
    private GWCInitializer initializer;
    private GWCConfigPersister configPersister;
    private GeoServer geoServer;
    private Catalog rawCatalog;
    private TileLayerCatalog tileLayerCatalog;

    protected void setUp() throws Exception {
        this.configPersister = (GWCConfigPersister)Mockito.mock(GWCConfigPersister.class);
        Mockito.when((Object)this.configPersister.getConfig()).thenReturn((Object)GWCConfig.getOldDefaults());
        this.rawCatalog = (Catalog)Mockito.mock(Catalog.class);
        this.tileLayerCatalog = (TileLayerCatalog)Mockito.mock(TileLayerCatalog.class);
        this.initializer = new GWCInitializer(this.configPersister, this.rawCatalog, this.tileLayerCatalog);
        this.geoServer = (GeoServer)Mockito.mock(GeoServer.class);
    }

    public void testInitializeLayersToOldDefaults() throws Exception {
        Mockito.when((Object)this.configPersister.findConfigFile()).thenReturn(null);
        Mockito.when((Object)this.geoServer.getService((Class)Matchers.eq(WMSInfo.class))).thenReturn(null);
        LayerInfoImpl layer = GWCTestHelpers.mockLayer("testLayer", new String[0], LayerInfo.Type.RASTER);
        LayerGroupInfoImpl group = GWCTestHelpers.mockGroup("testGroup", new LayerInfo[]{layer});
        Mockito.when((Object)this.rawCatalog.getLayers()).thenReturn((Object)Lists.newArrayList((Object[])new LayerInfo[]{layer}));
        Mockito.when((Object)this.rawCatalog.getLayerGroups()).thenReturn((Object)Lists.newArrayList((Object[])new LayerGroupInfo[]{group}));
        this.initializer.initialize(this.geoServer);
        GWCConfig oldDefaults = GWCConfig.getOldDefaults();
        GeoServerTileLayerInfoImpl tileLayer = TileLayerInfoUtil.loadOrCreate((LayerInfo)layer, (GWCConfig)oldDefaults);
        GeoServerTileLayerInfoImpl tileLayerGroup = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)group, (GWCConfig)oldDefaults);
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).save((GeoServerTileLayerInfo)Matchers.eq((Object)tileLayer));
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).save((GeoServerTileLayerInfo)Matchers.eq((Object)tileLayerGroup));
    }

    public void testUpgradeDirectWMSIntegrationFlag() throws Exception {
        Mockito.when((Object)this.configPersister.findConfigFile()).thenReturn(null);
        ImmutableList layers = ImmutableList.of();
        ImmutableList groups = ImmutableList.of();
        Mockito.when((Object)this.rawCatalog.getLayers()).thenReturn((Object)layers);
        Mockito.when((Object)this.rawCatalog.getLayerGroups()).thenReturn((Object)groups);
        WMSInfoImpl wmsInfo = new WMSInfoImpl();
        wmsInfo.getMetadata().put(GWCInitializer.WMS_INTEGRATION_ENABLED_KEY, (Serializable)Boolean.TRUE);
        Mockito.when((Object)this.geoServer.getService((Class)Matchers.eq(WMSInfo.class))).thenReturn((Object)wmsInfo);
        ArgumentCaptor captor = ArgumentCaptor.forClass(GWCConfig.class);
        this.initializer.initialize(this.geoServer);
        ((GWCConfigPersister)Mockito.verify((Object)this.configPersister, (VerificationMode)Mockito.times((int)2))).save((GWCConfig)captor.capture());
        GWCInitializerTest.assertTrue((boolean)((GWCConfig)captor.getAllValues().get(0)).isDirectWMSIntegrationEnabled());
        GWCInitializerTest.assertFalse((boolean)wmsInfo.getMetadata().containsKey((Object)GWCInitializer.WMS_INTEGRATION_ENABLED_KEY));
        ((GeoServer)Mockito.verify((Object)this.geoServer)).save((ServiceInfo)Matchers.same((Object)wmsInfo));
    }

    public void testUpgradeFromTileLayerInfosToTileLayerCatalog() throws Exception {
        File fakeConfig = new File("target", "gwc-gs.xml");
        Mockito.when((Object)this.configPersister.findConfigFile()).thenReturn((Object)fakeConfig);
        GWCConfig defaults = GWCConfig.getOldDefaults();
        defaults.setCacheLayersByDefault(true);
        Mockito.when((Object)this.configPersister.getConfig()).thenReturn((Object)defaults);
        LayerInfoImpl layer = GWCTestHelpers.mockLayer("testLayer", new String[0], LayerInfo.Type.RASTER);
        LayerGroupInfoImpl group = GWCTestHelpers.mockGroup("testGroup", new LayerInfo[]{layer});
        Mockito.when((Object)this.rawCatalog.getLayers()).thenReturn((Object)Lists.newArrayList((Object[])new LayerInfo[]{layer}));
        Mockito.when((Object)this.rawCatalog.getLayerGroups()).thenReturn((Object)Lists.newArrayList((Object[])new LayerGroupInfo[]{group}));
        GeoServerTileLayerInfoImpl layerInfo = TileLayerInfoUtil.loadOrCreate((LayerInfo)layer, (GWCConfig)defaults);
        GeoServerTileLayerInfoImpl groupInfo = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)group, (GWCConfig)defaults);
        LegacyTileLayerInfoLoader.save((GeoServerTileLayerInfo)layerInfo, (MetadataMap)layer.getMetadata());
        LegacyTileLayerInfoLoader.save((GeoServerTileLayerInfo)groupInfo, (MetadataMap)group.getMetadata());
        this.initializer.initialize(this.geoServer);
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).save((GeoServerTileLayerInfo)Matchers.eq((Object)layerInfo));
        GWCInitializerTest.assertFalse((boolean)LegacyTileLayerInfoLoader.hasTileLayerDef((MetadataMap)layer.getMetadata()));
        ((Catalog)Mockito.verify((Object)this.rawCatalog, (VerificationMode)Mockito.times((int)1))).save((LayerInfo)Matchers.eq((Object)layer));
        ((TileLayerCatalog)Mockito.verify((Object)this.tileLayerCatalog, (VerificationMode)Mockito.times((int)1))).save((GeoServerTileLayerInfo)Matchers.eq((Object)groupInfo));
        GWCInitializerTest.assertFalse((boolean)LegacyTileLayerInfoLoader.hasTileLayerDef((MetadataMap)group.getMetadata()));
        ((Catalog)Mockito.verify((Object)this.rawCatalog, (VerificationMode)Mockito.times((int)1))).save((LayerGroupInfo)Matchers.eq((Object)group));
    }
}

