/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mockrunner.mock.web.MockHttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.data.test.MockData;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.test.GeoServerTestSupport;
import org.geoserver.test.OneTimeSetupTest;
import org.geowebcache.filter.parameters.FloatParameterFilter;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.util.ServletUtils;
import org.w3c.dom.Document;

public class RESTIntegrationTest
extends GeoServerTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new RESTIntegrationTest());
    }

    protected void setUpInternal() {
        GWC.get().getConfig().setDirectWMSIntegrationEnabled(false);
    }

    public void testGetLayersList() throws Exception {
        String url = "gwc/rest/layers.xml";
        MockHttpServletResponse sr = this.getAsServletResponse("gwc/rest/layers.xml");
        RESTIntegrationTest.assertEquals((int)200, (int)sr.getErrorCode());
        RESTIntegrationTest.assertTrue((String)sr.getContentType(), (boolean)sr.getContentType().startsWith("text/xml"));
        Document dom = this.getAsDOM("gwc/rest/layers.xml");
        ArrayList tileLayerNames = Lists.newArrayList((Iterable)GWC.get().getTileLayerNames());
        Collections.sort(tileLayerNames);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext((Map)ImmutableMap.of((Object)"atom", (Object)"http://www.w3.org/2005/Atom")));
        for (String name : tileLayerNames) {
            String xpath = "//layers/layer/name[text() = '" + name + "']";
            XMLAssert.assertXpathExists((String)xpath, (Document)dom);
            xpath = "//layers/layer/atom:link[@href = 'http://localhost/geoserver/gwc/rest/layers/" + ServletUtils.URLEncode((String)name) + ".xml']";
            XMLAssert.assertXpathExists((String)xpath, (Document)dom);
        }
    }

    public void testGetLayer() throws Exception {
        String layerName = this.getLayerId(MockData.BASIC_POLYGONS);
        String url = "gwc/rest/layers/" + layerName + ".xml";
        String id = this.getCatalog().getLayerByName(layerName).getId();
        MockHttpServletResponse sr = this.getAsServletResponse(url);
        RESTIntegrationTest.assertEquals((int)200, (int)sr.getErrorCode());
        RESTIntegrationTest.assertTrue((String)sr.getContentType(), (boolean)sr.getContentType().startsWith("text/xml"));
        Document dom = this.getAsDOM(url);
        this.print(dom);
        XMLAssert.assertXpathExists((String)"/GeoServerLayer", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)id, (String)"/GeoServerLayer/id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)layerName, (String)"/GeoServerLayer/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/GeoServerLayer/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"image/png", (String)"/GeoServerLayer/mimeFormats/string[1]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"image/jpeg", (String)"/GeoServerLayer/mimeFormats/string[2]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"EPSG:900913", (String)"/GeoServerLayer/gridSubsets/gridSubset[1]/gridSetName", (Document)dom);
    }

    public void testPutBadId() throws Exception {
        String layerName = this.getLayerId(MockData.BASIC_POLYGONS);
        String url = "gwc/rest/layers/" + layerName + ".xml";
        MockHttpServletResponse response = this.putLayer(url, "badId", layerName);
        RESTIntegrationTest.assertEquals((int)400, (int)response.getStatusCode());
        String expected = "No GeoServer Layer or LayerGroup exists with id 'badId'";
        RESTIntegrationTest.assertEquals((String)expected, (String)response.getOutputStreamContent());
        RESTIntegrationTest.assertTrue((boolean)response.getContentType().startsWith("text/plain"));
    }

    public void testPutNoIdBadLayerName() throws Exception {
        String url = "gwc/rest/layers/badLayerName.xml";
        MockHttpServletResponse response = this.putLayer("gwc/rest/layers/badLayerName.xml", "", "badLayerName");
        RESTIntegrationTest.assertEquals((int)404, (int)response.getStatusCode());
        String expected = "GeoServer Layer or LayerGroup 'badLayerName' not found";
        RESTIntegrationTest.assertEquals((String)expected, (String)response.getOutputStreamContent());
    }

    public void testPutGoodIdBadLayerName() throws Exception {
        String layerName = this.getLayerId(MockData.BASIC_POLYGONS);
        String id = this.getCatalog().getLayerByName(layerName).getId();
        String url = "gwc/rest/layers/badLayerName.xml";
        MockHttpServletResponse response = this.putLayer("gwc/rest/layers/badLayerName.xml", id, "badLayerName");
        RESTIntegrationTest.assertEquals((int)400, (int)response.getStatusCode());
        String expected = "Layer with id '" + id + "' found but name does not match: 'badLayerName'/'" + layerName + "'";
        RESTIntegrationTest.assertEquals((String)expected, (String)response.getOutputStreamContent());
    }

    public void testPutGoodIdNoLayerName() throws Exception {
        String layerName = this.getLayerId(MockData.BASIC_POLYGONS);
        String id = this.getCatalog().getLayerByName(layerName).getId();
        String url = "gwc/rest/layers/" + layerName + ".xml";
        MockHttpServletResponse response = this.putLayer(url, id, "");
        RESTIntegrationTest.assertEquals((int)400, (int)response.getStatusCode());
        String expected = "Layer name not provided";
        RESTIntegrationTest.assertEquals((String)expected, (String)response.getOutputStreamContent());
    }

    public void testPutOverExistingTileLayerFails() throws Exception {
        String layerName = this.getLayerId(MockData.BASIC_POLYGONS);
        String id = this.getCatalog().getLayerByName(layerName).getId();
        String url = "gwc/rest/layers/" + layerName + ".xml";
        MockHttpServletResponse response = this.putLayer(url, id, layerName);
        RESTIntegrationTest.assertEquals((int)400, (int)response.getStatusCode());
        String expected = "Layer with name " + layerName + " already exists, use POST if you want to replace it.";
        RESTIntegrationTest.assertEquals((String)expected, (String)response.getOutputStreamContent());
    }

    public void testPutBadLayerEndpoint() throws Exception {
        String layerName = this.getLayerId(MockData.BASIC_POLYGONS);
        String id = this.getCatalog().getLayerByName(layerName).getId();
        String url = "gwc/rest/layers/badEndpoint.xml";
        MockHttpServletResponse response = this.putLayer("gwc/rest/layers/badEndpoint.xml", id, layerName);
        RESTIntegrationTest.assertEquals((int)400, (int)response.getStatusCode());
        String expected = "There is a mismatch between the name of the  layer in the submission and the URL you specified.";
        RESTIntegrationTest.assertEquals((String)expected, (String)response.getOutputStreamContent());
    }

    public void testPutSuccess() throws Exception {
        String layerName = this.getLayerId(MockData.FORESTS);
        String id = this.getCatalog().getLayerByName(layerName).getId();
        GWC mediator = GWC.get();
        RESTIntegrationTest.assertTrue((boolean)mediator.tileLayerExists(layerName));
        mediator.removeTileLayers((List)Lists.newArrayList((Object[])new String[]{layerName}));
        RESTIntegrationTest.assertFalse((boolean)mediator.tileLayerExists(layerName));
        String url = "gwc/rest/layers/" + layerName + ".xml";
        MockHttpServletResponse response = this.putLayer(url, id, layerName);
        RESTIntegrationTest.assertEquals((int)200, (int)response.getStatusCode());
        RESTIntegrationTest.assertTrue((boolean)mediator.tileLayerExists(layerName));
    }

    public void testPutParameterFilters() throws Exception {
        String layerName = this.getLayerId(MockData.LAKES);
        GWC mediator = GWC.get();
        RESTIntegrationTest.assertTrue((boolean)mediator.tileLayerExists(layerName));
        mediator.removeTileLayers((List)Lists.newArrayList((Object[])new String[]{layerName}));
        RESTIntegrationTest.assertFalse((boolean)mediator.tileLayerExists(layerName));
        String xml = "<GeoServerLayer> <enabled>true</enabled> <name>" + layerName + "</name>" + " <mimeFormats><string>image/png8</string></mimeFormats>" + " <gridSubsets>" + "  <gridSubset><gridSetName>GoogleCRS84Quad</gridSetName></gridSubset>" + "  <gridSubset><gridSetName>EPSG:4326</gridSetName></gridSubset>" + " </gridSubsets>" + " <metaWidthHeight><int>9</int><int>6</int></metaWidthHeight>" + " <parameterFilters>" + "  <stringParameterFilter>" + "   <key>STYLES</key>" + "   <defaultValue>capitals</defaultValue>" + "   <values><string>burg</string><string>point</string></values>" + "  </stringParameterFilter>" + "  <floatParameterFilter>" + "   <key>ELEVATION</key>" + "   <defaultValue>10.1</defaultValue>" + "    <values>" + "     <float>10.1</float><float>10.2</float><float>10.3</float>" + "    </values>" + "   <threshold>1.0E-2</threshold>" + "  </floatParameterFilter>" + " </parameterFilters>" + " <gutter>20</gutter>" + " <autoCacheStyles>true</autoCacheStyles>" + "</GeoServerLayer>";
        String url = "gwc/rest/layers/" + layerName + ".xml";
        MockHttpServletResponse response = super.putAsServletResponse(url, xml, "text/xml");
        RESTIntegrationTest.assertEquals((int)200, (int)response.getStatusCode());
        RESTIntegrationTest.assertTrue((boolean)mediator.tileLayerExists(layerName));
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)mediator.getTileLayerByName(layerName);
        GeoServerTileLayerInfo info = tileLayer.getInfo();
        RESTIntegrationTest.assertEquals((int)20, (int)info.getGutter());
        RESTIntegrationTest.assertEquals((int)2, (int)tileLayer.getGridSubsets().size());
        RESTIntegrationTest.assertTrue((boolean)tileLayer.getGridSubsets().contains("GoogleCRS84Quad"));
        RESTIntegrationTest.assertTrue((boolean)tileLayer.getGridSubsets().contains("EPSG:4326"));
        RESTIntegrationTest.assertEquals((Object)ImmutableSet.of((Object)"image/png8"), (Object)info.getMimeFormats());
        RESTIntegrationTest.assertEquals((int)9, (int)info.getMetaTilingX());
        RESTIntegrationTest.assertEquals((int)6, (int)info.getMetaTilingY());
        ArrayList filters = Lists.newArrayList((Iterable)info.getParameterFilters());
        RESTIntegrationTest.assertEquals((int)2, (int)filters.size());
        ParameterFilter f1 = (ParameterFilter)filters.get(0);
        ParameterFilter f2 = (ParameterFilter)filters.get(1);
        FloatParameterFilter floatFilter = (FloatParameterFilter)(f1 instanceof FloatParameterFilter ? f1 : (f2 instanceof FloatParameterFilter ? f2 : null));
        StringParameterFilter stringFilter = (StringParameterFilter)(f1 instanceof StringParameterFilter ? f1 : (f2 instanceof StringParameterFilter ? f2 : null));
        RESTIntegrationTest.assertNotNull((Object)floatFilter);
        RESTIntegrationTest.assertNotNull((Object)stringFilter);
        RESTIntegrationTest.assertEquals((String)"ELEVATION", (String)floatFilter.getKey());
        RESTIntegrationTest.assertEquals((String)"10.1", (String)floatFilter.getDefaultValue());
        RESTIntegrationTest.assertEquals((Object)Float.valueOf(0.01f), (Object)floatFilter.getThreshold());
        RESTIntegrationTest.assertEquals((Object)ImmutableList.of((Object)new Float(10.1f), (Object)new Float(10.2f), (Object)new Float(10.3f)), (Object)floatFilter.getValues());
        RESTIntegrationTest.assertEquals((String)"STYLES", (String)stringFilter.getKey());
        RESTIntegrationTest.assertEquals((String)"capitals", (String)stringFilter.getDefaultValue());
        RESTIntegrationTest.assertEquals((Object)ImmutableList.of((Object)"burg", (Object)"point"), (Object)stringFilter.getLegalValues());
    }

    private MockHttpServletResponse putLayer(String url, String id, String name) throws Exception {
        String xml = "<GeoServerLayer>  <id>" + id + "</id>" + "  <enabled>true</enabled>" + "  <name>" + name + "</name>" + "  <mimeFormats>" + "    <string>image/jpeg</string>" + "  </mimeFormats>" + "  <gridSubsets>" + "    <gridSubset>" + "     <gridSetName>EPSG:900913</gridSetName>" + "    </gridSubset>" + "  </gridSubsets>" + "  <metaWidthHeight>" + "    <int>4</int>" + "    <int>4</int>" + "  </metaWidthHeight>" + "  <autoCacheStyles>true</autoCacheStyles>" + "</GeoServerLayer>";
        String contentType = "text/xml";
        MockHttpServletResponse response = super.putAsServletResponse(url, xml, "text/xml");
        return response;
    }

    public void testDelete() throws Exception {
        String layerName = this.getLayerId(MockData.BRIDGES);
        GWC mediator = GWC.get();
        RESTIntegrationTest.assertTrue((boolean)mediator.tileLayerExists(layerName));
        String url = "gwc/rest/layers/" + layerName + ".xml";
        MockHttpServletResponse response = super.deleteAsServletResponse(url);
        RESTIntegrationTest.assertEquals((int)200, (int)response.getStatusCode());
        RESTIntegrationTest.assertFalse((boolean)mediator.tileLayerExists(layerName));
    }

    public void testDeleteNonExistentLayer() throws Exception {
        String url = "gwc/rest/layers/badLayerName.xml";
        MockHttpServletResponse response = super.deleteAsServletResponse("gwc/rest/layers/badLayerName.xml");
        RESTIntegrationTest.assertEquals((int)404, (int)response.getStatusCode());
        RESTIntegrationTest.assertEquals((String)"Unknown layer: badLayerName", (String)response.getOutputStreamContent());
    }

    public void testPost() throws Exception {
        String layerName = this.getLayerId(MockData.ROAD_SEGMENTS);
        GWC mediator = GWC.get();
        RESTIntegrationTest.assertTrue((boolean)mediator.tileLayerExists(layerName));
        String xml = "<GeoServerLayer> <enabled>true</enabled> <name>" + layerName + "</name>" + " <mimeFormats><string>image/png8</string></mimeFormats>" + " <gridSubsets>" + "  <gridSubset><gridSetName>GoogleCRS84Quad</gridSetName></gridSubset>" + "  <gridSubset><gridSetName>EPSG:4326</gridSetName></gridSubset>" + " </gridSubsets>" + " <metaWidthHeight><int>9</int><int>6</int></metaWidthHeight>" + " <parameterFilters>" + "  <stringParameterFilter>" + "   <key>STYLES</key>" + "   <defaultValue>capitals</defaultValue>" + "   <values><string>burg</string><string>point</string></values>" + "  </stringParameterFilter>" + "  <floatParameterFilter>" + "   <key>ELEVATION</key>" + "   <defaultValue>10.1</defaultValue>" + "    <values>" + "     <float>10.1</float><float>10.2</float><float>10.3</float>" + "    </values>" + "   <threshold>1.0E-2</threshold>" + "  </floatParameterFilter>" + " </parameterFilters>" + " <gutter>20</gutter>" + " <autoCacheStyles>true</autoCacheStyles>" + "</GeoServerLayer>";
        String url = "gwc/rest/layers/" + layerName + ".xml";
        MockHttpServletResponse response = super.postAsServletResponse(url, xml, "text/xml");
        RESTIntegrationTest.assertEquals((int)200, (int)response.getStatusCode());
        RESTIntegrationTest.assertTrue((boolean)mediator.tileLayerExists(layerName));
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)mediator.getTileLayerByName(layerName);
        GeoServerTileLayerInfo info = tileLayer.getInfo();
        RESTIntegrationTest.assertEquals((int)20, (int)info.getGutter());
        RESTIntegrationTest.assertEquals((int)2, (int)tileLayer.getGridSubsets().size());
        RESTIntegrationTest.assertTrue((boolean)tileLayer.getGridSubsets().contains("GoogleCRS84Quad"));
        RESTIntegrationTest.assertTrue((boolean)tileLayer.getGridSubsets().contains("EPSG:4326"));
        RESTIntegrationTest.assertEquals((Object)ImmutableSet.of((Object)"image/png8"), (Object)info.getMimeFormats());
        RESTIntegrationTest.assertEquals((int)9, (int)info.getMetaTilingX());
        RESTIntegrationTest.assertEquals((int)6, (int)info.getMetaTilingY());
        ArrayList filters = Lists.newArrayList((Iterable)info.getParameterFilters());
        RESTIntegrationTest.assertEquals((int)2, (int)filters.size());
        ParameterFilter f1 = (ParameterFilter)filters.get(0);
        ParameterFilter f2 = (ParameterFilter)filters.get(1);
        FloatParameterFilter floatFilter = (FloatParameterFilter)(f1 instanceof FloatParameterFilter ? f1 : (f2 instanceof FloatParameterFilter ? f2 : null));
        StringParameterFilter stringFilter = (StringParameterFilter)(f1 instanceof StringParameterFilter ? f1 : (f2 instanceof StringParameterFilter ? f2 : null));
        RESTIntegrationTest.assertNotNull((Object)floatFilter);
        RESTIntegrationTest.assertNotNull((Object)stringFilter);
        RESTIntegrationTest.assertEquals((String)"ELEVATION", (String)floatFilter.getKey());
        RESTIntegrationTest.assertEquals((String)"10.1", (String)floatFilter.getDefaultValue());
        RESTIntegrationTest.assertEquals((Object)Float.valueOf(0.01f), (Object)floatFilter.getThreshold());
        RESTIntegrationTest.assertEquals((Object)ImmutableList.of((Object)new Float(10.1f), (Object)new Float(10.2f), (Object)new Float(10.3f)), (Object)floatFilter.getValues());
        RESTIntegrationTest.assertEquals((String)"STYLES", (String)stringFilter.getKey());
        RESTIntegrationTest.assertEquals((String)"capitals", (String)stringFilter.getDefaultValue());
        RESTIntegrationTest.assertEquals((Object)ImmutableList.of((Object)"burg", (Object)"point"), (Object)stringFilter.getLegalValues());
    }
}

