/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.impl.LayerGroupInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.GWCTestHelpers;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.config.GWCConfigPersister;
import org.geoserver.gwc.layer.CatalogLayerEventListener;
import org.geoserver.gwc.layer.CatalogStyleChangeListener;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.kvp.PaletteManager;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.Configuration;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.config.XMLGridSet;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.diskquota.DiskQuotaMonitor;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeType;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.seed.TileBreeder;
import org.geowebcache.service.Service;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GWCTest
extends TestCase {
    private GWC mediator;
    private GWCConfig defaults;
    private GWCConfigPersister gwcConfigPersister;
    private StorageBroker storageBroker;
    private GridSetBroker gridSetBroker;
    private Configuration config;
    private TileLayerDispatcher tld;
    private TileBreeder tileBreeder;
    private QuotaStore quotaStore;
    private DiskQuotaMonitor diskQuotaMonitor;
    private Dispatcher owsDispatcher;
    private Catalog catalog;
    LayerInfo layer;
    LayerGroupInfo layerGroup;
    GeoServerTileLayerInfo tileLayerInfo;
    GeoServerTileLayerInfo tileLayerGroupInfo;
    GeoServerTileLayer tileLayer;
    GeoServerTileLayer tileLayerGroup;

    protected void setUp() throws Exception {
        this.catalog = (Catalog)Mockito.mock(Catalog.class);
        this.layer = GWCTestHelpers.mockLayer("testLayer", new String[]{"style1", "style2"}, LayerInfo.Type.RASTER);
        this.layerGroup = GWCTestHelpers.mockGroup("testGroup", this.layer);
        this.mockCatalog();
        this.defaults = GWCConfig.getOldDefaults();
        this.gwcConfigPersister = (GWCConfigPersister)Mockito.mock(GWCConfigPersister.class);
        Mockito.when((Object)this.gwcConfigPersister.getConfig()).thenReturn((Object)this.defaults);
        this.storageBroker = (StorageBroker)Mockito.mock(StorageBroker.class);
        this.gridSetBroker = new GridSetBroker(true, true);
        this.tileLayerInfo = TileLayerInfoUtil.loadOrCreate((LayerInfo)this.layer, (GWCConfig)this.defaults);
        this.tileLayerGroupInfo = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)this.layerGroup, (GWCConfig)this.defaults);
        this.tileLayer = new GeoServerTileLayer(this.layer, this.gridSetBroker, this.tileLayerInfo);
        this.tileLayerGroup = new GeoServerTileLayer(this.layerGroup, this.gridSetBroker, this.tileLayerGroupInfo);
        this.tld = (TileLayerDispatcher)Mockito.mock(TileLayerDispatcher.class);
        this.mockTileLayerDispatcher();
        this.config = (Configuration)Mockito.mock(Configuration.class);
        this.tileBreeder = (TileBreeder)Mockito.mock(TileBreeder.class);
        this.quotaStore = (QuotaStore)Mockito.mock(QuotaStore.class);
        this.diskQuotaMonitor = (DiskQuotaMonitor)Mockito.mock(DiskQuotaMonitor.class);
        this.owsDispatcher = (Dispatcher)Mockito.mock(Dispatcher.class);
        this.mediator = new GWC(this.gwcConfigPersister, this.storageBroker, this.tld, this.gridSetBroker, this.tileBreeder, this.quotaStore, this.diskQuotaMonitor, this.owsDispatcher, this.catalog);
        GWC.set((GWC)this.mediator);
    }

    protected void tearDown() {
        GWC.set(null);
    }

    private void mockCatalog() {
        Mockito.when((Object)this.catalog.getLayers()).thenReturn(Arrays.asList(this.layer));
        Mockito.when((Object)this.catalog.getLayerGroups()).thenReturn(Arrays.asList(this.layerGroup));
        Mockito.when((Object)this.catalog.getLayer((String)Matchers.eq((Object)this.layer.getId()))).thenReturn((Object)this.layer);
        Mockito.when((Object)this.catalog.getLayerGroup(this.layerGroup.getId())).thenReturn((Object)this.layerGroup);
        Mockito.when((Object)this.catalog.getLayerByName((String)Matchers.eq((Object)this.layer.getResource().prefixedName()))).thenReturn((Object)this.layer);
        Mockito.when((Object)this.catalog.getLayerGroupByName(GWC.tileLayerName((LayerGroupInfo)this.layerGroup))).thenReturn((Object)this.layerGroup);
    }

    private void mockTileLayerDispatcher() throws Exception {
        Mockito.when((Object)this.tld.getConfiguration((TileLayer)Matchers.same((Object)this.tileLayer))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.getConfiguration((TileLayer)Matchers.same((Object)this.tileLayerGroup))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.getConfiguration((String)Matchers.eq((Object)this.tileLayer.getName()))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.getConfiguration((String)Matchers.eq((Object)this.tileLayerGroup.getName()))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.getTileLayer((String)Matchers.eq((Object)this.tileLayer.getName()))).thenReturn((Object)this.tileLayer);
        Mockito.when((Object)this.tld.getTileLayer((String)Matchers.eq((Object)this.tileLayerGroup.getName()))).thenReturn((Object)this.tileLayerGroup);
        Mockito.when((Object)this.tld.getLayerNames()).thenReturn((Object)ImmutableSet.of((Object)this.tileLayer.getName(), (Object)this.tileLayerGroup.getName()));
        ImmutableList tileLayers = ImmutableList.of((Object)this.tileLayer, (Object)this.tileLayerGroup);
        Mockito.when((Object)this.tld.getLayerList()).thenReturn((Object)tileLayers);
        Mockito.when((Object)this.tld.layerExists((String)Matchers.eq((Object)this.tileLayer.getName()))).thenReturn((Object)true);
        Mockito.when((Object)this.tld.layerExists((String)Matchers.eq((Object)this.tileLayerGroup.getName()))).thenReturn((Object)true);
    }

    public void testAddTileLayer() throws Exception {
        Mockito.when((Object)this.tld.addLayer((TileLayer)Matchers.same((Object)this.tileLayer))).thenThrow(new Throwable[]{new IllegalArgumentException("fake")});
        Mockito.when((Object)this.tld.addLayer((TileLayer)Matchers.same((Object)this.tileLayerGroup))).thenReturn((Object)this.config);
        try {
            this.mediator.add(this.tileLayer);
            GWCTest.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            GWCTest.assertTrue((boolean)true);
        }
        this.mediator.add(this.tileLayerGroup);
        ((Configuration)Mockito.verify((Object)this.config, (VerificationMode)Mockito.times((int)1))).save();
    }

    public void testModifyTileLayer() throws Exception {
        try {
            this.mediator.save(null);
            GWCTest.fail();
        }
        catch (NullPointerException e) {
            GWCTest.assertTrue((boolean)true);
        }
        Mockito.when((Object)this.tld.modify((TileLayer)Matchers.same((Object)this.tileLayer))).thenThrow(new Throwable[]{new IllegalArgumentException()});
        try {
            this.mediator.save(this.tileLayer);
            GWCTest.fail();
        }
        catch (IllegalArgumentException e) {
            GWCTest.assertTrue((boolean)true);
        }
        Mockito.when((Object)this.tld.modify((TileLayer)Matchers.same((Object)this.tileLayerGroup))).thenReturn((Object)this.config);
        this.mediator.save(this.tileLayerGroup);
        ((Configuration)Mockito.verify((Object)this.config, (VerificationMode)Mockito.times((int)1))).save();
        Mockito.when((Object)this.tld.modify((TileLayer)Matchers.same((Object)this.tileLayer))).thenReturn((Object)this.config);
        ((Configuration)Mockito.doThrow((Throwable)new IOException()).when((Object)this.config)).save();
        try {
            this.mediator.save(this.tileLayer);
        }
        catch (RuntimeException e) {
            GWCTest.assertTrue((boolean)true);
        }
    }

    public void testRemoveTileLayers() throws Exception {
        try {
            this.mediator.removeTileLayers(null);
        }
        catch (NullPointerException e) {
            GWCTest.assertTrue((boolean)true);
        }
        Mockito.when((Object)this.tld.removeLayer((String)Matchers.eq((Object)this.tileLayer.getName()))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.removeLayer((String)Matchers.eq((Object)this.tileLayerGroup.getName()))).thenReturn((Object)this.config);
        List<String> layerNames = Arrays.asList(this.tileLayer.getName(), this.tileLayerGroup.getName());
        this.mediator.removeTileLayers(layerNames);
        ((TileLayerDispatcher)Mockito.verify((Object)this.tld, (VerificationMode)Mockito.times((int)1))).removeLayer((String)Matchers.eq((Object)this.tileLayer.getName()));
        ((TileLayerDispatcher)Mockito.verify((Object)this.tld, (VerificationMode)Mockito.times((int)1))).removeLayer((String)Matchers.eq((Object)this.tileLayerGroup.getName()));
        ((Configuration)Mockito.verify((Object)this.config, (VerificationMode)Mockito.times((int)1))).save();
    }

    public void testAddGridset() throws Exception {
        try {
            this.mediator.addGridSet(null);
            GWCTest.fail();
        }
        catch (NullPointerException e) {
            GWCTest.assertTrue((boolean)true);
        }
        GridSet gset = (GridSet)Mockito.mock(GridSet.class);
        GridSet gset2 = (GridSet)Mockito.mock(GridSet.class);
        ((TileLayerDispatcher)Mockito.doThrow((Throwable)new IOException("fake")).when((Object)this.tld)).addGridSet((GridSet)Matchers.same((Object)gset));
        try {
            this.mediator.addGridSet(gset);
            GWCTest.fail();
        }
        catch (IOException e) {
            GWCTest.assertEquals((String)"fake", (String)e.getMessage());
        }
        this.mediator.addGridSet(gset2);
        ((TileLayerDispatcher)Mockito.verify((Object)this.tld, (VerificationMode)Mockito.times((int)1))).addGridSet((GridSet)Matchers.same((Object)gset2));
    }

    public void testModifyGridsetPreconditions() throws Exception {
        GridSet oldGridset = this.gridSetBroker.get("EPSG:4326");
        try {
            this.mediator.modifyGridSet(null, oldGridset);
            GWCTest.fail();
        }
        catch (NullPointerException e) {
            GWCTest.assertTrue((boolean)true);
        }
        try {
            this.mediator.modifyGridSet("oldname", null);
            GWCTest.fail();
        }
        catch (NullPointerException e) {
            GWCTest.assertTrue((boolean)true);
        }
        try {
            this.mediator.modifyGridSet("wrongOldName", oldGridset);
            GWCTest.fail();
        }
        catch (IllegalArgumentException e) {
            GWCTest.assertTrue((boolean)e.getMessage().contains("does not exist"));
        }
    }

    public void testModifyGridsetNoNeedToTruncate() throws Exception {
        String oldName = "EPSG:4326";
        String newName = "MyEPSG:4326";
        GridSet oldGridset = this.gridSetBroker.get("EPSG:4326");
        XMLGridSet xmlGridSet = new XMLGridSet(oldGridset);
        xmlGridSet.setName("MyEPSG:4326");
        GridSet newGridset = xmlGridSet.makeGridSet();
        XMLConfiguration xmlConfig = (XMLConfiguration)Mockito.mock(XMLConfiguration.class);
        this.mediator = (GWC)Mockito.spy((Object)this.mediator);
        Mockito.when((Object)this.mediator.getXmlConfiguration()).thenReturn((Object)xmlConfig);
        GWCTest.assertNotNull((Object)this.tileLayer.getGridSubset("EPSG:4326"));
        GWCTest.assertNotNull((Object)this.tileLayerGroup.getGridSubset("EPSG:4326"));
        Mockito.when((Object)this.tld.getConfiguration((TileLayer)Matchers.same((Object)this.tileLayer))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.getConfiguration((TileLayer)Matchers.same((Object)this.tileLayerGroup))).thenReturn((Object)this.config);
        this.mediator.modifyGridSet("EPSG:4326", newGridset);
        GWCTest.assertNull((Object)this.tileLayer.getGridSubset("EPSG:4326"));
        GWCTest.assertNull((Object)this.tileLayerGroup.getGridSubset("EPSG:4326"));
        GWCTest.assertNotNull((Object)this.tileLayer.getGridSubset("MyEPSG:4326"));
        GWCTest.assertNotNull((Object)this.tileLayerGroup.getGridSubset("MyEPSG:4326"));
        ((XMLConfiguration)Mockito.verify((Object)xmlConfig, (VerificationMode)Mockito.times((int)1))).removeGridset((String)Matchers.eq((Object)"EPSG:4326"));
        ((XMLConfiguration)Mockito.verify((Object)xmlConfig, (VerificationMode)Mockito.times((int)1))).addOrReplaceGridSet((XMLGridSet)Matchers.eq((Object)new XMLGridSet(newGridset)));
        ((XMLConfiguration)Mockito.verify((Object)xmlConfig, (VerificationMode)Mockito.times((int)1))).save();
        GWCTest.assertNull((Object)this.gridSetBroker.get("EPSG:4326"));
        GWCTest.assertEquals((Object)newGridset, (Object)this.gridSetBroker.get("MyEPSG:4326"));
        ((Configuration)Mockito.verify((Object)this.config, (VerificationMode)Mockito.times((int)1))).save();
    }

    public void testModifyGridsetTruncates() throws Exception {
        String oldName = "EPSG:4326";
        String newName = "MyEPSG:4326";
        GridSet oldGridset = this.gridSetBroker.get("EPSG:4326");
        XMLGridSet xmlGridSet = new XMLGridSet(oldGridset);
        xmlGridSet.setName("MyEPSG:4326");
        xmlGridSet.setAlignTopLeft(Boolean.valueOf(xmlGridSet.getAlignTopLeft() == false));
        GridSet newGridset = xmlGridSet.makeGridSet();
        XMLConfiguration xmlConfig = (XMLConfiguration)Mockito.mock(XMLConfiguration.class);
        this.mediator = (GWC)Mockito.spy((Object)this.mediator);
        Mockito.when((Object)this.mediator.getXmlConfiguration()).thenReturn((Object)xmlConfig);
        Mockito.when((Object)this.tld.getConfiguration((TileLayer)Matchers.same((Object)this.tileLayer))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.getConfiguration((TileLayer)Matchers.same((Object)this.tileLayerGroup))).thenReturn((Object)this.config);
        this.mediator.modifyGridSet("EPSG:4326", newGridset);
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)1))).deleteByGridSetId((String)Matchers.eq((Object)this.tileLayer.getName()), (String)Matchers.eq((Object)"EPSG:4326"));
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)1))).deleteByGridSetId((String)Matchers.eq((Object)this.tileLayerGroup.getName()), (String)Matchers.eq((Object)"EPSG:4326"));
    }

    public void testRemoveGridsets() throws Exception {
        try {
            this.mediator.removeGridSets(null);
            GWCTest.fail();
        }
        catch (NullPointerException e) {
            GWCTest.assertTrue((boolean)true);
        }
        GridSet oldGridset = this.gridSetBroker.get("EPSG:4326");
        XMLGridSet xmlGridSet = new XMLGridSet(oldGridset);
        xmlGridSet.setName("My4326");
        xmlGridSet.setAlignTopLeft(Boolean.valueOf(xmlGridSet.getAlignTopLeft() == false));
        GridSet newGridset = xmlGridSet.makeGridSet();
        this.gridSetBroker.put(newGridset);
        Mockito.when((Object)this.tld.getConfiguration((TileLayer)Matchers.same((Object)this.tileLayer))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.getConfiguration((TileLayer)Matchers.same((Object)this.tileLayerGroup))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.modify((TileLayer)Matchers.same((Object)this.tileLayer))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.modify((TileLayer)Matchers.same((Object)this.tileLayerGroup))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.removeGridset((String)Matchers.eq((Object)"EPSG:4326"))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.removeGridset((String)Matchers.eq((Object)"My4326"))).thenReturn((Object)this.config);
        this.mediator.removeGridSets((Set)ImmutableSet.of((Object)"My4326", (Object)"EPSG:4326"));
        GWCTest.assertEquals((Object)ImmutableSet.of((Object)"EPSG:900913"), (Object)this.tileLayer.getGridSubsets());
        GWCTest.assertEquals((Object)ImmutableSet.of((Object)"EPSG:900913"), (Object)this.tileLayerGroup.getGridSubsets());
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)1))).deleteByGridSetId((String)Matchers.eq((Object)this.tileLayer.getName()), (String)Matchers.eq((Object)"EPSG:4326"));
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)1))).deleteByGridSetId((String)Matchers.eq((Object)this.tileLayerGroup.getName()), (String)Matchers.eq((Object)"EPSG:4326"));
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.never())).deleteByGridSetId((String)Matchers.eq((Object)this.tileLayer.getName()), (String)Matchers.eq((Object)"EPSG:900913"));
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.never())).deleteByGridSetId((String)Matchers.eq((Object)this.tileLayer.getName()), (String)Matchers.eq((Object)"My4326"));
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.never())).deleteByGridSetId((String)Matchers.eq((Object)this.tileLayerGroup.getName()), (String)Matchers.eq((Object)"EPSG:900913"));
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.never())).deleteByGridSetId((String)Matchers.eq((Object)this.tileLayerGroup.getName()), (String)Matchers.eq((Object)"My4326"));
        ((TileLayerDispatcher)Mockito.verify((Object)this.tld, (VerificationMode)Mockito.times((int)1))).modify((TileLayer)Matchers.same((Object)this.tileLayer));
        ((TileLayerDispatcher)Mockito.verify((Object)this.tld, (VerificationMode)Mockito.times((int)1))).modify((TileLayer)Matchers.same((Object)this.tileLayerGroup));
        ((TileLayerDispatcher)Mockito.verify((Object)this.tld, (VerificationMode)Mockito.times((int)1))).removeGridset((String)Matchers.eq((Object)"EPSG:4326"));
        ((TileLayerDispatcher)Mockito.verify((Object)this.tld, (VerificationMode)Mockito.times((int)1))).removeGridset((String)Matchers.eq((Object)"My4326"));
        ((Configuration)Mockito.verify((Object)this.config, (VerificationMode)Mockito.times((int)1))).save();
    }

    public void testRemoveAllLayerGridsetsDisablesLayer() throws Exception {
        Mockito.when((Object)this.tld.getConfiguration((TileLayer)Matchers.same((Object)this.tileLayer))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.getConfiguration((TileLayer)Matchers.same((Object)this.tileLayerGroup))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.modify((TileLayer)Matchers.same((Object)this.tileLayer))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.modify((TileLayer)Matchers.same((Object)this.tileLayerGroup))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.removeGridset((String)Matchers.eq((Object)"EPSG:4326"))).thenReturn((Object)this.config);
        Mockito.when((Object)this.tld.removeGridset((String)Matchers.eq((Object)"EPSG:900913"))).thenReturn((Object)this.config);
        GWCTest.assertTrue((boolean)this.tileLayer.getInfo().isEnabled());
        GWCTest.assertTrue((boolean)this.tileLayer.getInfo().isEnabled());
        this.mediator.removeGridSets((Set)ImmutableSet.of((Object)"EPSG:900913", (Object)"EPSG:4326"));
        ((Configuration)Mockito.verify((Object)this.config, (VerificationMode)Mockito.times((int)1))).save();
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)1))).deleteByGridSetId((String)Matchers.eq((Object)this.tileLayer.getName()), (String)Matchers.eq((Object)"EPSG:4326"));
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)1))).deleteByGridSetId((String)Matchers.eq((Object)this.tileLayerGroup.getName()), (String)Matchers.eq((Object)"EPSG:900913"));
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)1))).deleteByGridSetId((String)Matchers.eq((Object)this.tileLayer.getName()), (String)Matchers.eq((Object)"EPSG:4326"));
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)1))).deleteByGridSetId((String)Matchers.eq((Object)this.tileLayerGroup.getName()), (String)Matchers.eq((Object)"EPSG:900913"));
        GWCTest.assertTrue((boolean)this.tileLayer.getGridSubsets().isEmpty());
        GWCTest.assertTrue((boolean)this.tileLayerGroup.getGridSubsets().isEmpty());
        GWCTest.assertFalse((boolean)this.tileLayer.getInfo().isEnabled());
        GWCTest.assertFalse((boolean)this.tileLayerGroup.getInfo().isEnabled());
    }

    public void testAutoConfigureLayers() throws Exception {
        GWCConfig insaneDefaults = new GWCConfig();
        insaneDefaults.setMetaTilingX(-1);
        GWCTest.assertFalse((boolean)insaneDefaults.isSane());
        try {
            this.mediator.autoConfigureLayers(Arrays.asList(this.tileLayer.getName()), insaneDefaults);
        }
        catch (IllegalArgumentException e) {
            GWCTest.assertTrue((boolean)true);
        }
        try {
            this.mediator.autoConfigureLayers(Arrays.asList(this.tileLayer.getName()), this.defaults);
            GWCTest.fail((String)"expected IAE, layer exists");
        }
        catch (IllegalArgumentException e) {
            GWCTest.assertTrue((boolean)true);
        }
        LayerInfoImpl layer2 = GWCTestHelpers.mockLayer("layer2", new String[0], LayerInfo.Type.RASTER);
        LayerGroupInfoImpl group2 = GWCTestHelpers.mockGroup("group2", new LayerInfo[]{this.layer, layer2});
        Mockito.when((Object)this.catalog.getLayerByName((String)Matchers.eq((Object)GWC.tileLayerName((LayerInfo)layer2)))).thenReturn((Object)layer2);
        Mockito.when((Object)this.catalog.getLayerGroupByName((String)Matchers.eq((Object)GWC.tileLayerName((LayerGroupInfo)group2)))).thenReturn((Object)group2);
        List<String> layerNames = Arrays.asList(GWC.tileLayerName((LayerInfo)layer2), GWC.tileLayerName((LayerGroupInfo)group2));
        Mockito.when((Object)this.tld.addLayer((TileLayer)Matchers.any(GeoServerTileLayer.class))).thenReturn((Object)this.config);
        this.mediator.autoConfigureLayers(layerNames, this.defaults);
        GeoServerTileLayerInfo expected1 = new GeoServerTileLayer((LayerInfo)layer2, this.defaults, this.gridSetBroker).getInfo();
        GeoServerTileLayerInfo expected2 = new GeoServerTileLayer((LayerGroupInfo)group2, this.defaults, this.gridSetBroker).getInfo();
        ArgumentCaptor addCaptor = ArgumentCaptor.forClass(GeoServerTileLayer.class);
        ((TileLayerDispatcher)Mockito.verify((Object)this.tld, (VerificationMode)Mockito.times((int)2))).addLayer((TileLayer)addCaptor.capture());
        ((Configuration)Mockito.verify((Object)this.config, (VerificationMode)Mockito.times((int)2))).save();
        GeoServerTileLayerInfo actual1 = ((GeoServerTileLayer)addCaptor.getAllValues().get(0)).getInfo();
        GeoServerTileLayerInfo actual2 = ((GeoServerTileLayer)addCaptor.getAllValues().get(1)).getInfo();
        GWCTest.assertEquals((Object)expected1, (Object)actual1);
        GWCTest.assertEquals((Object)expected2, (Object)actual2);
    }

    public void testIsInternalGridset() {
        Set embeddedNames = this.gridSetBroker.getEmbeddedNames();
        for (String name : embeddedNames) {
            GWCTest.assertTrue((boolean)this.mediator.isInternalGridSet(name));
        }
        GWCTest.assertFalse((boolean)this.mediator.isInternalGridSet("somethingelse"));
    }

    public void testDeleteCacheByGridSetId() throws Exception {
        Mockito.when((Object)this.storageBroker.deleteByGridSetId((String)Matchers.eq((Object)"layer"), (String)Matchers.eq((Object)"gset1"))).thenThrow(new Throwable[]{new StorageException("fake")});
        try {
            this.mediator.deleteCacheByGridSetId("layer", "gset1");
            GWCTest.fail();
        }
        catch (RuntimeException e) {
            GWCTest.assertTrue((boolean)true);
        }
        this.mediator.deleteCacheByGridSetId("layer", "gset2");
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)1))).deleteByGridSetId((String)Matchers.eq((Object)"layer"), (String)Matchers.eq((Object)"gset2"));
    }

    public void testDestroy() throws Exception {
        this.mediator.destroy();
        ArgumentCaptor captor = ArgumentCaptor.forClass(CatalogListener.class);
        ((Catalog)Mockito.verify((Object)this.catalog, (VerificationMode)Mockito.times((int)2))).removeListener((CatalogListener)captor.capture());
        for (CatalogListener captured : captor.getAllValues()) {
            GWCTest.assertTrue((captured instanceof CatalogLayerEventListener || captured instanceof CatalogStyleChangeListener ? 1 : 0) != 0);
        }
    }

    public void testTruncateLayerFully() throws Exception {
        Mockito.when((Object)this.tld.getTileLayer((String)Matchers.eq((Object)this.tileLayerGroup.getName()))).thenThrow(new Throwable[]{new GeoWebCacheException("fake")});
        this.mediator.truncate(this.tileLayerGroup.getName());
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.never())).deleteByGridSetId(Matchers.anyString(), Matchers.anyString());
        this.mediator.truncate(this.tileLayer.getName());
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)this.tileLayer.getGridSubsets().size()))).deleteByGridSetId(Matchers.anyString(), Matchers.anyString());
    }

    public void testTruncateByLayerAndStyle() throws Exception {
        String layerName = this.tileLayer.getName();
        String styleName = "notACachedStyle";
        this.mediator.truncateByLayerAndStyle(layerName, styleName);
        ((TileBreeder)Mockito.verify((Object)this.tileBreeder, (VerificationMode)Mockito.never())).dispatchTasks((GWCTask[])Matchers.any(GWCTask[].class));
        styleName = this.layer.getDefaultStyle().getName();
        this.mediator.truncateByLayerAndStyle(layerName, styleName);
        int expected = this.tileLayer.getGridSubsets().size() * this.tileLayer.getMimeTypes().size();
        ((TileBreeder)Mockito.verify((Object)this.tileBreeder, (VerificationMode)Mockito.times((int)expected))).dispatchTasks((GWCTask[])Matchers.any(GWCTask[].class));
    }

    public void testTruncateByBounds() throws Exception {
        String layerName = this.tileLayer.getName();
        ReferencedEnvelope bounds = new ReferencedEnvelope(10.0, 20.0, 10.0, 20.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        BoundingBox layerBounds = this.tileLayer.getGridSubset("EPSG:4326").getGridSet().getOriginalExtent();
        GWCTest.assertFalse((boolean)bounds.intersects(layerBounds.getMinX(), layerBounds.getMinY()));
        GWCTest.assertFalse((boolean)bounds.intersects(layerBounds.getMaxX(), layerBounds.getMaxY()));
        this.mediator.truncate(layerName, bounds);
        ((TileBreeder)Mockito.verify((Object)this.tileBreeder, (VerificationMode)Mockito.never())).dispatchTasks((GWCTask[])Matchers.any(GWCTask[].class));
        bounds = new ReferencedEnvelope(-10.0, -10.0, 10.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.mediator.truncate(layerName, bounds);
        int numGridsets = this.tileLayer.getGridSubsets().size();
        int numFormats = this.tileLayer.getMimeTypes().size();
        int numStyles = 1 + this.tileLayer.getInfo().cachedStyles().size();
        int expected = numGridsets * numFormats * numStyles;
        ((TileBreeder)Mockito.verify((Object)this.tileBreeder, (VerificationMode)Mockito.times((int)expected))).dispatchTasks((GWCTask[])Matchers.any(GWCTask[].class));
        Mockito.reset((Object[])new TileBreeder[]{this.tileBreeder});
        bounds = bounds.transform(CRS.decode((String)"EPSG:900913"), true);
        this.mediator.truncate(layerName, bounds);
        ((TileBreeder)Mockito.verify((Object)this.tileBreeder, (VerificationMode)Mockito.times((int)expected))).dispatchTasks((GWCTask[])Matchers.any(GWCTask[].class));
        Mockito.reset((Object[])new TileBreeder[]{this.tileBreeder});
        bounds = this.mediator.getAreaOfValidity(CRS.decode((String)"EPSG:2083"));
        this.mediator.truncate(layerName, bounds);
        ((TileBreeder)Mockito.verify((Object)this.tileBreeder, (VerificationMode)Mockito.never())).dispatchTasks((GWCTask[])Matchers.any(GWCTask[].class));
        Mockito.reset((Object[])new TileBreeder[]{this.tileBreeder});
        bounds = this.mediator.getAreaOfValidity(CRS.decode((String)"EPSG:26986"));
        this.mediator.truncate(layerName, bounds);
        ((TileBreeder)Mockito.verify((Object)this.tileBreeder, (VerificationMode)Mockito.times((int)expected))).dispatchTasks((GWCTask[])Matchers.any(GWCTask[].class));
    }

    public void testLayerRemoved() throws Exception {
        this.mediator.layerRemoved("someLayer");
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)1))).delete((String)Matchers.eq((Object)"someLayer"));
        ((StorageBroker)Mockito.doThrow((Throwable)new StorageException("fake")).when((Object)this.storageBroker)).delete((String)Matchers.eq((Object)"anotherLayer"));
        try {
            this.mediator.layerRemoved("anotherLayer");
            GWCTest.fail((String)"Expected RTE");
        }
        catch (RuntimeException e) {
            GWCTest.assertTrue((boolean)(e.getCause() instanceof StorageException));
        }
    }

    public void testLayerAdded() throws Exception {
        Mockito.when((Object)this.diskQuotaMonitor.isEnabled()).thenReturn((Object)false);
        this.mediator.layerAdded("someLayer");
        ((QuotaStore)Mockito.verify((Object)this.quotaStore, (VerificationMode)Mockito.never())).createLayer(Matchers.anyString());
        Mockito.when((Object)this.diskQuotaMonitor.isEnabled()).thenReturn((Object)true);
        this.mediator.layerAdded("someLayer");
        ((QuotaStore)Mockito.verify((Object)this.quotaStore, (VerificationMode)Mockito.times((int)1))).createLayer((String)Matchers.eq((Object)"someLayer"));
        ((QuotaStore)Mockito.doThrow((Throwable)new InterruptedException("fake")).when((Object)this.quotaStore)).createLayer((String)Matchers.eq((Object)"someLayer"));
        try {
            this.mediator.layerAdded("someLayer");
            GWCTest.fail((String)"Expected RTE");
        }
        catch (RuntimeException e) {
            GWCTest.assertTrue((boolean)(e.getCause() instanceof InterruptedException));
        }
    }

    public void testLayerRenamed() throws Exception {
        this.mediator.layerRenamed("old", "new");
        ((StorageBroker)Mockito.verify((Object)this.storageBroker, (VerificationMode)Mockito.times((int)1))).rename((String)Matchers.eq((Object)"old"), (String)Matchers.eq((Object)"new"));
        ((StorageBroker)Mockito.doThrow((Throwable)new StorageException("target directory already exists")).when((Object)this.storageBroker)).rename((String)Matchers.eq((Object)"old"), (String)Matchers.eq((Object)"new"));
        try {
            this.mediator.layerRenamed("old", "new");
            GWCTest.fail((String)"Expected RTE");
        }
        catch (RuntimeException e) {
            GWCTest.assertTrue((boolean)(e.getCause() instanceof StorageException));
        }
    }

    public void testReload() throws Exception {
        this.mediator.reload();
        ((TileLayerDispatcher)Mockito.verify((Object)this.tld, (VerificationMode)Mockito.times((int)1))).reInit();
        ((TileLayerDispatcher)Mockito.doThrow((Throwable)new RuntimeException("fake")).when((Object)this.tld)).reInit();
        try {
            this.mediator.reload();
            GWCTest.fail((String)"Expected RTE");
        }
        catch (RuntimeException e) {
            GWCTest.assertTrue((boolean)true);
        }
    }

    public void testReloadAndLayerRemovedExternally() throws Exception {
        final String removedLayer = this.tileLayer.getName();
        String remainingLayer = this.tileLayerGroup.getName();
        final HashSet layerNames = Sets.newHashSet((Object[])new String[]{removedLayer, remainingLayer});
        Mockito.when((Object)this.tld.getLayerNames()).thenReturn((Object)layerNames);
        ((TileLayerDispatcher)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                layerNames.remove(removedLayer);
                return null;
            }
        }).when((Object)this.tld)).reInit();
        ArgumentCaptor argCaptor = ArgumentCaptor.forClass(String.class);
        this.mediator = (GWC)Mockito.spy((Object)this.mediator);
        ((GWC)Mockito.doReturn((Object)true).when((Object)this.mediator)).layerRemoved((String)argCaptor.capture());
        this.mediator.reload();
        ((TileLayerDispatcher)Mockito.verify((Object)this.tld, (VerificationMode)Mockito.times((int)1))).reInit();
        GWCTest.assertEquals((int)1, (int)argCaptor.getAllValues().size());
        GWCTest.assertEquals((String)removedLayer, (String)((String)argCaptor.getValue()));
    }

    public void testIsServiceEnabled() {
        Service service = (Service)Mockito.mock(Service.class);
        Mockito.when((Object)service.getPathName()).thenReturn((Object)"wms");
        this.defaults.setWMSCEnabled(true);
        GWCTest.assertTrue((boolean)this.mediator.isServiceEnabled(service));
        this.defaults.setWMSCEnabled(false);
        GWCTest.assertFalse((boolean)this.mediator.isServiceEnabled(service));
        Mockito.when((Object)service.getPathName()).thenReturn((Object)"tms");
        this.defaults.setTMSEnabled(true);
        GWCTest.assertTrue((boolean)this.mediator.isServiceEnabled(service));
        this.defaults.setTMSEnabled(false);
        GWCTest.assertFalse((boolean)this.mediator.isServiceEnabled(service));
        Mockito.when((Object)service.getPathName()).thenReturn((Object)"wmts");
        this.defaults.setWMTSEnabled(true);
        GWCTest.assertTrue((boolean)this.mediator.isServiceEnabled(service));
        this.defaults.setWMTSEnabled(false);
        GWCTest.assertFalse((boolean)this.mediator.isServiceEnabled(service));
        Mockito.when((Object)service.getPathName()).thenReturn((Object)"somethingElse");
        GWCTest.assertTrue((boolean)this.mediator.isServiceEnabled(service));
    }

    public void testDispatchGetMapDoesntMatchTileCache() throws Exception {
        GetMapRequest request = new GetMapRequest();
        CaseInsensitiveMap rawKvp = new CaseInsensitiveMap(new HashMap());
        request.setRawKvp((Map)rawKvp);
        rawKvp.put("layers", "more,than,one,layer");
        this.assertDispatchMismatch(request, "more than one layer requested");
        rawKvp.put("layers", "SomeNonCachedLayer");
        Mockito.when((Object)this.tld.getTileLayer((String)Matchers.eq((Object)"SomeNonCachedLayer"))).thenThrow(new Throwable[]{new GeoWebCacheException("layer not found")});
        this.assertDispatchMismatch(request, "not a tile layer");
        rawKvp.put("layers", this.tileLayer.getName());
        request.setFormat("badFormat");
        this.assertDispatchMismatch(request, "not a GWC supported format");
        request.setFormat("image/gif");
        this.assertDispatchMismatch(request, "no tile cache for requested format");
        request.setFormat(((MimeType)this.tileLayer.getMimeTypes().get(0)).getMimeType());
        request.setSRS("EPSG:4326");
        request.setBbox(new Envelope(10.0, 10.0, 20.0, 20.0));
        this.assertDispatchMismatch(request, "request does not align to grid");
        request.setSRS("EPSG:23036");
        this.assertDispatchMismatch(request, "no cache exists for requested CRS");
        request.setSRS("badCRS");
        this.assertDispatchMismatch(request, "exception occurred");
        request.setSRS("EPSG:4326");
        request.setWidth(128);
        request.setHeight(256);
        this.assertDispatchMismatch(request, "request does not align to grid");
        request.setWidth(256);
        request.setHeight(128);
        this.assertDispatchMismatch(request, "request does not align to grid");
        request.setSRS("EPSG:4326");
        request.setWidth(256);
        request.setHeight(256);
        this.assertDispatchMismatch(request, "request does not align to grid");
    }

    public void testDispatchGetMapNonMatchingParameterFilter() throws Exception {
        GetMapRequest request = new GetMapRequest();
        CaseInsensitiveMap rawKvp = new CaseInsensitiveMap(new HashMap());
        request.setRawKvp((Map)rawKvp);
        rawKvp.put("layers", this.tileLayer.getName());
        this.tileLayer.setEnabled(false);
        this.assertDispatchMismatch(request, "tile layer disabled");
        this.tileLayer.setEnabled(true);
        GWCTest.assertTrue((boolean)this.layer.enabled());
        request.setRemoteOwsURL(new URL("http://example.com"));
        this.assertDispatchMismatch(request, "remote OWS");
        request.setRemoteOwsURL(null);
        request.setRemoteOwsType("WFS");
        this.assertDispatchMismatch(request, "remote OWS");
        request.setRemoteOwsType(null);
        request.setEnv((Map)ImmutableMap.of((Object)"envVar", (Object)"envValue"));
        this.assertDispatchMismatch(request, "no parameter filter exists for ENV");
        request.setEnv(null);
        request.setFormatOptions((Map)ImmutableMap.of((Object)"optKey", (Object)"optVal"));
        this.assertDispatchMismatch(request, "no parameter filter exists for FORMAT_OPTIONS");
        request.setFormatOptions(null);
        request.setAngle(45.0);
        this.assertDispatchMismatch(request, "no parameter filter exists for ANGLE");
        request.setAngle(0.0);
        rawKvp.put("BGCOLOR", "0xAA0000");
        this.assertDispatchMismatch(request, "no parameter filter exists for BGCOLOR");
        rawKvp.remove("BGCOLOR");
        request.setBuffer(10);
        this.assertDispatchMismatch(request, "no parameter filter exists for BUFFER");
        request.setBuffer(0);
        request.setCQLFilter(Arrays.asList(CQL.toFilter((String)"ATT = 1")));
        this.assertDispatchMismatch(request, "no parameter filter exists for CQL_FILTER");
        request.setCQLFilter(null);
        request.setElevation(10.0);
        this.assertDispatchMismatch(request, "no parameter filter exists for ELEVATION");
        request.setElevation(Collections.emptyList());
        request.setFeatureId(Arrays.asList(new FeatureIdImpl("someid")));
        this.assertDispatchMismatch(request, "no parameter filter exists for FEATUREID");
        request.setFeatureId(null);
        request.setFilter(Arrays.asList(CQL.toFilter((String)"ATT = 1")));
        this.assertDispatchMismatch(request, "no parameter filter exists for FILTER");
        request.setFilter(null);
        request.setPalette(PaletteManager.getPalette((String)"SAFE"));
        this.assertDispatchMismatch(request, "no parameter filter exists for PALETTE");
        request.setPalette(null);
        request.setStartIndex(Integer.valueOf(10));
        this.assertDispatchMismatch(request, "no parameter filter exists for STARTINDEX");
        request.setStartIndex(null);
        request.setMaxFeatures(Integer.valueOf(1));
        this.assertDispatchMismatch(request, "no parameter filter exists for MAXFEATURES");
        request.setMaxFeatures(null);
        request.setTime(Arrays.asList(1, 2));
        this.assertDispatchMismatch(request, "no parameter filter exists for TIME");
        request.setTime(Collections.emptyList());
        ImmutableList viewParams = ImmutableList.of((Object)ImmutableMap.of((Object)"paramKey", (Object)"paramVal"));
        request.setViewParams((List)viewParams);
        this.assertDispatchMismatch(request, "no parameter filter exists for VIEWPARAMS");
        request.setViewParams(null);
        request.setFeatureVersion("@version");
        this.assertDispatchMismatch(request, "no parameter filter exists for FEATUREVERSION");
        request.setFeatureVersion(null);
    }

    public void testNullsInDimensionAndTimeParameters() throws Exception {
        TileLayerInfoUtil.updateAcceptAllFloatParameterFilter((GeoServerTileLayerInfo)this.tileLayerInfo, (String)"ELEVATION", (boolean)true);
        TileLayerInfoUtil.updateAcceptAllRegExParameterFilter((GeoServerTileLayerInfo)this.tileLayerInfo, (String)"TIME", (boolean)true);
        this.tileLayer = new GeoServerTileLayer(this.layer, this.gridSetBroker, this.tileLayerInfo);
        GetMapRequest request = new GetMapRequest();
        CaseInsensitiveMap rawKvp = new CaseInsensitiveMap(new HashMap());
        request.setRawKvp((Map)rawKvp);
        StringBuilder target = new StringBuilder();
        request.setElevation(Arrays.asList(new Object[]{null}));
        boolean cachingPossible = this.mediator.isCachingPossible((TileLayer)this.tileLayer, request, target);
        GWCTest.assertTrue((boolean)cachingPossible);
        GWCTest.assertEquals((int)0, (int)target.length());
        request.setElevation(Collections.emptyList());
        request.setTime(Arrays.asList(new Object[]{null}));
        cachingPossible = this.mediator.isCachingPossible((TileLayer)this.tileLayer, request, target);
        GWCTest.assertTrue((boolean)cachingPossible);
        GWCTest.assertEquals((int)0, (int)target.length());
    }

    private void assertDispatchMismatch(GetMapRequest request, String expectedReason) {
        StringBuilder target = new StringBuilder();
        GWCTest.assertNull((Object)this.mediator.dispatch(request, target));
        GWCTest.assertTrue((String)("mismatch reason '" + target + "' does not contain '" + expectedReason + "'"), (boolean)target.toString().contains(expectedReason));
    }

    public void testDispatchGetMapMultipleCrsMatchingGridSubsets() throws Exception {
        this.testMultipleCrsMatchingGridSubsets("EPSG:4326", "EPSG:4326", new long[]{1L, 1L, 1L});
        this.testMultipleCrsMatchingGridSubsets("EPSG:4326", "EPSG:4326", new long[]{10L, 10L, 10L});
        this.testMultipleCrsMatchingGridSubsets("EPSG:4326", "GlobalCRS84Scale", new long[]{1L, 1L, 1L});
        this.testMultipleCrsMatchingGridSubsets("EPSG:4326", "GlobalCRS84Scale", new long[]{10L, 10L, 10L});
        this.testMultipleCrsMatchingGridSubsets("EPSG:4326", "GlobalCRS84Scale", new long[]{1L, 1L, 1L});
        this.testMultipleCrsMatchingGridSubsets("EPSG:4326", "GlobalCRS84Scale", new long[]{10L, 10L, 10L});
    }

    private void testMultipleCrsMatchingGridSubsets(String srs, String expectedGridset, long[] tileIndex) throws Exception {
        GetMapRequest request = new GetMapRequest();
        CaseInsensitiveMap rawKvp = new CaseInsensitiveMap(new HashMap());
        request.setRawKvp((Map)rawKvp);
        request.setFormat("image/png");
        request.setSRS(srs);
        request.setWidth(256);
        request.setHeight(256);
        rawKvp.put("layers", "mockLayer");
        List<String> gridSetNames = Arrays.asList("GlobalCRS84Pixel", "GlobalCRS84Scale", "EPSG:4326");
        this.tileLayer = this.mockTileLayer("mockLayer", gridSetNames);
        BoundingBox bounds = this.tileLayer.getGridSubset(expectedGridset).boundsFromIndex(tileIndex);
        Envelope reqBbox = new Envelope(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY());
        request.setBbox(reqBbox);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ConveyorTile.class);
        StringBuilder errors = new StringBuilder();
        this.mediator.dispatch(request, errors);
        GWCTest.assertTrue((String)errors.toString(), (errors.length() == 0 ? 1 : 0) != 0);
        ((GeoServerTileLayer)Mockito.verify((Object)this.tileLayer, (VerificationMode)Mockito.times((int)1))).getTile((ConveyorTile)captor.capture());
        ConveyorTile tileRequest = (ConveyorTile)captor.getValue();
        GWCTest.assertEquals((String)expectedGridset, (String)tileRequest.getGridSetId());
        GWCTest.assertEquals((String)"image/png", (String)tileRequest.getMimeType().getMimeType());
        GWCTest.assertTrue((String)("Expected " + Arrays.toString(tileIndex) + " got " + Arrays.toString(tileRequest.getTileIndex())), (boolean)Arrays.equals(tileIndex, tileRequest.getTileIndex()));
    }

    private GeoServerTileLayer mockTileLayer(String layerName, List<String> gridSetNames) throws Exception {
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)Mockito.mock(GeoServerTileLayer.class);
        Mockito.when((Object)this.tld.layerExists((String)Matchers.eq((Object)layerName))).thenReturn((Object)true);
        Mockito.when((Object)this.tld.getTileLayer((String)Matchers.eq((Object)layerName))).thenReturn((Object)tileLayer);
        Mockito.when((Object)tileLayer.getName()).thenReturn((Object)layerName);
        Mockito.when((Object)tileLayer.isEnabled()).thenReturn((Object)true);
        MimeType mimeType1 = MimeType.createFromFormat((String)"image/png");
        MimeType mimeType2 = MimeType.createFromFormat((String)"image/jpeg");
        Mockito.when((Object)tileLayer.getMimeTypes()).thenReturn((Object)ImmutableList.of((Object)mimeType1, (Object)mimeType2));
        HashMap subsets = Maps.newHashMap();
        LinkedHashMultimap bySrs = LinkedHashMultimap.create();
        GridSetBroker broker = this.gridSetBroker;
        for (String gsetName : gridSetNames) {
            GridSet gridSet = broker.get(gsetName);
            XMLGridSubset xmlGridSubset = new XMLGridSubset();
            String gridSetName = gridSet.getName();
            xmlGridSubset.setGridSetName(gridSetName);
            GridSubset gridSubSet = xmlGridSubset.getGridSubSet(broker);
            subsets.put(gsetName, gridSubSet);
            bySrs.put((Object)gridSet.getSrs(), (Object)gridSubSet);
            Mockito.when((Object)tileLayer.getGridSubset((String)Matchers.eq((Object)gsetName))).thenReturn((Object)gridSubSet);
        }
        for (SRS srs : bySrs.keySet()) {
            ImmutableList list = ImmutableList.copyOf((Collection)bySrs.get((Object)srs));
            Mockito.when((Object)tileLayer.getGridSubsetsForSRS((SRS)Matchers.eq((Object)srs))).thenReturn((Object)list);
        }
        Mockito.when((Object)tileLayer.getGridSubsets()).thenReturn(subsets.keySet());
        for (String gsetName : gridSetNames) {
            GWCTest.assertTrue((boolean)tileLayer.getGridSubsets().contains(gsetName));
            GWCTest.assertNotNull((Object)tileLayer.getGridSubset(gsetName));
        }
        return tileLayer;
    }

    public void testDispatchGetMapWithMatchingParameterFilters() throws Exception {
        GetMapRequest request = new GetMapRequest();
        CaseInsensitiveMap rawKvp = new CaseInsensitiveMap(new HashMap());
        request.setRawKvp((Map)rawKvp);
        request.setFormat("image/png");
        request.setSRS("EPSG:900913");
        request.setWidth(256);
        request.setHeight(256);
        rawKvp.put("layers", this.tileLayer.getName());
        BoundingBox bounds = this.tileLayer.getGridSubset("EPSG:900913").boundsFromIndex(new long[]{0L, 0L, 1L});
        Envelope reqBbox = new Envelope(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY());
        request.setBbox(reqBbox);
        GWCTest.assertTrue((this.tileLayer.getInfo().cachedStyles().size() > 0 ? 1 : 0) != 0);
        for (String style : this.tileLayer.getInfo().cachedStyles()) {
            String rawKvpParamName = "styles";
            String rawKvpParamValue = style;
            this.testParameterFilter(request, (Map<String, String>)rawKvp, rawKvpParamName, rawKvpParamValue);
        }
        request.setEnv((Map)ImmutableMap.of((Object)"envKey", (Object)"envValue"));
        TileLayerInfoUtil.updateStringParameterFilter((GeoServerTileLayerInfo)this.tileLayerInfo, (String)"ENV", (boolean)true, (String)"def:devVal", (String[])new String[]{"envKey:envValue", "envKey2:envValue2"});
        this.testParameterFilter(request, (Map<String, String>)rawKvp, "env", "envKey:envValue");
        TileLayerInfoUtil.updateAcceptAllFloatParameterFilter((GeoServerTileLayerInfo)this.tileLayerInfo, (String)"ANGLE", (boolean)true);
        request.setAngle(60.0);
        this.testParameterFilter(request, (Map<String, String>)rawKvp, "angle", "60.0");
        request.setAngle(61.1);
        this.testParameterFilter(request, (Map<String, String>)rawKvp, "angle", "61.1");
    }

    private void testParameterFilter(GetMapRequest request, Map<String, String> rawKvp, String rawKvpParamName, String rawKvpParamValue) {
        rawKvp.put(rawKvpParamName, rawKvpParamValue);
        StringBuilder errors = new StringBuilder();
        ConveyorTile tileRequest = this.mediator.prepareRequest((TileLayer)this.tileLayer, request, errors);
        GWCTest.assertTrue((String)errors.toString(), (errors.length() == 0 ? 1 : 0) != 0);
        Map fullParameters = tileRequest.getFullParameters();
        GWCTest.assertEquals((String)fullParameters.toString(), (String)rawKvpParamValue, (String)((String)fullParameters.get(rawKvpParamName.toUpperCase())));
    }
}

