/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpServletResponse;
import java.io.Serializable;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import junit.framework.Test;
import org.apache.commons.httpclient.util.DateUtil;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.CatalogConfiguration;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.test.GeoServerTestSupport;
import org.geoserver.test.OneTimeSetupTest;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeType;

public class GWCIntegrationTest
extends GeoServerTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GWCIntegrationTest());
    }

    protected void setUpInternal() {
        GWC.get().getConfig().setDirectWMSIntegrationEnabled(false);
    }

    public void testPngIntegration() throws Exception {
        String layerId = this.getLayerId(MockData.BASIC_POLYGONS);
        MockHttpServletResponse sr = this.getAsServletResponse("gwc/service/wmts?request=GetTile&layer=" + layerId + "&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0");
        GWCIntegrationTest.assertEquals((int)200, (int)sr.getErrorCode());
        GWCIntegrationTest.assertEquals((String)"image/png", (String)sr.getContentType());
    }

    public void testDirectWMSIntegration() throws Exception {
        GWC gwc = GWC.get();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String request = this.buildGetMap(true, layerName, "EPSG:4326", null);
        MockHttpServletResponse response = this.getAsServletResponse(request);
        GWCIntegrationTest.assertEquals((int)200, (int)response.getStatusCode());
        GWCIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
        GWCIntegrationTest.assertNull((Object)response.getHeader("geowebcache-tile-index"));
        request = request + "&tiled=true";
        response = this.getAsServletResponse(request);
        GWCIntegrationTest.assertEquals((int)200, (int)response.getErrorCode());
        GWCIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
    }

    public void testDirectWMSIntegrationResponseHeaders() throws Exception {
        GWC gwc = GWC.get();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String request = this.buildGetMap(true, layerName, "EPSG:4326", null) + "&tiled=true";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        GWCIntegrationTest.assertEquals((int)200, (int)response.getStatusCode());
        GWCIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
        GWCIntegrationTest.assertEquals((String)layerName, (String)response.getHeader("geowebcache-layer"));
        GWCIntegrationTest.assertEquals((String)"[0, 0, 0]", (String)response.getHeader("geowebcache-tile-index"));
        GWCIntegrationTest.assertEquals((String)"-180.0,-90.0,0.0,90.0", (String)response.getHeader("geowebcache-tile-bounds"));
        GWCIntegrationTest.assertEquals((String)"EPSG:4326", (String)response.getHeader("geowebcache-gridset"));
        GWCIntegrationTest.assertEquals((String)"EPSG:4326", (String)response.getHeader("geowebcache-crs"));
    }

    public void testDirectWMSIntegrationIfModifiedSinceSupport() throws Exception {
        GWC gwc = GWC.get();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String path = this.buildGetMap(true, layerName, "EPSG:4326", null) + "&tiled=true";
        MockHttpServletResponse response = this.getAsServletResponse(path);
        GWCIntegrationTest.assertEquals((int)200, (int)response.getStatusCode());
        GWCIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
        String lastModifiedHeader = response.getHeader("Last-Modified");
        GWCIntegrationTest.assertNotNull((Object)lastModifiedHeader);
        Date lastModified = DateUtil.parseDate((String)lastModifiedHeader);
        MockHttpServletRequest httpReq = this.createRequest(path);
        httpReq.setMethod("GET");
        httpReq.setBodyContent(new byte[0]);
        httpReq.setHeader("If-Modified-Since", lastModifiedHeader);
        response = this.dispatch((HttpServletRequest)httpReq, "UTF-8");
        GWCIntegrationTest.assertEquals((int)304, (int)response.getErrorCode());
        Date past = new Date(lastModified.getTime() - 5000L);
        String ifModifiedSince = DateUtil.formatDate((Date)past);
        httpReq.setHeader("If-Modified-Since", ifModifiedSince);
        response = this.dispatch((HttpServletRequest)httpReq, "UTF-8");
        GWCIntegrationTest.assertEquals((int)200, (int)response.getErrorCode());
        Date future = new Date(lastModified.getTime() + 5000L);
        ifModifiedSince = DateUtil.formatDate((Date)future);
        httpReq.setHeader("If-Modified-Since", ifModifiedSince);
        response = this.dispatch((HttpServletRequest)httpReq, "UTF-8");
        GWCIntegrationTest.assertEquals((int)304, (int)response.getErrorCode());
    }

    public void testDirectWMSIntegrationMaxAge() throws Exception {
        GWC gwc = GWC.get();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String path = this.buildGetMap(true, layerName, "EPSG:4326", null) + "&tiled=true";
        String qualifiedName = super.getLayerId(MockData.BASIC_POLYGONS);
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)gwc.getTileLayerByName(qualifiedName);
        tileLayer.getLayerInfo().getResource().getMetadata().put("cachingEnabled", (Serializable)((Object)"true"));
        tileLayer.getLayerInfo().getResource().getMetadata().put("cacheAgeMax", (Serializable)Integer.valueOf(3456));
        MockHttpServletResponse response = this.getAsServletResponse(path);
        String cacheControl = response.getHeader("Cache-Control");
        GWCIntegrationTest.assertEquals((String)"max-age=3456", (String)cacheControl);
        GWCIntegrationTest.assertNotNull((Object)response.getHeader("Last-Modified"));
        tileLayer.getLayerInfo().getResource().getMetadata().put("cachingEnabled", (Serializable)((Object)"false"));
        response = this.getAsServletResponse(path);
        cacheControl = response.getHeader("Cache-Control");
        GWCIntegrationTest.assertEquals((String)"no-cache", (String)cacheControl);
        tileLayer.getLayerInfo().getResource().getMetadata().put("cachingEnabled", (Serializable)Boolean.FALSE);
        response = this.getAsServletResponse(path);
        cacheControl = response.getHeader("Cache-Control");
        GWCIntegrationTest.assertEquals((String)"no-cache", (String)cacheControl);
    }

    public void testDirectWMSIntegrationWithVirtualServices() throws Exception {
        GWC gwc = GWC.get();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String qualifiedName = super.getLayerId(MockData.BASIC_POLYGONS);
        String localName = MockData.BASIC_POLYGONS.getLocalPart();
        TileLayer tileLayer = gwc.getTileLayerByName(qualifiedName);
        GWCIntegrationTest.assertNotNull((Object)tileLayer);
        boolean directWMSIntegrationEndpoint = true;
        String request = MockData.CITE_PREFIX + "/" + this.buildGetMap(directWMSIntegrationEndpoint, localName, "EPSG:4326", null, tileLayer) + "&tiled=true";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        GWCIntegrationTest.assertEquals((int)200, (int)response.getStatusCode());
        GWCIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
        GWCIntegrationTest.assertEquals((String)qualifiedName, (String)response.getHeader("geowebcache-layer"));
    }

    public void testDirectWMSIntegrationWithVirtualServicesHiddenLayer() throws Exception {
        GWC gwc = GWC.get();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String qualifiedName = super.getLayerId(MockData.BASIC_POLYGONS);
        String localName = MockData.BASIC_POLYGONS.getLocalPart();
        TileLayer tileLayer = gwc.getTileLayerByName(qualifiedName);
        GWCIntegrationTest.assertNotNull((Object)tileLayer);
        boolean directWMSIntegrationEndpoint = true;
        String request = MockData.CDF_PREFIX + "/" + this.buildGetMap(directWMSIntegrationEndpoint, localName, "EPSG:4326", null, tileLayer) + "&tiled=true";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        GWCIntegrationTest.assertEquals((int)200, (int)response.getStatusCode());
        GWCIntegrationTest.assertTrue((String)response.getContentType(), (boolean)response.getContentType().startsWith("application/vnd.ogc.se_xml"));
        GWCIntegrationTest.assertTrue((String)response.getOutputStreamContent(), (boolean)response.getOutputStreamContent().contains("Could not find layer cdf:BasicPolygons"));
    }

    public void testReloadConfiguration() throws Exception {
        String path = "/gwc/rest/reload";
        String content = "reload_configuration=1";
        String contentType = "application/x-www-form-urlencoded";
        MockHttpServletResponse response = this.postAsServletResponse(path, content, contentType);
        GWCIntegrationTest.assertEquals((int)200, (int)response.getStatusCode());
    }

    public void testBasicIntegration() throws Exception {
        Catalog cat = this.getCatalog();
        TileLayerDispatcher tld = (TileLayerDispatcher)GeoWebCacheExtensions.bean(TileLayerDispatcher.class);
        GWCIntegrationTest.assertNotNull((Object)tld);
        GridSetBroker gridSetBroker = (GridSetBroker)GeoWebCacheExtensions.bean(GridSetBroker.class);
        GWCIntegrationTest.assertNotNull((Object)gridSetBroker);
        try {
            tld.getTileLayer("");
        }
        catch (GeoWebCacheException gwce) {
            // empty catch block
        }
        boolean foundLakes = false;
        for (TileLayer tl : tld.getLayerList()) {
            if (!tl.getName().equals("cite:Lakes")) continue;
            foundLakes = true;
            break;
        }
        GWCIntegrationTest.assertTrue((boolean)foundLakes);
        boolean foudAGF = false;
        for (TileLayer tl : tld.getLayerList()) {
            if (!tl.getName().equals("sf:AggregateGeoFeature")) continue;
            foudAGF = true;
            GridSubset epsg4326 = tl.getGridSubset(gridSetBroker.WORLD_EPSG4326.getName());
            GWCIntegrationTest.assertTrue((boolean)epsg4326.getGridSetBounds().equals((Object)new BoundingBox(-180.0, -90.0, 180.0, 90.0)));
            String mime = ((MimeType)tl.getMimeTypes().get(1)).getMimeType();
            GWCIntegrationTest.assertTrue((mime.startsWith("image/") || mime.startsWith("application/vnd.google-earth.kml+xml") ? 1 : 0) != 0);
        }
        GWCIntegrationTest.assertTrue((boolean)foudAGF);
        LayerInfo li = (LayerInfo)cat.getLayers().get(1);
        String layerName = GWC.tileLayerName((LayerInfo)li);
        TileLayer tl = tld.getTileLayer(layerName);
        GWCIntegrationTest.assertEquals((String)layerName, (String)tl.getName());
        cat.remove(li);
        GWCIntegrationTest.assertNull((Object)cat.getLayerByName(tl.getName()));
        try {
            tld.getTileLayer(layerName);
            GWCIntegrationTest.fail((String)"Layer should not exist");
        }
        catch (GeoWebCacheException gwce) {
            GWCIntegrationTest.assertTrue((boolean)true);
        }
    }

    private String buildGetMap(boolean directWMSIntegrationEndpoint, String layerName, String gridsetId, String styles) {
        GWC gwc = GWC.get();
        TileLayer tileLayer = gwc.getTileLayerByName(layerName);
        return this.buildGetMap(directWMSIntegrationEndpoint, layerName, gridsetId, styles, tileLayer);
    }

    private String buildGetMap(boolean directWMSIntegrationEndpoint, String queryLayerName, String gridsetId, String styles, TileLayer tileLayer) {
        GridSubset gridSubset = tileLayer.getGridSubset(gridsetId);
        long[] coverage = gridSubset.getCoverage(0);
        long[] tileIndex = new long[]{coverage[0], coverage[1], coverage[4]};
        BoundingBox bounds = gridSubset.boundsFromIndex(tileIndex);
        String endpoint = directWMSIntegrationEndpoint ? "wms" : "gwc/service/wms";
        StringBuilder sb = new StringBuilder(endpoint);
        sb.append("?service=WMS&request=GetMap&version=1.1.1&format=image/png");
        sb.append("&layers=").append(queryLayerName);
        sb.append("&srs=").append(gridSubset.getSRS());
        sb.append("&width=").append(gridSubset.getGridSet().getTileWidth());
        sb.append("&height=").append(gridSubset.getGridSet().getTileHeight());
        sb.append("&styles=");
        if (styles != null) {
            sb.append(styles);
        }
        sb.append("&bbox=").append(bounds.toString());
        return sb.toString();
    }

    public void testMissingGeoServerLayerAtStartUp() throws Exception {
        Catalog catalog = this.getCatalog();
        GWC mediator = GWC.get();
        String layerName = this.getLayerId(MockData.BASIC_POLYGONS);
        LayerInfo layerInfo = catalog.getLayerByName(layerName);
        GWCIntegrationTest.assertNotNull((Object)layerInfo);
        TileLayer tileLayer = mediator.getTileLayerByName(layerName);
        GWCIntegrationTest.assertNotNull((Object)tileLayer);
        GWCIntegrationTest.assertTrue((boolean)tileLayer.isEnabled());
        MockData testData = this.getTestData();
        testData.removeFeatureType(MockData.BASIC_POLYGONS);
        this.getGeoServer().reload();
        GWCIntegrationTest.assertNull((Object)catalog.getLayerByName(layerName));
        CatalogConfiguration config = (CatalogConfiguration)GeoServerExtensions.bean(CatalogConfiguration.class);
        GWCIntegrationTest.assertNull((Object)config.getTileLayer(layerName));
        try {
            mediator.getTileLayerByName(layerName);
            GWCIntegrationTest.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            GWCIntegrationTest.assertTrue((boolean)true);
        }
    }

    public void testSaveConfig() throws Exception {
        GWCConfig config = GWC.get().getConfig();
        config.setGutter(100);
        GWC.get().saveConfig(config);
        this.getGeoServer().reload();
        GWCIntegrationTest.assertEquals((int)100, (int)GWC.get().getConfig().getGutter());
    }
}

