/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.svg;

import org.geoserver.platform.ExtensionFilter;
import org.geoserver.wms.WMS;
import org.geoserver.wms.svg.SVG;
import org.geoserver.wms.svg.SVGBatikMapOutputFormat;
import org.geoserver.wms.svg.SVGStreamingMapOutputFormat;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SVGStrategyExclusionFilter
implements ExtensionFilter,
ApplicationContextAware {
    private String wmsBeanName;
    private WMS wms;
    private ApplicationContext ctx;

    public SVGStrategyExclusionFilter(String wmsBeanName) {
        this.wmsBeanName = wmsBeanName;
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.ctx = ctx;
    }

    public boolean exclude(String beanId, Object bean) {
        boolean exclude = false;
        if (bean instanceof SVGStreamingMapOutputFormat) {
            exclude = !SVG.canHandle(this.getWMS(), "Simple");
        } else if (bean instanceof SVGBatikMapOutputFormat) {
            exclude = !SVG.canHandle(this.getWMS(), "Batik");
        }
        return exclude;
    }

    private WMS getWMS() {
        if (this.wms == null) {
            this.wms = (WMS)this.ctx.getBean(this.wmsBeanName);
        }
        return this.wms;
    }
}

