/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.opengis.wfs.FeatureCollectionType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.featureinfo.FreeMarkerTemplateManager;
import org.geoserver.wms.featureinfo.GetFeatureInfoOutputFormat;
import org.geoserver.wms.featureinfo.HTMLTemplateManager;
import org.geotools.feature.FeatureCollection;

public class HTMLFeatureInfoOutputFormat
extends GetFeatureInfoOutputFormat {
    private static final String FORMAT = "text/html";
    private FreeMarkerTemplateManager templateManager;
    private WMS wms;

    public HTMLFeatureInfoOutputFormat(WMS wms, GeoServerResourceLoader resourceLoader) {
        super(FORMAT);
        this.wms = wms;
        this.templateManager = new HTMLTemplateManager(FreeMarkerTemplateManager.OutputFormat.HTML, wms, resourceLoader);
    }

    @Override
    public void write(FeatureCollectionType results, GetFeatureInfoRequest request, OutputStream out) throws ServiceException, IOException {
        EList collections = results.getFeature();
        this.templateManager.write((List<FeatureCollection>)collections, out);
    }

    @Override
    public String getCharset() {
        return this.wms.getGeoServer().getSettings().getCharset();
    }

    public FreeMarkerTemplateManager getTemplateManager() {
        return this.templateManager;
    }
}

