/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.clip;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.BeanUtilsBean2;
import org.geoserver.ows.kvp.ClipGeometryParser;
import org.geoserver.wms.CachedGridReaderLayer;
import org.geoserver.wms.GetMapCallback;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.clip.ClippedFeatureSource;
import org.geoserver.wms.clip.CroppedGridCoverage2DReader;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.geometry.jts.JTS;
import org.geotools.map.FeatureLayer;
import org.geotools.map.GridReaderLayer;
import org.geotools.map.Layer;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public class ClipWMSGetMapCallBack
implements GetMapCallback {
    private static final Logger LOGGER = Logging.getLogger((String)ClipWMSGetMapCallBack.class.getName());

    @Override
    public GetMapRequest initRequest(GetMapRequest request) {
        return request;
    }

    @Override
    public void initMapContent(WMSMapContent mapContent) {
    }

    @Override
    public Layer beforeLayer(WMSMapContent mapContent, Layer layer) {
        Geometry wktGeom = mapContent.getRequest().getClip();
        if (wktGeom == null) {
            return layer;
        }
        Polygon bboxGeom = JTS.toGeometry((Envelope)mapContent.getRequest().getBbox());
        if (wktGeom.covers((Geometry)bboxGeom)) {
            return layer;
        }
        try {
            if (layer instanceof FeatureLayer) {
                FeatureLayer fl = (FeatureLayer)layer;
                ClippedFeatureSource clippedFS = new ClippedFeatureSource(layer.getFeatureSource(), wktGeom);
                FeatureLayer clippedLayer = new FeatureLayer(clippedFS, fl.getStyle(), fl.getTitle());
                BeanUtilsBean2.getInstance().copyProperties((Object)clippedLayer, (Object)fl);
                fl.getUserData().putAll(layer.getUserData());
                return clippedLayer;
            }
            if (layer instanceof GridReaderLayer) {
                GridReaderLayer gr = (GridReaderLayer)layer;
                CroppedGridCoverage2DReader croppedGridReader = new CroppedGridCoverage2DReader(gr.getReader(), wktGeom);
                CachedGridReaderLayer croppedGridLayer = new CachedGridReaderLayer((GridCoverage2DReader)croppedGridReader, layer.getStyle(), ((GridReaderLayer)layer).getParams());
                BeanUtilsBean2.getInstance().copyProperties((Object)croppedGridLayer, (Object)gr);
                croppedGridLayer.getUserData().putAll(layer.getUserData());
                return croppedGridLayer;
            }
        }
        catch (Exception e) {
            LOGGER.severe("Error occurred while clipping layer " + layer.getTitle());
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return layer;
        }
        return layer;
    }

    @Override
    public WMSMapContent beforeRender(WMSMapContent mapContent) {
        return mapContent;
    }

    @Override
    public WebMap finished(WebMap map) {
        return map;
    }

    @Override
    public void failed(Throwable t) {
    }

    public static synchronized Geometry readGeometry(String wkt, CoordinateReferenceSystem mapCRS) throws Exception {
        return ClipGeometryParser.readGeometry((String)wkt, (CoordinateReferenceSystem)mapCRS);
    }
}

