/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.sld;

import java.io.IOException;
import java.util.ArrayList;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.sld.GetStylesRequest;
import org.geoserver.wms.WMS;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.StyledLayer;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;

public class GetStyles {
    private final WMS wms;

    public GetStyles(WMS wms) {
        this.wms = wms;
    }

    public StyledLayerDescriptor run(GetStylesRequest request) throws ServiceException {
        if (request.getSldVer() != null && "".equals(request.getSldVer()) && !"1.0.0".equals(request.getSldVer())) {
            throw new ServiceException("SLD version " + request.getSldVer() + " not supported");
        }
        try {
            StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
            ArrayList<NamedLayer> layers = new ArrayList<NamedLayer>();
            for (String layerName : request.getLayers()) {
                NamedLayer namedLayer = factory.createNamedLayer();
                layers.add(namedLayer);
                namedLayer.setName(layerName);
                LayerGroupInfo group = this.wms.getLayerGroupByName(layerName);
                LayerInfo layer = this.wms.getLayerByName(layerName);
                if (group != null) continue;
                if (layer != null) {
                    Style style = layer.getDefaultStyle().getStyle();
                    style = this.cloneStyle(style);
                    style.setDefault(true);
                    style.setName(layer.getDefaultStyle().getName());
                    namedLayer.styles().add(style);
                    for (StyleInfo si : layer.getStyles()) {
                        style = this.cloneStyle(si.getStyle());
                        style.setName(si.getName());
                        namedLayer.styles().add(style);
                    }
                    continue;
                }
                throw new ServiceException("Unknown layer " + layerName);
            }
            StyledLayerDescriptor sld = factory.createStyledLayerDescriptor();
            sld.setStyledLayers(layers.toArray(new StyledLayer[layers.size()]));
            return sld;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private Style cloneStyle(Style style) {
        DuplicatingStyleVisitor cloner = new DuplicatingStyleVisitor();
        style.accept((StyleVisitor)cloner);
        style = (Style)cloner.getCopy();
        return style;
    }
}

