/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_3;

import java.io.IOException;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.LegendInfoImpl;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.junit.Test;
import org.w3c.dom.Document;

public class LegendCapabilitiesTest
extends WMSTestSupport {
    private static final String CAPABILITIES_REQUEST = "wms?request=getCapabilities&version=1.3.0";
    private static final String LAYER_NAME = "watertemp";
    private static final String HTTP_LEGEND_LAYER = "watertemp_http_legend";
    private static final QName LAYER_QNAME = new QName(MockData.DEFAULT_URI, "watertemp", MockData.DEFAULT_PREFIX);
    private static final QName LAYER_QNAME_HTP_LEGND = new QName(MockData.DEFAULT_URI, "watertemp_http_legend", MockData.DEFAULT_PREFIX);
    private static final String LAYER_FILE = "custwatertemp.zip";
    private static final String STYLE_NAME = "temperature";
    private static final String STYLE_NAME_HTTP = "temperature_http_url";
    private static final String STYLE_FILE = "../temperature.sld";
    private static final int LEGEND_WIDTH = 22;
    private static final int LEGEND_HEIGHT = 22;
    private static final String LEGEND_FORMAT = "image/jpeg";
    private static final String IMAGE_URL = "legend.png";
    private static final String IMAGE_HTTP_URL = "http://some.url.com/legend.png";
    private static final String BASE = "src/test/resources/geoserver";
    private static final String LAYER_NAME_WS = "watertemp_ws";
    private static final QName LAYER_QNAME_WS = new QName(MockData.DEFAULT_URI, "watertemp_ws", MockData.DEFAULT_PREFIX);
    private static final String STYLE_NAME_WS = "temperature_ws";

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        LegendInfoImpl legend = new LegendInfoImpl();
        legend.setWidth(22);
        legend.setHeight(22);
        legend.setFormat(LEGEND_FORMAT);
        legend.setOnlineResource(IMAGE_URL);
        Resource resource = this.getResourceLoader().get("styles/legend.png");
        this.getResourceLoader().copyFromClassPath("../legend.png", resource.file(), ((Object)((Object)this)).getClass());
        testData.addStyle(null, STYLE_NAME, STYLE_FILE, ((Object)((Object)this)).getClass(), this.getCatalog(), (LegendInfo)legend);
        HashMap<SystemTestData.LayerProperty, String> propertyMap = new HashMap<SystemTestData.LayerProperty, String>();
        propertyMap.put(SystemTestData.LayerProperty.STYLE, STYLE_NAME);
        testData.addRasterLayer(LAYER_QNAME, LAYER_FILE, null, propertyMap, SystemTestData.class, this.getCatalog());
        LegendInfoImpl legendWs = new LegendInfoImpl();
        legendWs.setWidth(22);
        legendWs.setHeight(22);
        legendWs.setFormat(LEGEND_FORMAT);
        legendWs.setOnlineResource(IMAGE_URL);
        Resource resourceWs = this.getResourceLoader().get("workspaces/gs/styles/legend.png");
        this.getResourceLoader().copyFromClassPath("../legend.png", resourceWs.file(), ((Object)((Object)this)).getClass());
        WorkspaceInfo wsInfo = this.getCatalog().getWorkspaceByName("gs");
        testData.addStyle(wsInfo, STYLE_NAME_WS, STYLE_FILE, ((Object)((Object)this)).getClass(), this.getCatalog(), (LegendInfo)legendWs);
        HashMap<SystemTestData.LayerProperty, String> propertyMapWs = new HashMap<SystemTestData.LayerProperty, String>();
        propertyMapWs.put(SystemTestData.LayerProperty.STYLE, STYLE_NAME_WS);
        testData.addRasterLayer(LAYER_QNAME_WS, LAYER_FILE, null, propertyMapWs, SystemTestData.class, this.getCatalog());
        this.addLayerWithHttpLegend(testData);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setProxyBaseUrl(BASE);
        this.getGeoServer().save(global);
        WMSInfo wms = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        wms.getSRS().add("EPSG:4326");
        this.getGeoServer().save((ServiceInfo)wms);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("", "http://www.opengis.net/wms");
        namespaces.put("wms", "http://www.opengis.net/wms");
        SystemTestData cfr_ignored_0 = (SystemTestData)this.getTestData();
        SystemTestData.registerNamespaces(namespaces);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
    }

    private void addLayerWithHttpLegend(SystemTestData testData) throws IOException {
        LegendInfoImpl legend = new LegendInfoImpl();
        legend.setWidth(22);
        legend.setHeight(22);
        legend.setFormat(LEGEND_FORMAT);
        legend.setOnlineResource(IMAGE_HTTP_URL);
        testData.addStyle(null, STYLE_NAME_HTTP, STYLE_FILE, ((Object)((Object)this)).getClass(), this.getCatalog(), (LegendInfo)legend);
        HashMap<SystemTestData.LayerProperty, String> propertyMap = new HashMap<SystemTestData.LayerProperty, String>();
        propertyMap.put(SystemTestData.LayerProperty.STYLE, STYLE_NAME);
        testData.addRasterLayer(LAYER_QNAME_HTP_LEGND, LAYER_FILE, null, propertyMap, SystemTestData.class, this.getCatalog());
    }

    @Test
    public void testCapabilities() throws Exception {
        Document dom = this.dom(this.get(CAPABILITIES_REQUEST), false);
        String expectedGetLegendGraphicRequestURL = "/ows?service=WMS&version=1.3.0&request=GetLegendGraphic&format=image%2Fjpeg&width=22&height=22&layer=gs%3Awatertemp";
        String expectedGetLegendGraphicRequestURLWS = "/ows?service=WMS&version=1.3.0&request=GetLegendGraphic&format=image%2Fjpeg&width=22&height=22&layer=gs%3Awatertemp_ws";
        String expectedGetLegendGraphicRequestURLHttp = "/ows?service=WMS&version=1.3.0&request=GetLegendGraphic&format=image%2Fjpeg&width=22&height=22&layer=gs%3Awatertemp_http_legend";
        String legendUrlPath = "//wms:Layer[wms:Name='gs:watertemp']/wms:Style/wms:LegendURL";
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(22), (String)"//wms:Layer[wms:Name='gs:watertemp']/wms:Style/wms:LegendURL/@width", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(22), (String)"//wms:Layer[wms:Name='gs:watertemp']/wms:Style/wms:LegendURL/@height", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)LEGEND_FORMAT, (String)"//wms:Layer[wms:Name='gs:watertemp']/wms:Style/wms:LegendURL/wms:Format", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)(BASE + expectedGetLegendGraphicRequestURL), (String)"//wms:Layer[wms:Name='gs:watertemp']/wms:Style/wms:LegendURL/wms:OnlineResource/@xlink:href", (Document)dom);
        String legendUrlPathWs = "//wms:Layer[wms:Name='gs:watertemp_ws']/wms:Style/wms:LegendURL";
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(22), (String)"//wms:Layer[wms:Name='gs:watertemp_ws']/wms:Style/wms:LegendURL/@width", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(22), (String)"//wms:Layer[wms:Name='gs:watertemp_ws']/wms:Style/wms:LegendURL/@height", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)LEGEND_FORMAT, (String)"//wms:Layer[wms:Name='gs:watertemp_ws']/wms:Style/wms:LegendURL/wms:Format", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)(BASE + expectedGetLegendGraphicRequestURLWS), (String)"//wms:Layer[wms:Name='gs:watertemp_ws']/wms:Style/wms:LegendURL/wms:OnlineResource/@xlink:href", (Document)dom);
        String legendUrlPathHTTPLegend = "//wms:Layer[wms:Name='gs:watertemp_http_legend']/wms:Style/wms:LegendURL";
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(22), (String)"//wms:Layer[wms:Name='gs:watertemp_http_legend']/wms:Style/wms:LegendURL/@width", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(22), (String)"//wms:Layer[wms:Name='gs:watertemp_http_legend']/wms:Style/wms:LegendURL/@height", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)LEGEND_FORMAT, (String)"//wms:Layer[wms:Name='gs:watertemp_http_legend']/wms:Style/wms:LegendURL/wms:Format", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)(BASE + expectedGetLegendGraphicRequestURLHttp), (String)"//wms:Layer[wms:Name='gs:watertemp_http_legend']/wms:Style/wms:LegendURL/wms:OnlineResource/@xlink:href", (Document)dom);
    }
}

