/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.staticRasterStore;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.media.jai.ImageLayout;
import org.geoserver.wms.staticRasterStore.StaticRasterFormat;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.geometry.GeneralBounds;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;

final class StaticRasterReader
extends AbstractGridCoverage2DReader {
    private static final BufferedImage STATIC_IMAGE = new BufferedImage(1, 1, 2);

    StaticRasterReader(Object source) {
        this.coverageFactory = new GridCoverageFactory();
        this.crs = DefaultGeographicCRS.WGS84;
        this.originalEnvelope = new GeneralBounds(CRS.getEnvelope((CoordinateReferenceSystem)this.crs));
        this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
        this.originalGridRange = new GeneralGridEnvelope((Bounds)this.originalEnvelope, PixelInCell.CELL_CENTER);
        this.setlayout(new ImageLayout((RenderedImage)STATIC_IMAGE));
    }

    public Format getFormat() {
        return new StaticRasterFormat();
    }

    public GridCoverage2D read(String coverageName, GeneralParameterValue[] readParameters) throws IOException {
        return this.coverageFactory.create((CharSequence)coverageName, (RenderedImage)STATIC_IMAGE, (Bounds)this.originalEnvelope);
    }

    public GridCoverage2D read(GeneralParameterValue[] parameters) throws IOException {
        return this.coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)STATIC_IMAGE, (Bounds)this.originalEnvelope);
    }

    public String[] getGridCoverageNames() {
        return new String[]{"STATIC_IMAGE"};
    }

    protected boolean checkName(String coverageName) {
        return true;
    }
}

