/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map.png;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.WMSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class GetMapIntegrationTest
extends WMSTestSupport {
    String bbox = "-2,0,2,6";
    String layers = this.getLayerId(MockData.BASIC_POLYGONS);

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpWcs11RasterLayers();
    }

    @Test
    public void testPngOpaque() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        try (ByteArrayInputStream is = this.getBinaryInputStream(response);){
            BufferedImage bi = ImageIO.read(is);
            ColorModel cm = bi.getColorModel();
            Assert.assertFalse((boolean)cm.hasAlpha());
            Assert.assertEquals((long)3L, (long)cm.getNumColorComponents());
        }
    }

    @Test
    public void testPngTransparent() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&transparent=true");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        try (ByteArrayInputStream is = this.getBinaryInputStream(response);){
            BufferedImage bi = ImageIO.read(is);
            ColorModel cm = bi.getColorModel();
            Assert.assertTrue((boolean)cm.hasAlpha());
            Assert.assertEquals((long)3L, (long)cm.getNumColorComponents());
        }
    }

    @Test
    public void testPng8Opaque() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png8&request=GetMap&width=550&height=250&srs=EPSG:4326");
        Assert.assertEquals((Object)"image/png; mode=8bit", (Object)response.getContentType());
        try (ByteArrayInputStream is = this.getBinaryInputStream(response);){
            BufferedImage bi = ImageIO.read(is);
            IndexColorModel cm = (IndexColorModel)bi.getColorModel();
            Assert.assertEquals((long)1L, (long)cm.getTransparency());
            Assert.assertEquals((long)-1L, (long)cm.getTransparentPixel());
        }
    }

    @Test
    public void testPng8ForceBitmask() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png8&request=GetMap&width=550&height=250&srs=EPSG:4326&transparent=true&format_options=quantizer:octree");
        Assert.assertEquals((Object)"image/png; mode=8bit", (Object)response.getContentType());
        try (ByteArrayInputStream is = this.getBinaryInputStream(response);){
            BufferedImage bi = ImageIO.read(is);
            IndexColorModel cm = (IndexColorModel)bi.getColorModel();
            Assert.assertEquals((long)2L, (long)cm.getTransparency());
            Assert.assertTrue((cm.getTransparentPixel() >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPng8Translucent() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png8&request=GetMap&width=550&height=250&srs=EPSG:4326&transparent=true");
        Assert.assertEquals((Object)"image/png; mode=8bit", (Object)response.getContentType());
        try (ByteArrayInputStream is = this.getBinaryInputStream(response);){
            BufferedImage bi = ImageIO.read(is);
            IndexColorModel cm = (IndexColorModel)bi.getColorModel();
            Assert.assertEquals((long)3L, (long)cm.getTransparency());
        }
    }

    @Test
    public void testwms2_0_0Filter() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png8&request=GetMap&width=550&height=250&srs=EPSG:4326&transparent=true");
        Assert.assertEquals((Object)"image/png; mode=8bit", (Object)response.getContentType());
        try (ByteArrayInputStream is = this.getBinaryInputStream(response);){
            BufferedImage bi = ImageIO.read(is);
            IndexColorModel cm = (IndexColorModel)bi.getColorModel();
            Assert.assertEquals((long)3L, (long)cm.getTransparency());
            Assert.assertEquals((long)cm.getMapSize(), (long)256L);
        }
        MockHttpServletResponse response1 = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&SERVICE=WMS&VERSION=1.1.1&Format=image/png8&request=GetMap&width=550&height=250&srs=EPSG:4326&transparent=true&FILTER=%3Cfes%3AFilter%20xmlns%3Axsi%3D%22http%3A%2F%2Fwww.w3.org%2F2001%2FXMLSchema-instance%22%20xmlns%3Agml%3D%22http%3A%2F%2Fwww.opengis.net%2Fgml%2F3.2%22%20xmlns%3Awfs%3D%22http%3A%2F%2Fwww.opengis.net%2Fwfs%22%20xmlns%3D%22http%3A%2F%2Fwww.opengis.net%2Ffes%2F2.0%22%20xmlns%3Afes%3D%22http%3A%2F%2Fwww.opengis.net%2Ffes%2F2.0%22%3E%3Cfes%3APropertyIsLike%20wildCard%3D%22*%22%20singleChar%3D%22.%22%20escapeChar%3D%22!%22%3E%3Cfes%3AValueReference%3EID%3C%2Ffes%3AValueReference%3E%3Cfes%3ALiteral%3E*0*%3C%2Ffes%3ALiteral%3E%3C%2Ffes%3APropertyIsLike%3E%3C%2Ffes%3AFilter%3E");
        Assert.assertEquals((Object)"image/png; mode=8bit", (Object)response1.getContentType());
        try (ByteArrayInputStream is1 = this.getBinaryInputStream(response1);){
            BufferedImage bi1 = ImageIO.read(is1);
            IndexColorModel cm1 = (IndexColorModel)bi1.getColorModel();
            Assert.assertEquals((long)2L, (long)cm1.getTransparency());
            Assert.assertTrue((cm1.getMapSize() < 256 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testwms1_1_0Filter() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png8&request=GetMap&width=550&height=250&srs=EPSG:4326&transparent=true");
        Assert.assertEquals((Object)"image/png; mode=8bit", (Object)response.getContentType());
        try (ByteArrayInputStream is = this.getBinaryInputStream(response);){
            BufferedImage bi = ImageIO.read(is);
            IndexColorModel cm = (IndexColorModel)bi.getColorModel();
            Assert.assertEquals((long)3L, (long)cm.getTransparency());
            Assert.assertEquals((long)cm.getMapSize(), (long)256L);
        }
        MockHttpServletResponse response1 = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&SERVICE=WMS&VERSION=1.1.1&Format=image/png8&request=GetMap&width=550&height=250&srs=EPSG:4326&transparent=true&FILTER=%3Cogc%3AFilter%0A%09xmlns%3Agml%3D%22http%3A%2F%2Fwww.opengis.net%2Fgml%22%0A%09xmlns%3Aogc%3D%22http%3A%2F%2Fwww.opengis.net%2Fogc%22%3E%0A%09%3Cogc%3APropertyIsLike%20wildCard%3D%22*%22%20singleChar%3D%22.%22%20escapeChar%3D%22!%22%20matchCase%3D%22false%22%3E%0A%09%09%3Cogc%3APropertyName%3EID%3C%2Fogc%3APropertyName%3E%0A%09%09%3Cogc%3ALiteral%3E*1*%3C%2Fogc%3ALiteral%3E%0A%09%3C%2Fogc%3APropertyIsLike%3E%0A%09%3Cogc%3ASortBy%3E%0A%20%20%20%20%3Cogc%3APropertyName%3EID%3C%2Fogc%3APropertyName%3E%0A%20%20%20%20%3Cogc%3ASortOrderType%3EASCENDING%3C%2Fogc%3ASortOrderType%3E%0A%20%20%3C%2Fogc%3ASortBy%3E%0A%3C%2Fogc%3AFilter%3E");
        Assert.assertEquals((Object)"image/png; mode=8bit", (Object)response.getContentType());
        try (ByteArrayInputStream is1 = this.getBinaryInputStream(response1);){
            BufferedImage bi1 = ImageIO.read(is1);
            IndexColorModel cm1 = (IndexColorModel)bi1.getColorModel();
            Assert.assertEquals((long)2L, (long)cm1.getTransparency());
            Assert.assertTrue((cm1.getMapSize() < 256 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testwms1_0_0Filter() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png8&request=GetMap&width=550&height=250&srs=EPSG:4326&transparent=true");
        Assert.assertEquals((Object)"image/png; mode=8bit", (Object)response.getContentType());
        try (ByteArrayInputStream is = this.getBinaryInputStream(response);){
            BufferedImage bi = ImageIO.read(is);
            IndexColorModel cm = (IndexColorModel)bi.getColorModel();
            Assert.assertEquals((long)3L, (long)cm.getTransparency());
            Assert.assertEquals((long)cm.getMapSize(), (long)256L);
        }
        MockHttpServletResponse response1 = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&SERVICE=WMS&VERSION=1.1.1&Format=image/png8&request=GetMap&width=550&height=250&srs=EPSG:4326&transparent=true&FILTER=%3Cogc%3AFilter%0A%09xmlns%3Agml%3D%22http%3A%2F%2Fwww.opengis.net%2Fgml%22%0A%09xmlns%3Aogc%3D%22http%3A%2F%2Fwww.opengis.net%2Fogc%22%3E%0A%09%3Cogc%3APropertyIsLike%20wildCard%3D%22*%22%20singleChar%3D%22.%22%20escapeChar%3D%22!%22%20%3E%0A%09%09%3Cogc%3APropertyName%3EID%3C%2Fogc%3APropertyName%3E%0A%09%09%3Cogc%3ALiteral%3E*1*%3C%2Fogc%3ALiteral%3E%0A%09%3C%2Fogc%3APropertyIsLike%3E%0A%3C%2Fogc%3AFilter%3E");
        Assert.assertEquals((Object)"image/png; mode=8bit", (Object)response1.getContentType());
        try (ByteArrayInputStream is1 = this.getBinaryInputStream(response1);){
            BufferedImage bi1 = ImageIO.read(is1);
            IndexColorModel cm1 = (IndexColorModel)bi1.getColorModel();
            Assert.assertEquals((long)2L, (long)cm1.getTransparency());
            Assert.assertTrue((cm1.getMapSize() < 256 ? 1 : 0) != 0);
        }
    }
}

