/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.map.GetMapKvpRequestReader;
import org.geoserver.wms.map.GetMapKvpRequestReaderTest;
import org.geoserver.wms.map.GetMapXmlReader;
import org.geoserver.wms.map.RenderTimeStatistics;
import org.geotools.api.style.Style;
import org.geotools.image.ImageWorker;
import org.geotools.image.test.ImageAssert;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class GetMapIntegrationTest
extends WMSTestSupport {
    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpWcs10RasterLayers();
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        testData.addStyle("indexed", "indexed.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("crop_raster", "CropTransform.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("lakeScale", "lakeScale.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("channelSelector", "channelSelector.sld", ((Object)((Object)this)).getClass(), catalog);
        HashMap<SystemTestData.LayerProperty, String> props = new HashMap<SystemTestData.LayerProperty, String>();
        props.put(SystemTestData.LayerProperty.STYLE, "indexed");
        testData.addRasterLayer(new QName(MockData.SF_URI, "indexed", MockData.SF_PREFIX), "indexed.tif", "tif", props, ((Object)((Object)this)).getClass(), catalog);
        props.put(SystemTestData.LayerProperty.STYLE, "raster");
        testData.addRasterLayer(new QName(MockData.SF_URI, "paletted", MockData.SF_PREFIX), "paletted.tif", "tif", props, ((Object)((Object)this)).getClass(), catalog);
        testData.addRasterLayer(new QName(MockData.SF_URI, "mosaic", MockData.SF_PREFIX), "raster-filter-test.zip", null, props, SystemTestData.class, catalog);
        testData.addRasterLayer(new QName(MockData.SF_URI, "fourbits", MockData.SF_PREFIX), "fourbits.zip", null, props, SystemTestData.class, catalog);
        testData.addRasterLayer(new QName(MockData.SF_URI, "multiband", MockData.SF_PREFIX), "multiband.tiff", null, props, SystemTestData.class, catalog);
        testData.addStyle("BasicStyleGroup", "BasicStyleGroup.sld", GetMapKvpRequestReaderTest.class, this.getCatalog());
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        StyleInfo s = catalog.getStyleByName("BasicStyleGroup");
        lg.setName("BasicStyleGroup");
        lg.getLayers().add(null);
        lg.getStyles().add(s);
        catalog.add(lg);
    }

    @Test
    public void testIndexed() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?LAYERS=sf:indexed&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=100,78,104,80&WIDTH=300&HEIGHT=150");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        RenderedImage image = ImageIO.read(this.getBinaryInputStream(response));
        image = new ImageWorker(image).forceComponentColorModel().getRenderedImage();
        ImageAssert.assertEquals((File)new File("src/test/resources/org/geoserver/wms/map/indexed-expected.png"), (RenderedImage)image, (int)0);
    }

    @Test
    public void testIndexedBlackBG() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bgcolor=0x000000&LAYERS=sf:indexed&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=100,78,104,80&WIDTH=300&HEIGHT=150&transparent=false");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        ImageAssert.assertEquals((File)new File("src/test/resources/org/geoserver/wms/map/indexed-bg-expected.png"), (RenderedImage)image, (int)0);
    }

    @Test
    public void testRasterFilterRed() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&transparent=false&CQL_FILTER=location like 'red%25'");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        Assert.assertEquals((Object)Color.RED, (Object)this.getPixelColor(image, 5, 10));
    }

    @Test
    public void testRasterFilterRedClip() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&transparent=false&CQL_FILTER=location like 'red%25'&clip=POLYGON((0 0, 1 0, 0 1, 0 0))");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        Assert.assertEquals((Object)Color.RED, (Object)this.getPixelColor(image, 5, 10));
        Assert.assertEquals((Object)Color.BLACK, (Object)this.getPixelColor(image, 15, 10));
    }

    @Test
    public void testRasterFilterGreen() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&transparent=false&CQL_FILTER=location like 'green%25'");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        Assert.assertEquals((Object)Color.GREEN, (Object)this.getPixelColor(image, 5, 10));
    }

    @Test
    public void testEmptyCQLFilter() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&transparent=false&CQL_FILTER=");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
    }

    @Test
    public void testRasterFilterGreenClip() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&transparent=false&CQL_FILTER=location like 'green%25'&clip=POLYGON((0 0, 1 0, 0 1, 0 0))");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        Assert.assertEquals((Object)Color.GREEN, (Object)this.getPixelColor(image, 5, 10));
        Assert.assertEquals((Object)Color.BLACK, (Object)this.getPixelColor(image, 15, 10));
    }

    @Test
    public void testMosaicTwice() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&transparent=false");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        response = this.getAsServletResponse("wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&transparent=false");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
    }

    @Test
    public void testIndexedTransparency() throws Exception {
        String request = "wms?LAYERS=sf:paletted&STYLES=&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A3174&BBOX=-3256153.625,826440.25,-2756153.625,1326440.25&WIDTH=256&HEIGHT=256&transparent=true";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        Assert.assertTrue((boolean)image.getColorModel().hasAlpha());
        int[] rgba = new int[4];
        image.getData().getPixel(0, 0, rgba);
        Assert.assertEquals((long)0L, (long)rgba[3]);
        image.getData().getPixel(255, 255, rgba);
        Assert.assertEquals((long)255L, (long)rgba[3]);
    }

    @Test
    public void testFourBits() throws Exception {
        String request = "wms?LAYERS=sf:fourbits&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A4269&BBOX=-118.58930224611,45.862378906251,-118.33030957033,45.974688476563&WIDTH=761&HEIGHT=330";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
    }

    @Test
    public void testMetaWMS13() throws Exception {
        String wms11 = "wms?LAYERS=cite%3ALakes&STYLES=&FORMAT=image%2Fpng&TILED=true&TILESORIGIN=0.0006%2C-0.0018&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A4326&BBOX=0.0006,-0.0018,0.0031,0.0007&WIDTH=256&HEIGHT=256";
        String wms13 = "wms?LAYERS=cite%3ALakes&STYLES=&FORMAT=image%2Fpng&TILED=true&TILESORIGIN=-0.0018%2C0.0006&SERVICE=WMS&VERSION=1.3.0&REQUEST=GetMap&CRS=EPSG%3A4326&BBOX=-0.0018,0.0006,0.0007,0.0031&WIDTH=256&HEIGHT=256";
        BufferedImage image11 = this.getAsImage(wms11, "image/png");
        BufferedImage image13 = this.getAsImage(wms13, "image/png");
        Assert.assertEquals((long)image11.getWidth(), (long)image13.getWidth());
        Assert.assertEquals((long)image11.getHeight(), (long)image13.getHeight());
        Assert.assertEquals((Object)image11.getColorModel(), (Object)image13.getColorModel());
        Assert.assertEquals((Object)image11.getSampleModel(), (Object)image13.getSampleModel());
        DataBufferByte db11 = (DataBufferByte)image11.getData().getDataBuffer();
        DataBufferByte db13 = (DataBufferByte)image13.getData().getDataBuffer();
        byte[][] bankData11 = db11.getBankData();
        byte[][] bankData13 = db13.getBankData();
        for (int i = 0; i < bankData11.length; ++i) {
            Assert.assertArrayEquals((byte[])bankData11[i], (byte[])bankData13[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpenLayersProxy() throws Exception {
        NamespaceContext oldContext = XMLUnit.getXpathNamespaceContext();
        try {
            HashMap<String, String> namespaces = new HashMap<String, String>();
            namespaces.put("xhtml", "http://www.w3.org/1999/xhtml");
            this.registerNamespaces(namespaces);
            XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
            GeoServerInfo global = this.getGeoServer().getGlobal();
            global.getSettings().setProxyBaseUrl("http://www.geoserver.org:1234/gs");
            this.getGeoServer().save(global);
            Document dom = this.getAsDOM("wms?LAYERS=sf:indexed&STYLES=&FORMAT=application/openlayers&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=100,78,104,80&WIDTH=300&HEIGHT=150");
            XMLAssert.assertXpathEvaluatesTo((String)"//www.geoserver.org:1234/gs/openlayers/OpenLayers.js", (String)"//xhtml:script[contains(@src, 'OpenLayers.js')]/@src", (Document)dom);
        }
        finally {
            XMLUnit.setXpathNamespaceContext((NamespaceContext)oldContext);
        }
    }

    @Test
    public void testRasterRenderingTx() throws Exception {
        String layer = this.getLayerId(MockData.USA_WORLDIMG);
        String url = "wms?service=WMS&VERSION=1.1.1&request=GetMap&styles=&format=image/png&layers=" + layer + "&WIDTH=100&HEIGHT=100&srs=epsg:4326&BBOX=-130,49,-125,54";
        BufferedImage image = this.getAsImage(url, "image/png");
        Color color = this.getPixelColor(image, 25, 25);
        Assert.assertTrue((color.getRed() + color.getGreen() + color.getBlue() < 750 ? 1 : 0) != 0);
        url = "wms?service=WMS&VERSION=1.1.1&request=GetMap&styles=crop_raster&format=image/png&layers=" + layer + "&WIDTH=100&HEIGHT=100&srs=epsg:4326&BBOX=-130,49,-125,54";
        image = this.getAsImage(url, "image/png");
        color = this.getPixelColor(image, 25, 25);
        Assert.assertTrue((color.getRed() + color.getGreen() + color.getBlue() > 750 ? 1 : 0) != 0);
    }

    @Test
    public void testRasterRenderingTxOutOfBbox() throws Exception {
        String layer = this.getLayerId(MockData.USA_WORLDIMG);
        String url = "wms?service=WMS&VERSION=1.1.1&request=GetMap&styles=crop_raster&format=image/png&layers=" + layer + "&WIDTH=100&HEIGHT=100&srs=epsg:4326&BBOX=-120,40,-115,45";
        BufferedImage image = this.getAsImage(url, "image/png");
        Color color = this.getPixelColor(image, 25, 25);
        Assert.assertTrue((color.getRed() + color.getGreen() + color.getBlue() > 750 ? 1 : 0) != 0);
    }

    @Test
    public void testGetMapWithPropertyStyle() throws Exception {
        Properties props = new Properties();
        props.put("type", "point");
        props.put("color", "00ffff");
        StringWriter w = new StringWriter();
        props.store(w, null);
        String bbox = "-180,-90,180,90";
        String layer = this.getLayerId(CiteTestData.POINTS);
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + bbox + "&layers=" + layer + "&sld_body=" + w.toString() + "&style_format=psl&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326");
        this.checkImage(response);
    }

    @Test
    public void testScaleMethod() throws Exception {
        String request = "wms?&LAYERS=" + this.getLayerId(MockData.LAKES) + "&STYLES=lakeScale&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A4326&BBOX=0,-0.002,0.00451,0&WIDTH=88&HEIGHT=44";
        BufferedImage bi = this.getAsImage(request, "image/png");
        this.assertNotBlank("Image should contain the polygon,  scale denominator 20k", bi);
        bi = this.getAsImage(request + "&scaleMethod=Accurate", "image/png");
        this.assertBlank("Image should not contain the polygon, scale is just below 1:20", bi);
    }

    @Test
    public void testStyleGroup() throws Exception {
        WMS wms = new WMS(this.getGeoServer());
        GetMapKvpRequestReader reader = new GetMapKvpRequestReader(wms);
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("layers", "BasicStyleGroup");
        kvp.put("styles", "");
        GetMapRequest request = reader.createRequest();
        request = reader.read((Object)request, this.parseKvp(kvp), kvp);
        Assert.assertNotNull((Object)request.getLayers());
        Assert.assertNotNull((Object)request.getStyles());
    }

    @Test
    public void testResolveLayersForStyleGroup() throws Exception {
        WMS wms = new WMS(this.getGeoServer());
        GetMapXmlReader reader = new GetMapXmlReader(wms);
        GetMapRequest request = reader.createRequest();
        try (InputStream resourceStream = ((Object)((Object)this)).getClass().getResource("WMSPostLayerGroupWithStyleGroup.xml").openStream();
             BufferedReader input = new BufferedReader(new InputStreamReader(resourceStream));){
            request = (GetMapRequest)reader.read((Object)request, (Reader)input, new HashMap());
            String layer = MockData.BASIC_POLYGONS.getLocalPart();
            Assert.assertEquals((long)1L, (long)request.getLayers().size());
            Assert.assertTrue((boolean)((MapLayerInfo)request.getLayers().get(0)).getName().endsWith(layer));
            Assert.assertEquals((long)1L, (long)request.getStyles().size());
            Style expected = this.getCatalog().getStyleByName("BasicStyleGroup").getStyle();
            Style style = (Style)request.getStyles().get(0);
            Assert.assertEquals((Object)expected, (Object)style);
        }
    }

    @Test
    public void testChannelSelectionEnvVar() throws Exception {
        String request = "wms?&LAYERS=" + this.getLayerId(MockData.BASIC_POLYGONS) + ",sf:multiband&STYLES=polygon,channelSelector&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A32611&BBOX=508880,3551340,748865,3750000&WIDTH=64&HEIGHT=64";
        File BASE = new File("src/test/resources/org/geoserver/wms/map");
        BufferedImage bi = this.getAsImage(request + "&env=band:1", "image/png");
        ImageAssert.assertEquals((File)new File(BASE, "csFirstChannel.png"), (RenderedImage)bi, (int)0);
        bi = this.getAsImage(request + "&env=band:5", "image/png");
        ImageAssert.assertEquals((File)new File(BASE, "csMidChannel.png"), (RenderedImage)bi, (int)0);
        bi = this.getAsImage(request + "&env=band:9", "image/png");
        ImageAssert.assertEquals((File)new File(BASE, "csLastChannel.png"), (RenderedImage)bi, (int)0);
    }

    @Test
    public void testRenderTimeStatisticsVectorsIntegrationTest() throws Exception {
        String bbox = "-180,-90,180,90";
        String layer = this.getLayerId(CiteTestData.POINTS);
        String layer2 = this.getLayerId(CiteTestData.POLYGONS);
        MockHttpServletRequest request = this.createRequest("wms?bbox=" + bbox + "&layers=" + layer + "," + layer2 + "&style_format=psl&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326");
        request.setMethod("GET");
        request.setContent(new byte[0]);
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        RenderTimeStatistics statistics = (RenderTimeStatistics)request.getAttribute("statistics");
        Assert.assertEquals((long)statistics.getLayerNames().size(), (long)2L);
        Assert.assertNotNull((Object)statistics.getRenderingTime(Integer.valueOf(0)));
        Assert.assertNotNull((Object)statistics.getRenderingTime(Integer.valueOf(1)));
        Assert.assertNotNull((Object)statistics.getLabellingTime());
        this.checkImage(response);
    }

    @Test
    public void testRenderTimeStatisticsRasterIntegrationTest() throws Exception {
        MockHttpServletRequest request = this.createRequest("wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&transparent=false&CQL_FILTER=location like 'green%25'");
        request.setMethod("GET");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        RenderTimeStatistics statistics = (RenderTimeStatistics)request.getAttribute("statistics");
        Assert.assertEquals((long)statistics.getLayerNames().size(), (long)1L);
        Assert.assertNotNull((Object)statistics.getRenderingTime(Integer.valueOf(0)));
        this.checkImage(response);
    }
}

