/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.Color;
import org.geoserver.wms.legendgraphic.LegendUtils;
import org.geoserver.wms.legendgraphic.RasterLayerLegendHelper;
import org.geotools.api.style.ColorMap;
import org.geotools.api.style.ColorMapEntry;
import org.geotools.brewer.styling.builder.ColorMapBuilder;
import org.junit.Assert;
import org.junit.Test;

public class RasterLayerLegendHelperTest {
    @Test
    public void testRemoveDuplicatesNoLabel() throws Exception {
        ColorMapBuilder cmb = new ColorMapBuilder();
        cmb.entry().quantity(1.0).color(Color.BLACK);
        cmb.entry().quantity(2.0).color(Color.BLACK);
        cmb.entry().quantity(3.0).color(Color.WHITE);
        cmb.entry().quantity(4.0).color(Color.RED);
        cmb.entry().quantity(5.0).color(Color.RED);
        cmb.entry().quantity(6.0).color(Color.BLACK);
        ColorMap cm = cmb.build();
        ColorMapEntry[] entries = cm.getColorMapEntries();
        ColorMapEntry[] valid = RasterLayerLegendHelper.removeDuplicates((ColorMapEntry[])entries);
        Assert.assertEquals((long)3L, (long)valid.length);
        Assert.assertEquals((Object)Color.BLACK, (Object)LegendUtils.color((ColorMapEntry)valid[0]));
        Assert.assertEquals((Object)Color.WHITE, (Object)LegendUtils.color((ColorMapEntry)valid[1]));
        Assert.assertEquals((Object)Color.RED, (Object)LegendUtils.color((ColorMapEntry)valid[2]));
    }

    @Test
    public void testRemoveDuplicatesWithLabel() throws Exception {
        ColorMapBuilder cmb = new ColorMapBuilder();
        cmb.entry().quantity(1.0).color(Color.BLACK).label("one");
        cmb.entry().quantity(1.0).color(Color.BLACK).label("one");
        cmb.entry().quantity(1.0).color(Color.WHITE).label("one");
        cmb.entry().quantity(10.0).color(Color.RED).label("two");
        cmb.entry().quantity(10.0).color(Color.RED).label("two");
        cmb.entry().quantity(10.0).color(Color.BLACK).label("two");
        ColorMap cm = cmb.build();
        ColorMapEntry[] entries = cm.getColorMapEntries();
        ColorMapEntry[] valid = RasterLayerLegendHelper.removeDuplicates((ColorMapEntry[])entries);
        Assert.assertEquals((long)4L, (long)valid.length);
        Assert.assertEquals((Object)Color.BLACK, (Object)LegendUtils.color((ColorMapEntry)valid[0]));
        Assert.assertEquals((Object)Color.BLACK, (Object)LegendUtils.color((ColorMapEntry)valid[0]));
        Assert.assertEquals((Object)Color.WHITE, (Object)LegendUtils.color((ColorMapEntry)valid[1]));
        Assert.assertEquals((Object)Color.RED, (Object)LegendUtils.color((ColorMapEntry)valid[2]));
    }
}

