/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.kvp;

import java.awt.image.IndexColorModel;
import org.geoserver.wms.kvp.PaletteManager;
import org.geotools.image.palette.InverseColorMapOp;
import org.junit.Assert;
import org.junit.Test;

public class PaletteManagerTest {
    @Test
    public void testSameIndexColorModel() {
        IndexColorModel safePalette = PaletteManager.safePalette;
        InverseColorMapOp op1 = PaletteManager.getInverseColorMapOp((IndexColorModel)safePalette);
        InverseColorMapOp op2 = PaletteManager.getInverseColorMapOp((IndexColorModel)safePalette);
        Assert.assertEquals((Object)op1, (Object)op2);
    }

    @Test
    public void testDifferentColorModels() {
        IndexColorModel safePalette = PaletteManager.safePalette;
        IndexColorModel grayPalette = PaletteManagerTest.buildGrayPalette();
        InverseColorMapOp op1 = PaletteManager.getInverseColorMapOp((IndexColorModel)safePalette);
        InverseColorMapOp op2 = PaletteManager.getInverseColorMapOp((IndexColorModel)grayPalette);
        Assert.assertNotEquals((Object)op1, (Object)op2);
    }

    static IndexColorModel buildGrayPalette() {
        int[] cmap = new int[256];
        int opaqueAlpha = -16777216;
        for (int i = 0; i < 255; ++i) {
            cmap[i] = 0xFF000000 | i << 16 | i << 8 | i;
        }
        cmap[255] = 0xFFFFFF;
        return new IndexColorModel(8, 256, cmap, 0, true, 255, 0);
    }
}

