/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import it.geosolutions.imageio.pam.PAMDataset;
import it.geosolutions.imageio.pam.PAMParser;
import java.io.File;
import java.util.ArrayList;
import org.geoserver.wms.featureinfo.AttributeTableEnricher;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.junit.Assert;
import org.junit.Test;

public class AttributeTableEnricherTest {
    private static final double EPS = 1.0E-6;
    static File ROOT = new File("./src/test/resources/org/geoserver/wms/featureinfo");

    @Test
    public void testRanges() throws Exception {
        PAMParser parser = new PAMParser();
        PAMDataset pam = parser.parsePAM(new File(ROOT, "rat.tiff.aux.xml"));
        PAMDataset.PAMRasterBand band = (PAMDataset.PAMRasterBand)pam.getPAMRasterBand().get(0);
        AttributeTableEnricher enricher = new AttributeTableEnricher(band);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("test");
        tb.add("gray", Integer.class);
        enricher.addAttributes(tb);
        SimpleFeatureType schema = tb.buildFeatureType();
        Assert.assertEquals((long)4L, (long)schema.getAttributeCount());
        Assert.assertEquals(Integer.class, (Object)schema.getDescriptor("gray").getType().getBinding());
        Assert.assertEquals(Double.class, (Object)schema.getDescriptor("con_min").getType().getBinding());
        Assert.assertEquals(Double.class, (Object)schema.getDescriptor("con_max").getType().getBinding());
        Assert.assertEquals(String.class, (Object)schema.getDescriptor("test").getType().getBinding());
        ArrayList values = new ArrayList();
        enricher.addRowValues(values, new double[]{1.1});
        Assert.assertEquals((double)1.0, (double)((Double)values.get(0)), (double)1.0E-6);
        Assert.assertEquals((double)1.2, (double)((Double)values.get(1)), (double)1.0E-6);
        Assert.assertEquals((Object)"green", values.get(2));
        values = new ArrayList();
        enricher.addRowValues(values, new double[]{12.1});
        Assert.assertEquals((double)12.1, (double)((Double)values.get(0)), (double)1.0E-6);
        Assert.assertEquals((double)12.3, (double)((Double)values.get(1)), (double)1.0E-6);
        Assert.assertEquals((Object)"purple", values.get(2));
        values = new ArrayList();
        enricher.addRowValues(values, new double[]{1000000.0});
        Assert.assertEquals((long)3L, (long)values.size());
        for (int i = 0; i < 3; ++i) {
            Assert.assertNull(values.get(i));
        }
    }

    @Test
    public void testExactMatch() throws Exception {
        PAMParser parser = new PAMParser();
        PAMDataset pam = parser.parsePAM(new File(ROOT, "rat_int.xml"));
        PAMDataset.PAMRasterBand band = (PAMDataset.PAMRasterBand)pam.getPAMRasterBand().get(0);
        AttributeTableEnricher enricher = new AttributeTableEnricher(band);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("test");
        tb.add("gray", Integer.class);
        enricher.addAttributes(tb);
        SimpleFeatureType schema = tb.buildFeatureType();
        Assert.assertEquals((long)9L, (long)schema.getAttributeCount());
        Assert.assertEquals(Long.class, (Object)schema.getDescriptor("Value").getType().getBinding());
        Assert.assertEquals(Long.class, (Object)schema.getDescriptor("Count").getType().getBinding());
        Assert.assertEquals(String.class, (Object)schema.getDescriptor("Class").getType().getBinding());
        Assert.assertEquals(String.class, (Object)schema.getDescriptor("Class2").getType().getBinding());
        Assert.assertEquals(String.class, (Object)schema.getDescriptor("Class3").getType().getBinding());
        Assert.assertEquals(Long.class, (Object)schema.getDescriptor("Red").getType().getBinding());
        Assert.assertEquals(Long.class, (Object)schema.getDescriptor("Green").getType().getBinding());
        Assert.assertEquals(Long.class, (Object)schema.getDescriptor("Blue").getType().getBinding());
        ArrayList values = new ArrayList();
        enricher.addRowValues(values, new double[]{4.0});
        Assert.assertEquals((Object)4L, values.get(0));
        Assert.assertEquals((Object)2L, values.get(1));
        Assert.assertEquals((Object)"two", values.get(2));
        Assert.assertEquals((Object)"two2", values.get(3));
        Assert.assertEquals((Object)"two3", values.get(4));
        Assert.assertEquals((Object)200L, values.get(5));
        Assert.assertEquals((Object)30L, values.get(6));
        Assert.assertEquals((Object)50L, values.get(7));
        values = new ArrayList();
        enricher.addRowValues(values, new double[]{-10.0});
        Assert.assertEquals((long)8L, (long)values.size());
        for (int i = 0; i < 8; ++i) {
            Assert.assertNull(values.get(i));
        }
    }
}

