/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.TimeZone;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.util.ISO8601Formatter;
import org.geoserver.wms.WMS;
import org.geoserver.wms.capabilities.DimensionHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.Attributes;

public class DimensionHelperTest {
    protected DimensionHelper dimensionHelper;

    @Before
    public void setUp() {
        this.dimensionHelper = new DimensionHelper(DimensionHelper.Mode.WMS13, WMS.get()){

            protected void element(String element, String content, Attributes atts) {
            }

            protected void element(String element, String content) {
            }
        };
    }

    @Test
    public void testGetCustomDomainRepresentation() {
        String[] vals = new String[]{"value with spaces", "value", "  other values "};
        ArrayList<String> values = new ArrayList<String>();
        for (String val : vals) {
            values.add(val);
        }
        DimensionInfoImpl dimensionInfo = new DimensionInfoImpl();
        dimensionInfo.setPresentation(DimensionPresentation.LIST);
        dimensionInfo.setResolution(BigDecimal.valueOf(1L));
        String customDimRepr = this.dimensionHelper.getCustomDomainRepresentation((DimensionInfo)dimensionInfo, values);
        org.locationtech.jts.util.Assert.equals((Object)customDimRepr, (Object)(vals[0] + "," + vals[1] + "," + vals[2].trim()));
    }

    @Test
    public void testNegativeYears() {
        ISO8601Formatter fmt = new ISO8601Formatter();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.clear();
        cal.set(1, 1);
        Assert.assertEquals((Object)"0001-01-01T00:00:00.000Z", (Object)fmt.format(cal.getTime()));
        cal.add(1, -1);
        Assert.assertEquals((Object)"0000-01-01T00:00:00.000Z", (Object)fmt.format(cal.getTime()));
        cal.add(1, -1);
        Assert.assertEquals((Object)"-0001-01-01T00:00:00.000Z", (Object)fmt.format(cal.getTime()));
        cal.set(1, 265000001);
        Assert.assertEquals((Object)"-265000000-01-01T00:00:00.000Z", (Object)fmt.format(cal.getTime()));
    }

    @Test
    public void testFormatterFuzz() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        ISO8601Formatter fmt = new ISO8601Formatter();
        GregorianCalendar cal = new GregorianCalendar();
        Random r = new Random();
        for (int i = 0; i < 1000; ++i) {
            cal.set(1, 1 + r.nextInt(3000));
            cal.set(6, 1 + r.nextInt(365));
            cal.set(11, r.nextInt(24));
            cal.set(12, r.nextInt(60));
            cal.set(13, r.nextInt(60));
            cal.set(14, r.nextInt(1000));
            Assert.assertEquals((Object)df.format(cal.getTime()), (Object)fmt.format(cal.getTime()));
        }
    }

    @Test
    public void testPadding() throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        ISO8601Formatter fmt = new ISO8601Formatter();
        Assert.assertEquals((Object)"0010-01-01T00:01:10.001Z", (Object)fmt.format(df.parse("0010-01-01T00:01:10.001")));
        Assert.assertEquals((Object)"0100-01-01T00:01:10.011Z", (Object)fmt.format(df.parse("0100-01-01T00:01:10.011")));
        Assert.assertEquals((Object)"1000-01-01T00:01:10.111Z", (Object)fmt.format(df.parse("1000-01-01T00:01:10.111")));
    }
}

