/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import java.util.HashMap;
import java.util.Map;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.capabilities.CapabilitiesKvpReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CapabilitiesKvpReaderTest {
    private CapabilitiesKvpReader reader;
    private HashMap kvp;
    private HashMap rawKvp;

    @Before
    public void setUp() {
        this.reader = new CapabilitiesKvpReader(new WMS(null));
        this.kvp = new HashMap();
        this.rawKvp = new HashMap();
    }

    @Test
    public void testDefault() throws Exception {
        this.rawKvp.put("request", "getcapabilities");
        this.kvp.put("request", "getcapabilities");
        GetCapabilitiesRequest read = this.reader.read(this.reader.createRequest(), (Map)this.kvp, (Map)this.rawKvp);
        Assert.assertNotNull((Object)read);
        Assert.assertEquals((Object)"getcapabilities", (Object)read.getRequest().toLowerCase());
        Assert.assertNull((Object)read.getBaseUrl());
        Assert.assertNull((Object)read.getNamespace());
    }

    @Test
    public void testWMTVER() throws Exception {
        this.rawKvp.put("WMTVER", "1.0");
        GetCapabilitiesRequest read = this.reader.read(this.reader.createRequest(), (Map)this.kvp, (Map)this.rawKvp);
        Assert.assertNotNull((Object)read);
        Assert.assertEquals((Object)"1.1.1", (Object)read.getVersion());
    }

    @Test
    public void testVersion() throws Exception {
        this.kvp.put("Version", "1.1.1");
        GetCapabilitiesRequest read = this.reader.read(this.reader.createRequest(), (Map)this.kvp, (Map)this.rawKvp);
        Assert.assertNotNull((Object)read);
        Assert.assertEquals((Object)"1.1.1", (Object)read.getVersion());
    }

    @Test
    public void testNamespace() throws Exception {
        this.kvp.put("namespace", "og");
        GetCapabilitiesRequest read = this.reader.read(this.reader.createRequest(), (Map)this.kvp, (Map)this.rawKvp);
        Assert.assertNotNull((Object)read);
        Assert.assertEquals((Object)"og", (Object)read.getNamespace());
    }

    @Test
    public void testUpdateSequence() throws Exception {
        this.kvp.put("updateSequence", "1000");
        GetCapabilitiesRequest read = this.reader.read(this.reader.createRequest(), (Map)this.kvp, (Map)this.rawKvp);
        Assert.assertNotNull((Object)read);
        Assert.assertEquals((Object)"1000", (Object)read.getUpdateSequence());
    }

    @Test
    public void testRootLayerDefault() throws Exception {
        GetCapabilitiesRequest read = this.reader.read(this.reader.createRequest(), (Map)this.kvp, (Map)this.rawKvp);
        Assert.assertNotNull((Object)read);
        Assert.assertNull((Object)read.isRootLayerEnabled());
    }

    @Test
    public void testRootLayerEnabled() throws Exception {
        this.kvp.put("rootLayer", "true");
        this.rawKvp.put("ROOTLAYER", "true");
        GetCapabilitiesRequest read = this.reader.read(this.reader.createRequest(), (Map)this.kvp, (Map)this.rawKvp);
        Assert.assertNotNull((Object)read);
        Assert.assertTrue((boolean)read.isRootLayerEnabled());
    }

    @Test
    public void testRootLayerRemoved() throws Exception {
        this.kvp.put("rootLayer", "false");
        this.rawKvp.put("ROOTLAYER", "false");
        GetCapabilitiesRequest read = this.reader.read(this.reader.createRequest(), (Map)this.kvp, (Map)this.rawKvp);
        Assert.assertNotNull((Object)read);
        Assert.assertFalse((boolean)read.isRootLayerEnabled());
    }
}

